/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.identity.model.UpdateSmtpCredentialDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateSmtpCredentialRequest
extends BmcRequest<UpdateSmtpCredentialDetails> {
    private String userId;
    private String smtpCredentialId;
    private UpdateSmtpCredentialDetails updateSmtpCredentialDetails;
    private String ifMatch;

    public String getUserId() {
        return this.userId;
    }

    public String getSmtpCredentialId() {
        return this.smtpCredentialId;
    }

    public UpdateSmtpCredentialDetails getUpdateSmtpCredentialDetails() {
        return this.updateSmtpCredentialDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public UpdateSmtpCredentialDetails getBody$() {
        return this.updateSmtpCredentialDetails;
    }

    public Builder toBuilder() {
        return new Builder().userId(this.userId).smtpCredentialId(this.smtpCredentialId).updateSmtpCredentialDetails(this.updateSmtpCredentialDetails).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",userId=").append(String.valueOf(this.userId));
        sb.append(",smtpCredentialId=").append(String.valueOf(this.smtpCredentialId));
        sb.append(",updateSmtpCredentialDetails=").append(String.valueOf((Object)this.updateSmtpCredentialDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateSmtpCredentialRequest)) {
            return false;
        }
        UpdateSmtpCredentialRequest other = (UpdateSmtpCredentialRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.userId, other.userId) && Objects.equals(this.smtpCredentialId, other.smtpCredentialId) && Objects.equals((Object)this.updateSmtpCredentialDetails, (Object)other.updateSmtpCredentialDetails) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.userId == null ? 43 : this.userId.hashCode());
        result = result * 59 + (this.smtpCredentialId == null ? 43 : this.smtpCredentialId.hashCode());
        result = result * 59 + (this.updateSmtpCredentialDetails == null ? 43 : this.updateSmtpCredentialDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateSmtpCredentialRequest, UpdateSmtpCredentialDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String userId = null;
        private String smtpCredentialId = null;
        private UpdateSmtpCredentialDetails updateSmtpCredentialDetails = null;
        private String ifMatch = null;

        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder smtpCredentialId(String smtpCredentialId) {
            this.smtpCredentialId = smtpCredentialId;
            return this;
        }

        public Builder updateSmtpCredentialDetails(UpdateSmtpCredentialDetails updateSmtpCredentialDetails) {
            this.updateSmtpCredentialDetails = updateSmtpCredentialDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateSmtpCredentialRequest o) {
            this.userId(o.getUserId());
            this.smtpCredentialId(o.getSmtpCredentialId());
            this.updateSmtpCredentialDetails(o.getUpdateSmtpCredentialDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateSmtpCredentialRequest build() {
            UpdateSmtpCredentialRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateSmtpCredentialDetails body) {
            this.updateSmtpCredentialDetails(body);
            return this;
        }

        public UpdateSmtpCredentialRequest buildWithoutInvocationCallback() {
            UpdateSmtpCredentialRequest request = new UpdateSmtpCredentialRequest();
            request.userId = this.userId;
            request.smtpCredentialId = this.smtpCredentialId;
            request.updateSmtpCredentialDetails = this.updateSmtpCredentialDetails;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

