/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.identity.model.UpdateOAuth2ClientCredentialDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateOAuthClientCredentialRequest
extends BmcRequest<UpdateOAuth2ClientCredentialDetails> {
    private String userId;
    private String oauth2ClientCredentialId;
    private UpdateOAuth2ClientCredentialDetails updateOAuth2ClientCredentialDetails;
    private String ifMatch;

    public String getUserId() {
        return this.userId;
    }

    public String getOauth2ClientCredentialId() {
        return this.oauth2ClientCredentialId;
    }

    public UpdateOAuth2ClientCredentialDetails getUpdateOAuth2ClientCredentialDetails() {
        return this.updateOAuth2ClientCredentialDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public UpdateOAuth2ClientCredentialDetails getBody$() {
        return this.updateOAuth2ClientCredentialDetails;
    }

    public Builder toBuilder() {
        return new Builder().userId(this.userId).oauth2ClientCredentialId(this.oauth2ClientCredentialId).updateOAuth2ClientCredentialDetails(this.updateOAuth2ClientCredentialDetails).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",userId=").append(String.valueOf(this.userId));
        sb.append(",oauth2ClientCredentialId=").append(String.valueOf(this.oauth2ClientCredentialId));
        sb.append(",updateOAuth2ClientCredentialDetails=").append(String.valueOf((Object)this.updateOAuth2ClientCredentialDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateOAuthClientCredentialRequest)) {
            return false;
        }
        UpdateOAuthClientCredentialRequest other = (UpdateOAuthClientCredentialRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.userId, other.userId) && Objects.equals(this.oauth2ClientCredentialId, other.oauth2ClientCredentialId) && Objects.equals((Object)this.updateOAuth2ClientCredentialDetails, (Object)other.updateOAuth2ClientCredentialDetails) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.userId == null ? 43 : this.userId.hashCode());
        result = result * 59 + (this.oauth2ClientCredentialId == null ? 43 : this.oauth2ClientCredentialId.hashCode());
        result = result * 59 + (this.updateOAuth2ClientCredentialDetails == null ? 43 : this.updateOAuth2ClientCredentialDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateOAuthClientCredentialRequest, UpdateOAuth2ClientCredentialDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String userId = null;
        private String oauth2ClientCredentialId = null;
        private UpdateOAuth2ClientCredentialDetails updateOAuth2ClientCredentialDetails = null;
        private String ifMatch = null;

        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder oauth2ClientCredentialId(String oauth2ClientCredentialId) {
            this.oauth2ClientCredentialId = oauth2ClientCredentialId;
            return this;
        }

        public Builder updateOAuth2ClientCredentialDetails(UpdateOAuth2ClientCredentialDetails updateOAuth2ClientCredentialDetails) {
            this.updateOAuth2ClientCredentialDetails = updateOAuth2ClientCredentialDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateOAuthClientCredentialRequest o) {
            this.userId(o.getUserId());
            this.oauth2ClientCredentialId(o.getOauth2ClientCredentialId());
            this.updateOAuth2ClientCredentialDetails(o.getUpdateOAuth2ClientCredentialDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateOAuthClientCredentialRequest build() {
            UpdateOAuthClientCredentialRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateOAuth2ClientCredentialDetails body) {
            this.updateOAuth2ClientCredentialDetails(body);
            return this;
        }

        public UpdateOAuthClientCredentialRequest buildWithoutInvocationCallback() {
            UpdateOAuthClientCredentialRequest request = new UpdateOAuthClientCredentialRequest();
            request.userId = this.userId;
            request.oauth2ClientCredentialId = this.oauth2ClientCredentialId;
            request.updateOAuth2ClientCredentialDetails = this.updateOAuth2ClientCredentialDetails;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

