/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.io;

import java.io.IOException;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hc.client5.http.DnsResolver;
import org.apache.hc.client5.http.EndpointInfo;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.SchemePortResolver;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.TlsConfig;
import org.apache.hc.client5.http.impl.ConnPoolSupport;
import org.apache.hc.client5.http.impl.ConnectionShutdownException;
import org.apache.hc.client5.http.impl.io.DefaultHttpClientConnectionOperator;
import org.apache.hc.client5.http.impl.io.ManagedHttpClientConnectionFactory;
import org.apache.hc.client5.http.io.ConnectionEndpoint;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionOperator;
import org.apache.hc.client5.http.io.LeaseRequest;
import org.apache.hc.client5.http.io.ManagedHttpClientConnection;
import org.apache.hc.client5.http.socket.ConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.DefaultClientTlsStrategy;
import org.apache.hc.client5.http.ssl.TlsSocketStrategy;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.http.config.Lookup;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.impl.io.HttpRequestExecutor;
import org.apache.hc.core5.http.io.HttpClientConnection;
import org.apache.hc.core5.http.io.HttpConnectionFactory;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Asserts;
import org.apache.hc.core5.util.Deadline;
import org.apache.hc.core5.util.Identifiable;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.SAFE)
public class BasicHttpClientConnectionManager
implements HttpClientConnectionManager {
    private static final Logger LOG = LoggerFactory.getLogger(BasicHttpClientConnectionManager.class);
    private static final AtomicLong COUNT = new AtomicLong(0L);
    private final HttpClientConnectionOperator connectionOperator;
    private final HttpConnectionFactory<ManagedHttpClientConnection> connFactory;
    private final String id;
    private final ReentrantLock lock;
    private ManagedHttpClientConnection conn;
    private HttpRoute route;
    private Object state;
    private long created;
    private long updated;
    private long expiry;
    private boolean leased;
    private SocketConfig socketConfig;
    private ConnectionConfig connectionConfig;
    private TlsConfig tlsConfig;
    private final AtomicBoolean closed;

    public BasicHttpClientConnectionManager(HttpClientConnectionOperator httpClientConnectionOperator, HttpConnectionFactory<ManagedHttpClientConnection> connFactory) {
        this.connectionOperator = (HttpClientConnectionOperator)Args.notNull((Object)httpClientConnectionOperator, (String)"Connection operator");
        this.connFactory = connFactory != null ? connFactory : ManagedHttpClientConnectionFactory.INSTANCE;
        this.id = String.format("ep-%010d", COUNT.getAndIncrement());
        this.expiry = Long.MAX_VALUE;
        this.socketConfig = SocketConfig.DEFAULT;
        this.connectionConfig = ConnectionConfig.DEFAULT;
        this.tlsConfig = TlsConfig.DEFAULT;
        this.closed = new AtomicBoolean(false);
        this.lock = new ReentrantLock();
    }

    public static BasicHttpClientConnectionManager create(SchemePortResolver schemePortResolver, DnsResolver dnsResolver, Lookup<TlsSocketStrategy> tlsSocketStrategyRegistry, HttpConnectionFactory<ManagedHttpClientConnection> connFactory) {
        return new BasicHttpClientConnectionManager(new DefaultHttpClientConnectionOperator(schemePortResolver, dnsResolver, tlsSocketStrategyRegistry), connFactory);
    }

    public static BasicHttpClientConnectionManager create(Lookup<TlsSocketStrategy> tlsSocketStrategyRegistry, HttpConnectionFactory<ManagedHttpClientConnection> connFactory) {
        return new BasicHttpClientConnectionManager(new DefaultHttpClientConnectionOperator(null, null, tlsSocketStrategyRegistry), connFactory);
    }

    public static BasicHttpClientConnectionManager create(Lookup<TlsSocketStrategy> tlsSocketStrategyRegistry) {
        return new BasicHttpClientConnectionManager(new DefaultHttpClientConnectionOperator(null, null, tlsSocketStrategyRegistry), null);
    }

    @Deprecated
    public BasicHttpClientConnectionManager(Lookup<ConnectionSocketFactory> socketFactoryRegistry, HttpConnectionFactory<ManagedHttpClientConnection> connFactory, SchemePortResolver schemePortResolver, DnsResolver dnsResolver) {
        this(new DefaultHttpClientConnectionOperator(socketFactoryRegistry, schemePortResolver, dnsResolver), connFactory);
    }

    @Deprecated
    public BasicHttpClientConnectionManager(Lookup<ConnectionSocketFactory> socketFactoryRegistry, HttpConnectionFactory<ManagedHttpClientConnection> connFactory) {
        this(socketFactoryRegistry, connFactory, null, null);
    }

    @Deprecated
    public BasicHttpClientConnectionManager(Lookup<ConnectionSocketFactory> socketFactoryRegistry) {
        this(socketFactoryRegistry, null, null, null);
    }

    public BasicHttpClientConnectionManager() {
        this(new DefaultHttpClientConnectionOperator(null, null, (Lookup<TlsSocketStrategy>)RegistryBuilder.create().register(URIScheme.HTTPS.id, (Object)DefaultClientTlsStrategy.createDefault()).build()), null);
    }

    public void close() {
        this.close(CloseMode.GRACEFUL);
    }

    public void close(CloseMode closeMode) {
        if (this.closed.compareAndSet(false, true)) {
            this.closeConnection(closeMode);
        }
    }

    HttpRoute getRoute() {
        return this.route;
    }

    Object getState() {
        return this.state;
    }

    public SocketConfig getSocketConfig() {
        this.lock.lock();
        try {
            SocketConfig socketConfig = this.socketConfig;
            return socketConfig;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setSocketConfig(SocketConfig socketConfig) {
        this.lock.lock();
        try {
            this.socketConfig = socketConfig != null ? socketConfig : SocketConfig.DEFAULT;
        }
        finally {
            this.lock.unlock();
        }
    }

    public ConnectionConfig getConnectionConfig() {
        this.lock.lock();
        try {
            ConnectionConfig connectionConfig = this.connectionConfig;
            return connectionConfig;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setConnectionConfig(ConnectionConfig connectionConfig) {
        this.lock.lock();
        try {
            this.connectionConfig = connectionConfig != null ? connectionConfig : ConnectionConfig.DEFAULT;
        }
        finally {
            this.lock.unlock();
        }
    }

    public TlsConfig getTlsConfig() {
        this.lock.lock();
        try {
            TlsConfig tlsConfig = this.tlsConfig;
            return tlsConfig;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setTlsConfig(TlsConfig tlsConfig) {
        this.lock.lock();
        try {
            this.tlsConfig = tlsConfig != null ? tlsConfig : TlsConfig.DEFAULT;
        }
        finally {
            this.lock.unlock();
        }
    }

    public LeaseRequest lease(String id, HttpRoute route, Object state) {
        return this.lease(id, route, Timeout.DISABLED, state);
    }

    @Override
    public LeaseRequest lease(String id, final HttpRoute route, Timeout requestTimeout, final Object state) {
        return new LeaseRequest(){
            final /* synthetic */ BasicHttpClientConnectionManager this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public ConnectionEndpoint get(Timeout timeout) throws InterruptedException, ExecutionException, TimeoutException {
                try {
                    return this.this$0.new InternalConnectionEndpoint(route, this.this$0.getConnection(route, state));
                }
                catch (IOException ex) {
                    throw new ExecutionException(ex.getMessage(), ex);
                }
            }

            public boolean cancel() {
                return false;
            }
        };
    }

    private void closeConnection(CloseMode closeMode) {
        this.lock.lock();
        try {
            if (this.conn != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} Closing connection {}", (Object)this.id, (Object)closeMode);
                }
                this.conn.close(closeMode);
                this.conn = null;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void checkExpiry() {
        if (this.conn != null && System.currentTimeMillis() >= this.expiry) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} Connection expired @ {}", (Object)this.id, (Object)Instant.ofEpochMilli(this.expiry));
            }
            this.closeConnection(CloseMode.GRACEFUL);
        }
    }

    private void validate() {
        Deadline deadline;
        TimeValue timeToLive;
        if (this.conn != null && TimeValue.isNonNegative((TimeValue)(timeToLive = this.connectionConfig.getTimeToLive())) && (deadline = Deadline.calculate((long)this.created, (TimeValue)timeToLive)).isExpired()) {
            this.closeConnection(CloseMode.GRACEFUL);
        }
        if (this.conn != null) {
            TimeValue timeValue;
            TimeValue timeValue2 = timeValue = this.connectionConfig.getValidateAfterInactivity() != null ? this.connectionConfig.getValidateAfterInactivity() : TimeValue.ofSeconds((long)2L);
            if (TimeValue.isNonNegative((TimeValue)timeValue) && (deadline = Deadline.calculate((long)this.updated, (TimeValue)timeValue)).isExpired()) {
                boolean stale;
                try {
                    stale = this.conn.isStale();
                }
                catch (IOException ignore) {
                    stale = true;
                }
                if (stale) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{} connection {} is stale", (Object)this.id, (Object)ConnPoolSupport.getId(this.conn));
                    }
                    this.closeConnection(CloseMode.GRACEFUL);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ManagedHttpClientConnection getConnection(HttpRoute route, Object state) throws IOException {
        this.lock.lock();
        try {
            Asserts.check((!this.isClosed() ? 1 : 0) != 0, (String)"Connection manager has been shut down");
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} Get connection for route {}", (Object)this.id, (Object)route);
            }
            Asserts.check((!this.leased ? 1 : 0) != 0, (String)"Connection %s is still allocated", (Object)this.conn);
            if (!Objects.equals(this.route, route) || !Objects.equals(this.state, state)) {
                this.closeConnection(CloseMode.GRACEFUL);
            }
            this.route = route;
            this.state = state;
            this.checkExpiry();
            this.validate();
            if (this.conn == null) {
                this.conn = (ManagedHttpClientConnection)this.connFactory.createConnection(null);
                this.created = System.currentTimeMillis();
            } else {
                this.conn.activate();
            }
            this.leased = true;
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} Using connection {}", (Object)this.id, (Object)this.conn);
            }
            ManagedHttpClientConnection managedHttpClientConnection = this.conn;
            return managedHttpClientConnection;
        }
        finally {
            this.lock.unlock();
        }
    }

    private InternalConnectionEndpoint cast(ConnectionEndpoint endpoint) {
        if (endpoint instanceof InternalConnectionEndpoint) {
            return (InternalConnectionEndpoint)endpoint;
        }
        throw new IllegalStateException("Unexpected endpoint class: " + endpoint.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(ConnectionEndpoint endpoint, Object state, TimeValue keepAlive) {
        this.lock.lock();
        try {
            Args.notNull((Object)endpoint, (String)"Managed endpoint");
            InternalConnectionEndpoint internalEndpoint = this.cast(endpoint);
            ManagedHttpClientConnection conn = internalEndpoint.detach();
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} Releasing connection {}", (Object)this.id, (Object)conn);
            }
            if (this.isClosed()) {
                return;
            }
            try {
                if (keepAlive == null && conn != null) {
                    conn.close(CloseMode.GRACEFUL);
                }
                this.updated = System.currentTimeMillis();
                if (conn != null && conn.isOpen() && conn.isConsistent()) {
                    this.state = state;
                    conn.passivate();
                    if (TimeValue.isPositive((TimeValue)keepAlive)) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("{} Connection can be kept alive for {}", (Object)this.id, (Object)keepAlive);
                        }
                        this.expiry = this.updated + keepAlive.toMilliseconds();
                    } else {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("{} Connection can be kept alive indefinitely", (Object)this.id);
                        }
                        this.expiry = Long.MAX_VALUE;
                    }
                } else {
                    this.route = null;
                    this.conn = null;
                    this.expiry = Long.MAX_VALUE;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{} Connection is not kept alive", (Object)this.id);
                    }
                }
            }
            finally {
                this.leased = false;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(ConnectionEndpoint endpoint, TimeValue timeout, HttpContext context) throws IOException {
        this.lock.lock();
        try {
            Timeout socketTimeout;
            Args.notNull((Object)endpoint, (String)"Endpoint");
            InternalConnectionEndpoint internalEndpoint = this.cast(endpoint);
            if (internalEndpoint.isConnected()) {
                return;
            }
            HttpRoute route = internalEndpoint.getRoute();
            HttpHost firstHop = route.getProxyHost() != null ? route.getProxyHost() : route.getTargetHost();
            Timeout connectTimeout = timeout != null ? Timeout.of((long)timeout.getDuration(), (TimeUnit)timeout.getTimeUnit()) : this.connectionConfig.getConnectTimeout();
            ManagedHttpClientConnection connection = internalEndpoint.getConnection();
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} connecting endpoint to {} ({})", new Object[]{ConnPoolSupport.getId(endpoint), firstHop, connectTimeout});
            }
            this.connectionOperator.connect(connection, firstHop, route.getTargetName(), route.getLocalSocketAddress(), connectTimeout, this.socketConfig, route.isTunnelled() ? null : this.tlsConfig, context);
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} connected {}", (Object)ConnPoolSupport.getId(endpoint), (Object)ConnPoolSupport.getId(this.conn));
            }
            if ((socketTimeout = this.connectionConfig.getSocketTimeout()) != null) {
                connection.setSocketTimeout(socketTimeout);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void upgrade(ConnectionEndpoint endpoint, HttpContext context) throws IOException {
        this.lock.lock();
        try {
            Args.notNull((Object)endpoint, (String)"Endpoint");
            Args.notNull((Object)this.route, (String)"HTTP route");
            InternalConnectionEndpoint internalEndpoint = this.cast(endpoint);
            HttpRoute route = internalEndpoint.getRoute();
            this.connectionOperator.upgrade(internalEndpoint.getConnection(), route.getTargetHost(), route.getTargetName(), this.tlsConfig, context);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void closeExpired() {
        this.lock.lock();
        try {
            if (this.isClosed()) {
                return;
            }
            if (!this.leased) {
                this.checkExpiry();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeIdle(TimeValue idleTime) {
        this.lock.lock();
        try {
            Args.notNull((Object)idleTime, (String)"Idle time");
            if (this.isClosed()) {
                return;
            }
            if (!this.leased) {
                long deadline;
                long time = idleTime.toMilliseconds();
                if (time < 0L) {
                    time = 0L;
                }
                if (this.updated <= (deadline = System.currentTimeMillis() - time)) {
                    this.closeConnection(CloseMode.GRACEFUL);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Deprecated
    public TimeValue getValidateAfterInactivity() {
        return this.connectionConfig.getValidateAfterInactivity();
    }

    @Deprecated
    public void setValidateAfterInactivity(TimeValue validateAfterInactivity) {
        this.connectionConfig = ConnectionConfig.custom().setValidateAfterInactivity(validateAfterInactivity).build();
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    class InternalConnectionEndpoint
    extends ConnectionEndpoint
    implements Identifiable {
        private final HttpRoute route;
        private final AtomicReference<ManagedHttpClientConnection> connRef;

        public InternalConnectionEndpoint(HttpRoute route, ManagedHttpClientConnection conn) {
            this.route = route;
            this.connRef = new AtomicReference<ManagedHttpClientConnection>(conn);
        }

        public String getId() {
            return BasicHttpClientConnectionManager.this.id;
        }

        HttpRoute getRoute() {
            return this.route;
        }

        ManagedHttpClientConnection getConnection() {
            ManagedHttpClientConnection conn = this.connRef.get();
            if (conn == null) {
                throw new ConnectionShutdownException();
            }
            return conn;
        }

        ManagedHttpClientConnection getValidatedConnection() {
            ManagedHttpClientConnection conn = this.connRef.get();
            if (conn == null || !conn.isOpen()) {
                throw new ConnectionShutdownException();
            }
            return conn;
        }

        ManagedHttpClientConnection detach() {
            return this.connRef.getAndSet(null);
        }

        @Override
        public boolean isConnected() {
            ManagedHttpClientConnection conn = this.connRef.get();
            return conn != null && conn.isOpen();
        }

        public void close(CloseMode closeMode) {
            ManagedHttpClientConnection conn = this.connRef.get();
            if (conn != null) {
                conn.close(closeMode);
            }
        }

        public void close() throws IOException {
            ManagedHttpClientConnection conn = this.connRef.get();
            if (conn != null) {
                conn.close();
            }
        }

        @Override
        public void setSocketTimeout(Timeout timeout) {
            this.getValidatedConnection().setSocketTimeout(timeout);
        }

        @Override
        @Deprecated
        public ClassicHttpResponse execute(String exchangeId, ClassicHttpRequest request, HttpRequestExecutor requestExecutor, HttpContext context) throws IOException, HttpException {
            Args.notNull((Object)request, (String)"HTTP request");
            Args.notNull((Object)requestExecutor, (String)"Request executor");
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} Executing exchange {}", (Object)BasicHttpClientConnectionManager.this.id, (Object)exchangeId);
            }
            return requestExecutor.execute(request, (HttpClientConnection)this.getValidatedConnection(), context);
        }

        @Override
        public ClassicHttpResponse execute(String exchangeId, ClassicHttpRequest request, ConnectionEndpoint.RequestExecutor requestExecutor, HttpContext context) throws IOException, HttpException {
            Args.notNull((Object)request, (String)"HTTP request");
            Args.notNull((Object)requestExecutor, (String)"Request executor");
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} Executing exchange {}", (Object)BasicHttpClientConnectionManager.this.id, (Object)exchangeId);
            }
            return requestExecutor.execute(request, this.getValidatedConnection(), context);
        }

        @Override
        public EndpointInfo getInfo() {
            ManagedHttpClientConnection connection = this.connRef.get();
            if (connection != null && connection.isOpen()) {
                return new EndpointInfo(connection.getProtocolVersion(), connection.getSSLSession());
            }
            return null;
        }
    }
}

