/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.async;

import java.io.InterruptedIOException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.client5.http.EndpointInfo;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.async.AsyncExecRuntime;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.ConnPoolSupport;
import org.apache.hc.client5.http.impl.Operations;
import org.apache.hc.client5.http.impl.async.InternalH2ConnPool;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.concurrent.Cancellable;
import org.apache.hc.core5.concurrent.CancellableDependency;
import org.apache.hc.core5.concurrent.ComplexCancellable;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.nio.AsyncClientExchangeHandler;
import org.apache.hc.core5.http.nio.AsyncPushConsumer;
import org.apache.hc.core5.http.nio.HandlerFactory;
import org.apache.hc.core5.http.nio.command.RequestExecutionCommand;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.reactor.Command;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.reactor.ssl.TlsDetails;
import org.apache.hc.core5.reactor.ssl.TransportSecurityLayer;
import org.apache.hc.core5.util.Identifiable;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;

class InternalH2AsyncExecRuntime
implements AsyncExecRuntime {
    private final Logger log;
    private final InternalH2ConnPool connPool;
    private final HandlerFactory<AsyncPushConsumer> pushHandlerFactory;
    private final AtomicReference<Endpoint> sessionRef;
    private volatile boolean reusable;

    InternalH2AsyncExecRuntime(Logger log, InternalH2ConnPool connPool, HandlerFactory<AsyncPushConsumer> pushHandlerFactory) {
        this.log = log;
        this.connPool = connPool;
        this.pushHandlerFactory = pushHandlerFactory;
        this.sessionRef = new AtomicReference();
    }

    @Override
    public boolean isEndpointAcquired() {
        return this.sessionRef.get() != null;
    }

    @Override
    public Cancellable acquireEndpoint(final String id, final HttpRoute route, Object object, HttpClientContext context, final FutureCallback<AsyncExecRuntime> callback) {
        if (this.sessionRef.get() == null) {
            RequestConfig requestConfig = context.getRequestConfigOrDefault();
            Timeout connectTimeout = requestConfig.getConnectTimeout();
            if (this.log.isDebugEnabled()) {
                this.log.debug("{} acquiring endpoint ({})", (Object)id, (Object)connectTimeout);
            }
            return Operations.cancellable(this.connPool.getSession(route, connectTimeout, new FutureCallback<IOSession>(){
                final /* synthetic */ InternalH2AsyncExecRuntime this$0;
                {
                    this.this$0 = this$0;
                }

                public void completed(IOSession ioSession) {
                    this.this$0.sessionRef.set(new Endpoint(route, ioSession));
                    this.this$0.reusable = true;
                    if (this.this$0.log.isDebugEnabled()) {
                        this.this$0.log.debug("{} acquired endpoint", (Object)id);
                    }
                    callback.completed((Object)this.this$0);
                }

                public void failed(Exception ex) {
                    callback.failed(ex);
                }

                public void cancelled() {
                    callback.cancelled();
                }
            }));
        }
        callback.completed((Object)this);
        return Operations.nonCancellable();
    }

    private void closeEndpoint(Endpoint endpoint) {
        endpoint.session.close(CloseMode.GRACEFUL);
        if (this.log.isDebugEnabled()) {
            this.log.debug("{} endpoint closed", (Object)ConnPoolSupport.getId(endpoint));
        }
    }

    @Override
    public void releaseEndpoint() {
        Endpoint endpoint = this.sessionRef.getAndSet(null);
        if (endpoint != null && !this.reusable) {
            this.closeEndpoint(endpoint);
        }
    }

    @Override
    public void discardEndpoint() {
        Endpoint endpoint = this.sessionRef.getAndSet(null);
        if (endpoint != null) {
            this.closeEndpoint(endpoint);
        }
    }

    @Override
    public boolean validateConnection() {
        if (this.reusable) {
            Endpoint endpoint = this.sessionRef.get();
            return endpoint != null && endpoint.session.isOpen();
        }
        Endpoint endpoint = this.sessionRef.getAndSet(null);
        if (endpoint != null) {
            this.closeEndpoint(endpoint);
        }
        return false;
    }

    @Override
    public boolean isEndpointConnected() {
        Endpoint endpoint = this.sessionRef.get();
        return endpoint != null && endpoint.session.isOpen();
    }

    Endpoint ensureValid() {
        Endpoint endpoint = this.sessionRef.get();
        if (endpoint == null) {
            throw new IllegalStateException("I/O session not acquired / already released");
        }
        return endpoint;
    }

    @Override
    public Cancellable connectEndpoint(HttpClientContext context, final FutureCallback<AsyncExecRuntime> callback) {
        final Endpoint endpoint = this.ensureValid();
        if (endpoint.session.isOpen()) {
            callback.completed((Object)this);
            return Operations.nonCancellable();
        }
        final HttpRoute route = endpoint.route;
        RequestConfig requestConfig = context.getRequestConfigOrDefault();
        Timeout connectTimeout = requestConfig.getConnectTimeout();
        if (this.log.isDebugEnabled()) {
            this.log.debug("{} connecting endpoint ({})", (Object)ConnPoolSupport.getId(endpoint), (Object)connectTimeout);
        }
        return Operations.cancellable(this.connPool.getSession(route, connectTimeout, new FutureCallback<IOSession>(){
            final /* synthetic */ InternalH2AsyncExecRuntime this$0;
            {
                this.this$0 = this$0;
            }

            public void completed(IOSession ioSession) {
                this.this$0.sessionRef.set(new Endpoint(route, ioSession));
                this.this$0.reusable = true;
                if (this.this$0.log.isDebugEnabled()) {
                    this.this$0.log.debug("{} endpoint connected", (Object)ConnPoolSupport.getId(endpoint));
                }
                callback.completed((Object)this.this$0);
            }

            public void failed(Exception ex) {
                callback.failed(ex);
            }

            public void cancelled() {
                callback.cancelled();
            }
        }));
    }

    @Override
    public void disconnectEndpoint() {
        Endpoint endpoint = this.sessionRef.get();
        if (endpoint != null) {
            endpoint.session.close(CloseMode.GRACEFUL);
        }
    }

    @Override
    public void upgradeTls(HttpClientContext context) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void upgradeTls(HttpClientContext context, FutureCallback<AsyncExecRuntime> callback) {
        throw new UnsupportedOperationException();
    }

    @Override
    public EndpointInfo getEndpointInfo() {
        Endpoint endpoint = this.sessionRef.get();
        if (endpoint != null && endpoint.session.isOpen() && endpoint.session instanceof TransportSecurityLayer) {
            TlsDetails tlsDetails = ((TransportSecurityLayer)endpoint.session).getTlsDetails();
            return new EndpointInfo((ProtocolVersion)HttpVersion.HTTP_2, tlsDetails != null ? tlsDetails.getSSLSession() : null);
        }
        return null;
    }

    @Override
    public Cancellable execute(final String id, final AsyncClientExchangeHandler exchangeHandler, final HttpClientContext context) {
        final ComplexCancellable complexCancellable = new ComplexCancellable();
        final Endpoint endpoint = this.ensureValid();
        final IOSession session = endpoint.session;
        if (session.isOpen()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("{} start execution {}", (Object)ConnPoolSupport.getId(endpoint), (Object)id);
            }
            context.setProtocolVersion((ProtocolVersion)HttpVersion.HTTP_2);
            session.enqueue((Command)new RequestExecutionCommand(exchangeHandler, this.pushHandlerFactory, (CancellableDependency)complexCancellable, (HttpContext)context), Command.Priority.NORMAL);
        } else {
            final HttpRoute route = endpoint.route;
            RequestConfig requestConfig = context.getRequestConfigOrDefault();
            Timeout connectTimeout = requestConfig.getConnectTimeout();
            this.connPool.getSession(route, connectTimeout, new FutureCallback<IOSession>(){
                final /* synthetic */ InternalH2AsyncExecRuntime this$0;
                {
                    this.this$0 = this$0;
                }

                public void completed(IOSession ioSession) {
                    this.this$0.sessionRef.set(new Endpoint(route, ioSession));
                    this.this$0.reusable = true;
                    if (this.this$0.log.isDebugEnabled()) {
                        this.this$0.log.debug("{} start execution {}", (Object)ConnPoolSupport.getId(endpoint), (Object)id);
                    }
                    context.setProtocolVersion((ProtocolVersion)HttpVersion.HTTP_2);
                    session.enqueue((Command)new RequestExecutionCommand(exchangeHandler, this.this$0.pushHandlerFactory, (CancellableDependency)complexCancellable, (HttpContext)context), Command.Priority.NORMAL);
                }

                public void failed(Exception ex) {
                    exchangeHandler.failed(ex);
                }

                public void cancelled() {
                    exchangeHandler.failed((Exception)new InterruptedIOException());
                }
            });
        }
        return complexCancellable;
    }

    @Override
    public void markConnectionReusable(Object newState, TimeValue newValidDuration) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void markConnectionNonReusable() {
        this.reusable = false;
    }

    @Override
    public AsyncExecRuntime fork() {
        return new InternalH2AsyncExecRuntime(this.log, this.connPool, this.pushHandlerFactory);
    }

    static class Endpoint
    implements Identifiable {
        final HttpRoute route;
        final IOSession session;

        Endpoint(HttpRoute route, IOSession session) {
            this.route = route;
            this.session = session;
        }

        public String getId() {
            return this.session.getId();
        }
    }
}

