/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.mle.command;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ParsedObjectName {
    private final String objName;
    private String verbSchema;
    private String verbObject;
    private String canonSchema;
    private String canonObject;
    private boolean schemaQuote;
    private boolean objectQuote;

    public ParsedObjectName(String objectName) {
        this.objName = objectName;
        this.parse();
    }

    private boolean balancedQuotes(String q1, String q2) {
        return q1 == null && q2 == null || q1 != null && q2 != null;
    }

    private void parse() {
        Pattern p = Pattern.compile("^(?:(\"?)([^\"]+)(\")?[.])?(\")?([^\"]+)(\")?$");
        Matcher m = p.matcher(this.objName);
        if (m.matches()) {
            String q1 = m.group(1);
            String q2 = m.group(3);
            String q3 = m.group(4);
            String q4 = m.group(6);
            if (this.balancedQuotes(q1, q2) && this.balancedQuotes(q3, q4)) {
                this.verbSchema = m.group(2);
                this.verbObject = m.group(5);
                if (this.verbSchema != null) {
                    if (q1 != null) {
                        this.canonSchema = this.verbSchema;
                        this.schemaQuote = true;
                    } else {
                        this.canonSchema = this.verbSchema.toUpperCase();
                        this.schemaQuote = false;
                    }
                }
                if (q3 != null) {
                    this.canonObject = this.verbObject;
                    this.objectQuote = true;
                } else {
                    this.canonObject = this.verbObject.toUpperCase();
                    this.objectQuote = false;
                }
                return;
            }
        }
        this.verbObject = this.objName;
        this.canonObject = this.verbObject.toUpperCase();
    }

    public String getObjectName() {
        return this.objName;
    }

    public String getSchema() {
        return this.verbSchema;
    }

    public String getObject() {
        return this.verbObject;
    }

    private String quoted(String str) {
        return String.format("\"%s\"", str);
    }

    public String getCanonicalSchema() {
        return this.schemaQuote ? this.quoted(this.canonSchema) : this.canonSchema;
    }

    public String getCanonicalObject() {
        return this.objectQuote ? this.quoted(this.canonObject) : this.canonObject;
    }

    public String getCanonical() {
        if (this.canonSchema != null) {
            return this.getCanonicalSchema() + "." + this.getCanonicalObject();
        }
        return this.getCanonicalObject();
    }
}

