/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.commands;

import java.io.PrintStream;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.UUID;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.ConnectionDetails;
import oracle.dbtools.db.ConnectionResolver;
import oracle.dbtools.db.ConnectionStoreBridge;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.DefaultConnectionIdentifier;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.db.VersionTracker;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Token;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptUtils;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowSga;
import oracle.dbtools.raptor.scriptrunner.commands.Messages;
import oracle.dbtools.raptor.utils.SQLPLUSUtil;
import oracle.dbtools.util.Logger;
import oracle.dbtools.util.Pair;
import oracle.jdbc.OracleConnection;

public class Startup
extends CommandListener {
    private static final String RESTRICT = "restrict";
    private static final String FORCE = "force";
    private static final String PFILEUPPER = "PFILE";
    private static final String ONLYUPPER = "ONLY";
    private static final String READUPPER = "READ";
    private static final String WRITEUPPER = "WRITE";
    private static final String RECOVERUPPER = "RECOVER";
    private static final String OPENUPPER = "OPEN";
    private static final String RETRYUPPER = "RETRY";
    private static final String PARALLELUPPER = "PARALLEL";
    private static final String SHAREDUPPER = "SHARED";
    private static final String MOUNTUPPER = "MOUNT";
    private static final String PLUGGABLEUPPER = "PLUGGABLE";
    private static final String DATABASEUPPER = "DATABASE";
    private static final int NOMATCH = 0;
    private static final int OPENREADONLY = 1;
    private static final int OPENREADWRITE = 2;
    private static final int OPENREADWRITERECOVER = 3;
    private static final int MOUNTMATCH = 1;
    static boolean debug = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        block123: {
            block122: {
                block126: {
                    block127: {
                        block125: {
                            if (ctx.getCurrentConnection() != null && ctx.getCurrentConnection().getClass().getName().equals("oracle.nucleo.jdbc.impl.NucleoConnectionImpl")) {
                                ctx.write("Not supported for nucleo connection\n");
                                return true;
                            }
                            if (cmd.getStmtId() == null || cmd.getStmtId() != SQLCommand.StmtSubType.G_S_STARTUP) {
                                return false;
                            }
                            wasOpened = false;
                            alreadyUp = Messages.getString("Startup.ALREADYUP");
                            pluggableAltered = false;
                            nonPlugSuccess = false;
                            pluggableTried = false;
                            connIsNull = conn == null || ctx.getProperty("script.runner.sqlplus.nolog") != null && Boolean.valueOf(ctx.getProperty("script.runner.sqlplus.nolog").equals(Boolean.TRUE)) != false;
                            thepdb = null;
                            if (connIsNull) {
                                ctx.write(Messages.getString("Startup.NOCONNECTION"));
                                return true;
                            }
                            prospective = cmd.getSql();
                            prospective = SQLPLUSUtil.removeDashNewline(cmd, prospective);
                            reopen = SQLPLUSUtil.prelimAuthTryReopen(conn, ctx);
                            preConn = null;
                            if (reopen != null) {
                                preConn = conn;
                                conn = reopen;
                                ctx.setCurrentConnection(conn);
                            }
                            wasQuiet = false;
                            wasForce = false;
                            wasNoMount = false;
                            wasRestrict = false;
                            wasUpgrade = false;
                            wasDowngrade = false;
                            error = false;
                            recover = false;
                            src = LexerToken.parse((String)prospective, (boolean)false);
                            ls = new LexState(src);
                            pfileName = Startup.pfile(ctx, src, ls, prospective);
                            if (Startup.debug) {
                                System.out.println("STARTUP:103:PFILE:" + pfileName);
                            }
                            openState = Startup.open(ctx, src, ls);
                            if (Startup.debug) {
                                System.out.println("STARTUP:106:OPENSTATE:" + String.valueOf(openState.first()));
                            }
                            if (((Integer)openState.first()).equals(3)) {
                                openState = new Pair<Integer, String>(2, (String)openState.second());
                                recover = true;
                            }
                            mountState = Startup.mount(ctx, src, ls);
                            pdb = Startup.pluggableDatabase(ctx, src, ls);
                            wasShared = Startup.eatSharedRetryParallel(ctx, src, ls);
                            if (Startup.debug) {
                                System.out.println("STARTUP:113:PDB:" + pfileName);
                            }
                            if (!error && wasShared && !ctx.isSQLPlusClassic()) {
                                ctx.write(MessageFormat.format(Messages.getString("NOT_SUPPORTED_NOW_IGNORING"), new Object[]{"(SHARED|PARALLEL) [RETRY]"}));
                            }
                            if (!error && ((Integer)mountState.first()).equals(1) && mountState.second() != null) {
                                ctx.write(Messages.getString("Startup.INVALIDCOMBO"));
                                error = true;
                            }
                            if (!error && openState != null && openState.second() != null) {
                                ctx.write(Messages.getString("Startup.INVALIDCOMBO"));
                                error = true;
                            }
                            if (!error && !ls.populateLeft(ctx)) {
                                ctx.write(MessageFormat.format(Messages.getString("NOT_SUPPORTED_NOW"), new Object[]{prospective}));
                                error = true;
                            }
                            match = false;
                            toExecute = null;
                            sysOperConName = null;
                            currentPdb = null;
                            if (!error) {
                                wasQuiet = ls.leftRemove("QUIET");
                                wasForce = ls.leftRemove("FORCE");
                                wasNoMount = ls.leftRemove("NOMOUNT");
                                wasRestrict = ls.leftRemove("RESTRICT");
                                wasUpgrade = ls.leftRemove("UPGRADE");
                                wasDowngrade = ls.leftRemove("DOWNGRADE");
                                match = false;
                                sysOperConName = Startup.returnConNameIfPublic(conn);
                                if (Startup.debug) {
                                    System.out.println("STARTUP:150:SYSCONNAME:" + sysOperConName);
                                }
                                if (sysOperConName != null) {
                                    currentPdb = sysOperConName;
                                    if (Startup.debug) {
                                        System.out.println("STARTUP:153:CURRENTPDB:" + currentPdb);
                                    }
                                } else {
                                    currentPdb = Startup.getConName(conn, ctx);
                                    if (Startup.debug) {
                                        System.out.println("STARTUP:156:CURRENTPDB:" + currentPdb);
                                    }
                                }
                            }
                            if (!error && pdb != null && ((thepdb = pdb) == null || thepdb.equals("") || thepdb.matches("^.*\\s+.*$") && (thepdb.indexOf("\"") == -1 || !thepdb.endsWith("\"")))) {
                                ctx.write(MessageFormat.format(Messages.getString("Startup.INVALIDPDB"), new Object[]{thepdb}));
                                error = true;
                            }
                            thePdbClause = "";
                            if (!error) {
                                thePdbClause = pdb != null ? "PLUGGABLE DATABASE " + pdb + " " : (currentPdb != null ? "PLUGGABLE DATABASE " + currentPdb + " " : "DATABASE ");
                            }
                            if (Startup.debug) {
                                System.out.println("STARTUP:153:PDBCLAUSE:" + (String)thePdbClause);
                            }
                            if (error || wasNoMount || (Integer)openState.first() != 0 && (Integer)openState.first() != 2 && (Integer)openState.first() != 1 || (Integer)mountState.first() != 0) break block125;
                            append = " ";
                            if (wasRestrict && (pdb != null || currentPdb != null)) {
                                append = " RESTRICTED";
                            }
                            upgrade = " ";
                            if (wasUpgrade) {
                                upgrade = " UPGRADE";
                            }
                            if (wasDowngrade) {
                                upgrade = (String)upgrade + " DOWNGRADE";
                            }
                            if (!error) {
                                if (!ls.leftIsEmpty()) {
                                    ctx.write(MessageFormat.format(Messages.getString("UNHANDLED_TOKENS"), new Object[]{ls.remainingTokens()}));
                                    error = true;
                                } else {
                                    toExecute = (Integer)openState.first() == 1 ? "ALTER " + (String)thePdbClause + " OPEN READ ONLY " + append + (String)upgrade : "ALTER " + (String)thePdbClause + " OPEN READ WRITE " + append + (String)upgrade;
                                    match = true;
                                }
                            }
                            break block126;
                        }
                        if (error) break block126;
                        if (wasNoMount) break block127;
                        if ((Integer)mountState.first() != 1) ** GOTO lbl-1000
                    }
                    if (pdb == null) {
                        match = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        error = true;
                        ctx.write(MessageFormat.format(Messages.getString("NOT_SUPPORTED_NOW"), new Object[]{prospective}));
                    }
                }
                if (!(error || connIsNull || conn instanceof OracleConnection)) {
                    ctx.write(Messages.getString("Startup.NOTORACLE"));
                    error = true;
                }
                if (!error && connIsNull) {
                    ctx.write(Messages.getString("Startup.NOCONNECTION"));
                    error = true;
                }
                ocon = (OracleConnection)conn;
                doMount = false;
                switchConOnly = false;
                try {
                    if (!error && ocon != null && thePdbClause.startsWith("PLUGGABLE")) {
                        v0 = sysoperconnalive = sysOperConName != null || DBUtil.isOracleConnectionAlive((Connection)ocon) != false;
                        if (Startup.debug) {
                            System.out.println("STARTUP:250:SYSOPERCONN:" + sysOperConName);
                        }
                        if (sysoperconnalive) {
                            amILocked = LockManager.lock((Connection)ocon);
                            if (Startup.debug) {
                                System.out.println("STARTUP:253:CONNECTIONLOCKED:" + amILocked);
                            }
                            try {
                                if (!amILocked) ** GOTO lbl197
                                dbUtil = DBUtil.getInstance((Connection)ocon);
                                s = ocon.getProperties().getProperty("internal_logon");
                                if (Startup.debug) {
                                    System.out.println("STARTUP:250:INTERNALLOGIN:" + s);
                                }
                                sysdba = false;
                                if (sysOperConName != null || s != null && (s.toLowerCase().equals("sysdba") || s.toLowerCase().equals("sysoper") || s.toLowerCase().equals("sysasm"))) {
                                    sysdba = true;
                                } else {
                                    ctx.write(Messages.getString("Shutdown.NOTSYSDBA"));
                                    error = true;
                                }
                                if (sysOperConName == null && (!sysdba || VersionTracker.getDbVersion(DefaultConnectionIdentifier.createIdentifier((Connection)ocon)).compareTo(new Version("12.1")) < 0)) ** GOTO lbl197
                                if (sysOperConName == null && dbUtil.executeOracleReturnOneCol("select NVL(SYS_CONTEXT('USERENV','CDB_NAME'),'1') from dual", null).equals("1")) {
                                    ctx.write(Messages.getString("Shutdown.NOTCONSOLIDATED"));
                                    error = true;
                                }
                                if (sysOperConName == null && dbUtil.executeOracleReturnOneCol("select to_char(SYS_CONTEXT('USERENV','CON_ID')) from dual", null).equals("1") && thepdb == null) {
                                    ctx.write(Messages.getString("Shutdown.CONID1"));
                                    error = true;
                                }
                                st = null;
                                try {
                                    pluggableTried = true;
                                    st = ocon.createStatement();
                                    if (pfileName != null) {
                                        if (Startup.debug) {
                                            System.out.println("STARTUP:250:PFILENAME:" + pfileName);
                                        }
                                        ctx.write(MessageFormat.format(Messages.getString("NOT_SUPPORTED_NOW"), new Object[]{"pfile="}));
                                    }
                                    if (recover) {
                                        ctx.write(MessageFormat.format(Messages.getString("NOT_SUPPORTED_NOW"), new Object[]{cmd.getSql()}));
                                    }
                                    if (toExecute == null) ** GOTO lbl197
                                    toExecuteForce = toExecute;
                                    if (wasForce) {
                                        toExecuteForce = toExecuteForce + " FORCE";
                                    }
                                    if (Startup.debug) {
                                        ctx.write("about to try: " + toExecuteForce + "\n");
                                    }
                                    st.execute(toExecuteForce);
                                    pluggableAltered = true;
                                    ctx.write(Messages.getString("Startup.PDBOPENED"));
                                    wasOpened = true;
                                }
                                finally {
                                    try {
                                        if (st != null) {
                                            st.close();
                                        }
                                    }
                                    catch (Exception e) {
                                        Logger.ignore(this.getClass(), e);
                                    }
                                }
                            }
                            finally {
                                if (amILocked) {
                                    LockManager.unlock((Connection)ocon);
                                }
                            }
                        } else {
                            ctx.write(Messages.getString("Startup.NOTALIVE"));
                            error = true;
                        }
                    }
lbl197:
                    // 11 sources

                    prelimAuth = ctx.getProperty("script.runner.PRELIM_AUTH") != null && Boolean.valueOf(ctx.getProperty("script.runner.PRELIM_AUTH").equals(Boolean.TRUE)) != false;
                    if (!error && pdb == null && ocon != null && (prelimAuth.booleanValue() || wasForce)) {
                        isLocked = LockManager.lock((Connection)ocon);
                        try {
                            if (isLocked) {
                                if (ocon instanceof OracleConnection) {
                                    s = ocon.getProperties().getProperty("internal_logon");
                                    if (s != null && (s.toLowerCase().equals("sysdba") || s.toLowerCase().equals("sysoper") || s.toLowerCase().equals("sysasm"))) {
                                        cmdpartsNoMount = cmd.getSQLOrig().split("\\s+");
                                        cmdparts = cmd.getSQLOrig().replaceFirst("(?i)\\s+nomount$", " ").replaceFirst("(?i)\\s+nomount\\s+", " ").split("\\s+");
                                        forceforce = System.getenv("SQLCL_FORCE_FORCE");
                                        wasForceForce = forceforce != null && forceforce.equals("") == false;
                                        if (!wasRestrict && (!wasForce || wasForce && prelimAuth.booleanValue() && !wasForceForce.booleanValue())) {
                                            if (this.tryPfile((Connection)ocon, ctx, OracleConnection.DatabaseStartupMode.NO_RESTRICTION, pfileName)) {
                                                ctx.write(Messages.getString("Startup.STARTEDUP"));
                                                doMount = true;
                                                if (wasNoMount) {
                                                    doMount = false;
                                                    switchConOnly = true;
                                                }
                                            } else {
                                                error = true;
                                            }
                                        } else {
                                            if (wasRestrict && !wasForce) {
                                                if (this.tryPfile((Connection)ocon, ctx, OracleConnection.DatabaseStartupMode.RESTRICT, pfileName)) {
                                                    doMount = true;
                                                } else {
                                                    error = false;
                                                }
                                            } else if (wasForce && !wasRestrict) {
                                                if (this.tryPfile((Connection)ocon, ctx, OracleConnection.DatabaseStartupMode.FORCE, pfileName)) {
                                                    doMount = true;
                                                } else {
                                                    error = true;
                                                }
                                            } else {
                                                ctx.write(Messages.getString("Startup.NOTINSQLCL"));
                                                error = true;
                                            }
                                            if (wasNoMount) {
                                                doMount = false;
                                                switchConOnly = true;
                                            }
                                        }
                                    } else {
                                        ctx.write(Messages.getString("Startup.MUSTBESYSOPERORSYSDBA"));
                                        error = true;
                                    }
                                } else {
                                    ctx.write(Messages.getString("Shutdown.NOTSUPPORTEDONCON"));
                                    error = true;
                                }
                            }
                            break block122;
                        }
                        finally {
                            if (isLocked) {
                                LockManager.unlock((Connection)ocon);
                            }
                        }
                    }
                    if (!error && !pluggableTried) {
                        ctx.write(alreadyUp);
                        error = true;
                    }
                }
                catch (SQLException e) {
                    ctx.write(e.getLocalizedMessage() + "\n");
                    error = true;
                }
            }
            try {
                if (error || !doMount && !switchConOnly) break block123;
                st = null;
                connAuth = null;
                isLocked = LockManager.lock((Connection)ocon);
                try {
                    if (!isLocked) break block123;
                    switchBase = false;
                    if (conn.equals(ctx.getBaseConnection())) {
                        switchBase = true;
                    }
                    if (preConn != null && preConn.equals(ctx.getBaseConnection())) {
                        switchBase = true;
                    }
                    connAuth = DriverManager.getConnection((String)ctx.getProperty("cli.conn.url"), (Properties)ctx.getProperty("cli.conn.props"));
                    try {
                        connResolver = (ConnectionStoreBridge)ctx.getProperty("cli.conn.resolver");
                        if (connResolver != null) {
                            name = ConnectionResolver.getConnectionName(conn);
                            if (name != null) {
                                connResolver.removeConnection(name);
                            }
                            if (preConn != null && (name = ConnectionResolver.getConnectionName(preConn)) != null) {
                                connResolver.removeConnection(name);
                            }
                        }
                    }
                    catch (Exception e) {
                        Logger.warn(this.getClass(), e.getStackTrace()[0].toString(), e);
                    }
                    conn.close();
                    c = connAuth;
                    connUrl = c.getMetaData().getURL();
                    connName = UUID.randomUUID().toString();
                    cd = new ConnectionDetails(connName, connUrl);
                    cd.setConn(c);
                    connResolver = (ConnectionStoreBridge)ctx.getProperty("cli.conn.resolver");
                    connResolver.addConnection(cd);
                    getCommit = (Boolean)ctx.getProperty("script.runner.autocommit.checkbox");
                    try {
                        if (getCommit == null || getCommit.equals(Boolean.FALSE)) {
                            connAuth.setAutoCommit(false);
                        } else {
                            connAuth.setAutoCommit(true);
                        }
                    }
                    catch (SQLException e) {
                        Logger.warn(this.getClass(), e.getStackTrace()[0].toString(), e);
                    }
                    writeLater = "";
                    if (doMount) {
                        st = connAuth.createStatement();
                        st.execute("alter database mount");
                        writeLater = (String)writeLater + Messages.getString("Startup.DBMOUNTED");
                        st.close();
                        if (recover) {
                            block124: {
                                st = connAuth.createStatement();
                                try {
                                    st.execute("alter database recover");
                                }
                                catch (Throwable e) {
                                    throwme = e;
                                    for (next = e; next != null; next = next.getCause()) {
                                        if (!(next instanceof SQLException) || !(se = (SQLException)next).getLocalizedMessage().contains("ORA-00264")) continue;
                                        throwme = null;
                                        break;
                                    }
                                    if (throwme == null) break block124;
                                    if (e instanceof SQLException) {
                                        throw (SQLException)e;
                                    }
                                    throw new SQLException(e.getLocalizedMessage());
                                }
                            }
                            st.close();
                        }
                        st = connAuth.createStatement();
                        if (toExecute != null) {
                            if (Startup.debug) {
                                ctx.write("about to call " + toExecute + "\n");
                            }
                            st.execute(toExecute);
                            writeLater = (String)writeLater + Messages.getString("Startup.DBOPEN");
                            wasOpened = true;
                        }
                    }
                    ctx.putProperty("script.runner.PRELIM_AUTH", Boolean.FALSE);
                    if (switchBase) {
                        ctx.setBaseConnection(connAuth);
                    }
                    ctx.setCurrentConnection(connAuth);
                    if ((doMount || wasNoMount) && !wasQuiet) {
                        new ShowSga().doShowSga(connAuth, ctx, cmd);
                    }
                    ctx.write((String)writeLater);
                    nonPlugSuccess = true;
                }
                finally {
                    try {
                        if (st != null) {
                            st.close();
                        }
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                    if (isLocked) {
                        LockManager.unlock((Connection)ocon);
                    }
                }
            }
            catch (SQLException e) {
                ctx.write(e.getLocalizedMessage() + "\n");
                error = true;
            }
        }
        if (nonPlugSuccess || pluggableAltered) {
            if (wasOpened) {
                SQLPLUSUtil.setupNLS(ctx.getCurrentConnection(), ctx);
            }
        } else {
            ScriptUtils.doWhenever(ctx, cmd, conn, true);
        }
        return true;
    }

    private String getMode(String[] cmdparts) {
        return cmdparts[1].toLowerCase();
    }

    private boolean getGoodMode(String string) {
        return string.toLowerCase().equals(FORCE) || string.toLowerCase().equals(RESTRICT);
    }

    private boolean tryPfile(Connection conn, ScriptRunnerContext ctx, OracleConnection.DatabaseStartupMode mode, String pfile) {
        boolean success = false;
        Throwable nonPfileThrowable = null;
        try {
            if (debug) {
                System.out.println("STARTUP:498:TRYPFILE:" + pfile);
            }
            if (pfile == null) {
                try {
                    ((OracleConnection)conn).startup(mode);
                }
                catch (Throwable t) {
                    nonPfileThrowable = t;
                }
            } else {
                String stripPfile = pfile;
                if ((pfile.startsWith("'") || pfile.startsWith("\"")) && (pfile.endsWith("'") || pfile.endsWith("\"")) && pfile.length() > 2) {
                    stripPfile = stripPfile.substring(1, stripPfile.length() - 1);
                }
                Method m = ((OracleConnection)conn).getClass().getDeclaredMethod("startup", OracleConnection.DatabaseStartupMode.class, String.class);
                m.invoke((Object)conn, mode, stripPfile);
            }
            success = true;
        }
        catch (Throwable t) {
            ctx.write(MessageFormat.format(Messages.getString("PFILEEXCEPTION"), pfile));
            t.printStackTrace(new PrintStream(ctx.getOutputStream()));
            Logger.warn(this.getClass(), t);
        }
        if (nonPfileThrowable != null) {
            ctx.write(nonPfileThrowable.getLocalizedMessage() + "\n");
            success = false;
        }
        return success;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    static boolean eatSharedRetryParallel(ScriptRunnerContext ctx, List<LexerToken> src, LexState ls) {
        boolean retVal = false;
        for (int i = 0; i < src.size(); ++i) {
            LexerToken t = src.get(i);
            if (t == null || t.content == null || !t.type.equals((Object)Token.IDENTIFIER) || !t.content.toUpperCase(Locale.US).equals(PARALLELUPPER) && !t.content.toUpperCase(Locale.US).equals(SHAREDUPPER)) continue;
            ls.recognised(i);
            retVal = true;
            ++i;
            if (debug) {
                ctx.write("parallel|shared=true\n");
            }
            if (i >= src.size()) break;
            t = src.get(i);
            if (t == null || t.content == null || !t.type.equals((Object)Token.IDENTIFIER) || !t.content.toUpperCase(Locale.US).equals(RETRYUPPER)) continue;
            ls.recognised(i);
            ++i;
            if (debug) {
                ctx.write("retry token true\n");
            }
            if (i >= src.size()) break;
            t = src.get(i);
        }
        return retVal;
    }

    static Pair<Integer, String> open(ScriptRunnerContext ctx, List<LexerToken> src, LexState ls) {
        int state = 0;
        String maybeDbName = null;
        for (int i = 0; i < src.size(); ++i) {
            LexerToken t = src.get(i);
            if (t == null || t.content == null || !t.type.equals((Object)Token.IDENTIFIER) || !t.content.toUpperCase(Locale.US).equals(OPENUPPER)) continue;
            ls.recognised(i);
            ++i;
            state = 2;
            if (debug) {
                ctx.write("open=true\n");
            }
            if (i >= src.size()) break;
            t = src.get(i);
            if (t != null && t.content != null && t.type.equals((Object)Token.IDENTIFIER) && t.content.toUpperCase(Locale.US).equals(READUPPER)) {
                ++i;
                state = 2;
                if (debug) {
                    ctx.write("read token true\n");
                }
                if (i >= src.size()) break;
                t = src.get(i);
                if (t != null && t.content != null && t.type.equals((Object)Token.IDENTIFIER) && t.content.toUpperCase(Locale.US).equals(ONLYUPPER)) {
                    ls.recognised(i - 1);
                    ls.recognised(i);
                    ++i;
                    state = 1;
                    if (debug) {
                        ctx.write("readonly=true\n");
                    }
                    if (i >= src.size()) break;
                    t = src.get(i);
                } else if (t != null && t.content != null && t.type.equals((Object)Token.IDENTIFIER) && t.content.toUpperCase(Locale.US).equals(WRITEUPPER)) {
                    ls.recognised(i - 1);
                    ls.recognised(i);
                    ++i;
                    if (debug) {
                        ctx.write("readwrite=true\n");
                    }
                    if (i >= src.size()) break;
                    t = src.get(i);
                    if (t != null && t.content != null && t.type.equals((Object)Token.IDENTIFIER) && t.content.toUpperCase(Locale.US).equals(RECOVERUPPER)) {
                        ls.recognised(i);
                        state = 3;
                        ++i;
                        if (debug) {
                            ctx.write("recover=true\n");
                        }
                        if (i >= src.size()) break;
                        t = src.get(i);
                    }
                }
            } else if (t != null && t.content != null && t.type.equals((Object)Token.IDENTIFIER) && t.content.toUpperCase(Locale.US).equals(RECOVERUPPER)) {
                ls.recognised(i);
                ++i;
                state = 3;
                if (debug) {
                    ctx.write("recover=true\n");
                }
                if (i >= src.size()) break;
                t = src.get(i);
            }
            if (ls.knownToken(t.content)) continue;
            maybeDbName = t.content;
            ls.recognised(i);
            if (!debug) continue;
            ctx.write("maybedbname:" + maybeDbName + "\n");
        }
        return new Pair<Integer, Object>(state, maybeDbName);
    }

    static Pair<Integer, String> mount(ScriptRunnerContext ctx, List<LexerToken> src, LexState ls) {
        int state = 0;
        String maybeDbName = null;
        for (int i = 0; i < src.size(); ++i) {
            LexerToken t = src.get(i);
            if (t == null || t.content == null || !t.type.equals((Object)Token.IDENTIFIER) || !t.content.toUpperCase(Locale.US).equals(MOUNTUPPER)) continue;
            ls.recognised(i);
            state = 1;
            ++i;
            if (debug) {
                ctx.write("mount=true\n");
            }
            if (i >= src.size()) break;
            t = src.get(i);
            if (ls.knownToken(t.content)) continue;
            maybeDbName = t.content;
            ls.recognised(i);
            if (!debug) continue;
            ctx.write("maybedbname:" + maybeDbName + "\n");
        }
        return new Pair<Integer, Object>(state, maybeDbName);
    }

    static String expandEnv(String in) {
        return ScriptUtils.expandVariables(in);
    }

    static String dotName(ScriptRunnerContext ctx, List<LexerToken> src, LexState ls, int i, String current, int offset, String all) {
        Character c;
        int start;
        int length = src.size();
        if (current != null && (current.startsWith("'") || current.startsWith("\""))) {
            return "";
        }
        for (start = src.get((int)i).begin + offset; !(start >= all.length() || (c = Character.valueOf(all.charAt(start))).equals("/") && start + 1 < all.length() && all.charAt(start + 1) == '*' || c.equals("-") && start + 1 < all.length() && all.charAt(start + 1) == '-' || Character.isWhitespace(c.charValue()) || c.equals(Character.valueOf('\r')) || c.equals(Character.valueOf('\n'))); ++start) {
        }
        --start;
        for (int curToken = i; curToken < length && src.get((int)curToken).begin <= start; ++curToken) {
            ls.recognised(curToken);
        }
        return all.substring(src.get((int)i).end, start + 1);
    }

    static String pfile(ScriptRunnerContext ctx, List<LexerToken> src, LexState ls, String all) {
        for (int i = 0; i < src.size(); ++i) {
            List<LexerToken> lexOutput = src;
            String upper = lexOutput.get((int)i).content.toUpperCase(Locale.US);
            if (debug) {
                ctx.write("unknown token:" + upper + "\n");
            }
            boolean itspfile = false;
            if (upper.startsWith("PFILE=") && !upper.equals("PFILE=")) {
                String theToken = lexOutput.get((int)i).content;
                String maybePfile = theToken.substring(theToken.indexOf("=") + 1);
                if (maybePfile == null || maybePfile.length() <= 0) continue;
                ls.recognised(i);
                return Startup.expandEnv(maybePfile + Startup.dotName(ctx, src, ls, i, maybePfile, theToken.indexOf("=") + 1, all));
            }
            if (i - 2 >= 0 && lexOutput.get((int)(i - 1)).content.equals("=") && lexOutput.get((int)(i - 2)).content.toUpperCase(Locale.US).equals(PFILEUPPER)) {
                ls.recognised(i);
                ls.recognised(i - 1);
                ls.recognised(i - 2);
                return Startup.expandEnv(lexOutput.get((int)i).content + Startup.dotName(ctx, src, ls, i, lexOutput.get((int)i).content, 0, all));
            }
            if (i - 1 < 0 || !lexOutput.get((int)i).content.toUpperCase(Locale.US).equals("PFILE=")) continue;
            ls.recognised(i - 1);
            ls.recognised(i);
            return Startup.expandEnv(lexOutput.get((int)i).content + Startup.dotName(ctx, src, ls, i, lexOutput.get((int)i).content, 0, all));
        }
        return null;
    }

    static String pluggableDatabase(ScriptRunnerContext ctx, List<LexerToken> src, LexState ls) {
        LexerToken t;
        int i = 1;
        ArrayList<Integer> recognised = new ArrayList<Integer>();
        String maybeDbName = null;
        if (src.size() > 3 && (t = src.get(i)) != null && t.content != null && t.type.equals((Object)Token.IDENTIFIER) && t.content.toUpperCase(Locale.US).equals(PLUGGABLEUPPER)) {
            recognised.add(i);
            ++i;
            if (debug) {
                ctx.write("pluggable=true\n");
            }
            if (i < src.size()) {
                t = src.get(i);
            } else {
                i = 0;
            }
            if (i != 0 && t != null && t.content != null && t.type.equals((Object)Token.IDENTIFIER) && t.content.toUpperCase(Locale.US).equals(DATABASEUPPER)) {
                recognised.add(i);
                ++i;
                if (debug) {
                    ctx.write("database=true\n");
                }
                if (i < src.size()) {
                    t = src.get(i);
                } else {
                    i = 0;
                }
            }
            if (i != 0 && !ls.knownToken(t.content)) {
                maybeDbName = t.content;
                recognised.add(i);
                for (Integer marked : recognised) {
                    ls.recognised(marked);
                }
                if (debug) {
                    ctx.write("maybedbname:" + maybeDbName + "\n");
                }
            }
        }
        return maybeDbName;
    }

    static String getConName(Connection conn, ScriptRunnerContext ctx) {
        String header = "con_name ";
        String pdb = null;
        boolean nonPdb = false;
        try {
            String querySql = null;
            Connection currConn = ctx.getCurrentConnection();
            DBUtil dbUtil = DBUtil.getInstance(currConn);
            if (VersionTracker.getDbVersion(DefaultConnectionIdentifier.createIdentifier(currConn)).compareTo(new Version("12.1")) >= 0) {
                if (dbUtil.executeOracleReturnOneCol("select NVL(SYS_CONTEXT('USERENV','CDB_NAME'),'1') from dual", null).equals("1")) {
                    pdb = null;
                    nonPdb = true;
                }
                querySql = "SELECT substr(SYS_CONTEXT ('USERENV', 'CON_NAME'),1,30) CON_NAME from dual";
                if (debug) {
                    ctx.write(querySql + "\n");
                }
            } else {
                pdb = null;
                nonPdb = true;
            }
            if (!nonPdb) {
                ArrayList localBind = new ArrayList();
                String result = dbUtil.executeReturnOneCol(querySql, localBind);
                if (result != null) {
                    if (!result.equals("CDB$ROOT")) {
                        pdb = "\"" + result + "\"";
                    }
                } else {
                    ctx.write(header + Messages.getString("SHOWPARAMETERSNORESULTSET"));
                }
            }
        }
        catch (Exception e) {
            Logger.warn(new Startup().getClass(), e.getStackTrace()[0].toString(), e);
        }
        return pdb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String returnConNameIfPublic(Connection conn) {
        String retVal = null;
        Statement stmt = null;
        if (conn != null && conn instanceof OracleConnection) {
            boolean amILocked = LockManager.lock(conn);
            try {
                if (amILocked) {
                    stmt = conn.prepareCall(new StringBuffer("DECLARE \n").append("CHECKONE VARCHAR2(1000):=NULL; \n").append("CON_ID number; \n").append("BEGIN \n").append(" BEGIN \n").append("  if (USER='PUBLIC') THEN \n").append("   CON_ID:=TO_NUMBER(sys_context('USERENV' ,'CON_ID')); /* throws exception if <12.1 */ \n").append("   if ((CON_ID IS NOT NULL) AND (CON_ID>1)) \n").append("   THEN \n").append("    CHECKONE:=sys_context('USERENV','CON_NAME'); \n").append("   END IF; \n").append("  END IF; \n").append(" EXCEPTION \n").append(" WHEN OTHERS THEN \n").append("  CHECKONE :=NULL; \n").append(" END; \n").append(" :CHECKFORONE:=CHECKONE; \n").append("END;").toString());
                    stmt.registerOutParameter(1, 12);
                    stmt.executeUpdate();
                    retVal = stmt.getString(1);
                    if (stmt.wasNull()) {
                        retVal = null;
                    }
                }
            }
            catch (Exception e) {
                retVal = null;
            }
            finally {
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException e) {
                        Logger.ignore(new Startup().getClass(), e);
                    }
                }
                if (amILocked) {
                    LockManager.unlock(conn);
                }
            }
        }
        return retVal;
    }

    private static class LexState {
        private HashSet<String> left = null;
        private HashSet<String> startupTokens = null;
        private TokenState[] checkUsed;
        private List<LexerToken> lexOutput;

        private LexState() {
        }

        public LexState(List<LexerToken> src) {
            this.lexOutput = src;
            this.checkUsed = new TokenState[src.size()];
            for (int i = 0; i < src.size(); ++i) {
                this.checkUsed[i] = TokenState.DEFAULT;
            }
            this.checkUsed[0] = TokenState.USED;
        }

        public TokenState[] getCheckUsed() {
            return this.checkUsed;
        }

        public void recognised(int i) {
            if (debug) {
                System.out.println("Recognised: " + i + " " + this.lexOutput.get((int)i).content);
            }
            this.checkUsed[i] = TokenState.USED;
        }

        public boolean knownToken(String tokenValIn) {
            if (tokenValIn == null) {
                return false;
            }
            if (this.startupTokens == null) {
                this.startupTokens = new HashSet();
                for (String tokenVal : new String[]{"STARTUP", "RESTRICT", Startup.PFILEUPPER, "QUIET", Startup.MOUNTUPPER, Startup.RECOVERUPPER, "NOMOUNT", Startup.PLUGGABLEUPPER, Startup.DATABASEUPPER, "FORCE", "UPGRADE", Startup.OPENUPPER, Startup.READUPPER, Startup.WRITEUPPER, Startup.READUPPER, Startup.ONLYUPPER, "FORCE", "UPGRADE", "RESTRICT", Startup.PFILEUPPER, "=", "DOWNGRADE", "QUIET", Startup.RETRYUPPER, Startup.PARALLELUPPER, Startup.SHAREDUPPER}) {
                    this.startupTokens.add(tokenVal);
                }
            }
            return this.startupTokens.contains(tokenValIn.toUpperCase(Locale.US));
        }

        public boolean allAccountedFor() {
            for (TokenState ts : this.checkUsed) {
                if (!ts.equals((Object)TokenState.DEFAULT)) continue;
                return false;
            }
            return true;
        }

        public boolean populateLeft(ScriptRunnerContext ctx) {
            if (this.left == null) {
                this.left = new HashSet();
                for (int i = 0; i < this.lexOutput.size(); ++i) {
                    if (this.checkUsed[i].equals((Object)TokenState.USED)) continue;
                    String upper = this.lexOutput.get((int)i).content.toUpperCase(Locale.US);
                    if (!this.knownToken(upper)) {
                        if (debug) {
                            ctx.write("unknown token:" + upper + "\n");
                        }
                        return false;
                    }
                    if (this.left.add(upper)) continue;
                    if (debug) {
                        ctx.write(upper + " DUPLICATE \n");
                    }
                    return false;
                }
            }
            return true;
        }

        public boolean leftRemove(String there) {
            return this.left.remove(there.toUpperCase(Locale.US));
        }

        public boolean leftContains(String there) {
            return this.left.contains(there.toUpperCase(Locale.US));
        }

        public boolean leftIsEmpty() {
            return this.left.isEmpty();
        }

        public String remainingTokens() {
            Object output = "";
            for (String val : this.left) {
                output = (String)output + val + " ";
            }
            return output;
        }
    }

    static enum TokenState {
        DEFAULT,
        USED;

    }
}

