/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scheduler.reporting;

import oracle.dbtools.raptor.scheduler.SchedulerMessages;
import oracle.dbtools.raptor.scheduler.SqlclScheduler;
import oracle.dbtools.raptor.scheduler.exceptions.SqlclSchedulerException;
import oracle.dbtools.raptor.scheduler.job.Job;
import oracle.dbtools.raptor.scheduler.reporting.ReportLine;
import oracle.dbtools.raptor.scheduler.reporting.Reporter;
import org.quartz.Trigger;
import org.quartz.listeners.SchedulerListenerSupport;

public class SqlclSchedulerListener
extends SchedulerListenerSupport {
    private final Reporter reporter;

    public SqlclSchedulerListener(Reporter reporter) {
        this.reporter = reporter;
    }

    public void jobScheduled(Trigger trigger) {
        try {
            Job job = (Job)trigger.getJobDataMap().get((Object)"job");
            String jobLogFilePath = this.reporter.getPathResolver().getJobPath(job.getName()).toString();
            this.reporter.reportForAllJobs(ReportLine.ofNow(SqlclScheduler.SqlclSchedulerStatus.SCHEDULE_JOB, ReportLine.Token.of("JOB", job.getName()), ReportLine.Token.of("JOB_LOG", jobLogFilePath)));
        }
        catch (RuntimeException e) {
            throw new SqlclSchedulerException(e);
        }
    }

    public void schedulerStarted() {
        this.reporter.reportForScheduler(ReportLine.ofNow(SqlclScheduler.SqlclSchedulerStatus.STARTED, ReportLine.Token.message(SchedulerMessages.getString("DAEMON_STARTED"))));
    }

    public void schedulerShutdown() {
        this.reporter.reportForScheduler(ReportLine.ofNow(SqlclScheduler.SqlclSchedulerStatus.STOPPED, ReportLine.Token.message(SchedulerMessages.getString("DAEMON_STOPPED"))));
    }
}

