/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.console.statusbar;

import oracle.dbtools.raptor.console.StatusBarComponent;
import oracle.dbtools.raptor.console.statusbar.StatusBarHelp;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectionContext;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectorType;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.NamedConnectionProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.NamedConnectionsConnectorType;
import org.jline.utils.AttributedString;

public class DbIdComponent
implements StatusBarComponent {
    private static final String COMPONENT_NAME = "dbid";

    @Override
    public String getName() {
        return COMPONENT_NAME;
    }

    @Override
    public String getDescription() {
        return StatusBarHelp.getString(COMPONENT_NAME);
    }

    @Override
    public void update(StatusBarComponent.Context context) {
        ConnectionContext connectionContext = context.getScriptRunnerContext().getService(ConnectionContext.class);
        ConnectorType connectorType = connectionContext.getCurrentConnectorType();
        String connName = connectionContext.getCurrentPropertyValues().getValueOf(NamedConnectionProperty.NAME);
        if (connectorType instanceof NamedConnectionsConnectorType && connName != null) {
            context.append(new AttributedString((CharSequence)connName));
        } else {
            String connectId = context.getScriptRunnerContext().doPromptReplaceSqlplusVar(ScriptRunnerContext.SqlplusVariable._CONNECT_IDENTIFIER.toString(), ScriptRunnerContext.SqlplusVariable._CONNECT_IDENTIFIER);
            if (connectId == null || connectId.isEmpty()) {
                connectId = "NOLOG";
            }
            connectId = this.stripQuestionMarks(connectId);
            context.append(new AttributedString((CharSequence)connectId));
        }
    }

    String stripQuestionMarks(String connectid) {
        String[] array;
        if (connectid.contains("?") && (array = connectid.split("\\?")) != null && (array[0] != null || array[0] != "")) {
            return array[0];
        }
        return connectid;
    }
}

