/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ansi.utils;

import com.fasterxml.jackson.jr.ob.JSON;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import oracle.dbtools.common.utils.FileUtils;
import oracle.dbtools.raptor.ansi.utils.ValueComparator;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.utils.ListPrinter;
import oracle.dbtools.raptor.utils.MultiLineTableFormatter;
import oracle.dbtools.raptor.utils.NLSUtils;
import oracle.dbtools.util.Logger;
import org.fusesource.jansi.Ansi;

public class AnsiColorListPrinter
extends ListPrinter {
    private List<ValueComparator> comps;
    private ScriptRunnerContext _ctx;

    @Override
    public void setScriptContext(ScriptRunnerContext ctx) {
        super.setScriptContext(ctx);
        this._ctx = ctx;
        this.comps = null;
        String[] formatterOptions = (String[])ctx.getProperty("sql.format.full");
        String conf = null;
        if (formatterOptions != null) {
            for (String s : formatterOptions) {
                if (!s.startsWith("-config=")) continue;
                conf = s.substring(s.indexOf("=") + 1);
                break;
            }
        }
        if (conf != null) {
            Path f = FileUtils.getFilePath(ctx, conf);
            if (f != null && f.toFile().exists()) {
                try {
                    byte[] jsonData = Files.readAllBytes(f);
                    Map m = JSON.std.mapFrom((Object)jsonData);
                    String highlights = JSON.std.asString(m.get("highlights"));
                    JSON json = JSON.std.with(new JSON.Feature[]{JSON.Feature.USE_FIELDS}).with(new JSON.Feature[]{JSON.Feature.FAIL_ON_UNKNOWN_BEAN_PROPERTY});
                    this.comps = json.listOfFrom(ValueComparator.class, (Object)highlights);
                    if (this.comps != null && this.comps.size() > 0) {
                        for (ValueComparator comp : this.comps) {
                            comp.preProcess();
                        }
                        this.forcePrintValue(true);
                    }
                }
                catch (Exception e) {
                    ctx.write(MessageFormat.format(Messages.getString("SQLFORMAT.ANSI.BADFILE"), conf, e.getLocalizedMessage()));
                }
            } else {
                ctx.write(MessageFormat.format(Messages.getString("SQLFORMAT.ANSI.BADFILE"), conf, ""));
            }
        }
    }

    @Override
    public void print(OutputStream outStream, Connection conn, List<List<?>> rows, int pageSize, String nullDisplay, List<Boolean> isNumber) throws IOException {
        if (rows == null || rows.size() <= 1) {
            return;
        }
        OutputStreamWriter out = new OutputStreamWriter(outStream);
        ArrayList<List<String>> tableStringRepresentation = new ArrayList<List<String>>(rows.size());
        for (List<?> row : rows) {
            List rowStringRepresentation = row.stream().map(o -> NLSUtils.format(conn, o)).map(s -> s == null ? nullDisplay : this.higlightValue((String)s)).collect(Collectors.toList());
            tableStringRepresentation.add(rowStringRepresentation);
        }
        MultiLineTableFormatter.FormatedTable formatedTable = MultiLineTableFormatter.format(tableStringRepresentation, isNumber);
        this.printHeaders(out, formatedTable.getColumnWidths(), 0, (List)tableStringRepresentation.get(0), isNumber);
        formatedTable.getRows().stream().skip(1L).flatMap(Collection::stream).forEach(cell -> this.printValue(out, 0, (String)cell, false));
        Object mute = null;
        if (this._ctx != null) {
            mute = this._ctx.getProperty("ILISTPRINTER_MUTE_NEWLINE");
        }
        if (mute == null || !mute.equals(Boolean.TRUE)) {
            out.write("\n");
        }
        out.flush();
    }

    @Override
    public void printListofList(ScriptRunnerContext ctx, String title, List<List<?>> rows) {
        if (title != null) {
            ctx.write(String.valueOf(Ansi.ansi().format(title, new Object[0]).reset()) + "\n");
        }
        this.printListofList(ctx, rows);
    }

    @Override
    public void printHeaders(OutputStreamWriter out, int[] widths, int i, List<?> headers, List<Boolean> isNumber) throws IOException {
        StringBuilder headerLine = new StringBuilder(256);
        headerLine.append('\n');
        int j = 0;
        for (Object col : headers) {
            String header = Ansi.ansi().a(Ansi.Attribute.INTENSITY_BOLD).render(col.toString()).reset().toString();
            int finalColumnWidth = widths[j] - MultiLineTableFormatter.getVisibleWidth(header);
            out.write(header + " ".repeat(finalColumnWidth + 1));
            headerLine.append("_".repeat(widths[j]));
            headerLine.append(' ');
            ++j;
        }
        headerLine.append('\n');
        out.write(headerLine.toString());
    }

    @Override
    public void writeBoldUnderlineFormat(ScriptRunnerContext ctx, String col, int width) {
        ctx.write(Ansi.ansi().bold().a(Ansi.Attribute.UNDERLINE).format("%-" + width + "s", new Object[]{col}).reset().toString());
        ctx.write(" ");
    }

    private String higlightValue(String val) {
        if (this.comps == null || this.comps.isEmpty()) {
            return val;
        }
        String decoratedVal = val;
        for (ValueComparator vcomp : this.comps) {
            switch (vcomp.getType()) {
                case "REGEX": {
                    decoratedVal = this.highlightRegex(val, vcomp);
                    break;
                }
                case "EXACT": {
                    decoratedVal = this.highlightExact(val, vcomp);
                    break;
                }
                case "STARTWITH": {
                    decoratedVal = this.highlightStartWith(val, vcomp);
                    break;
                }
                case "ENDSWITH": {
                    decoratedVal = this.highlightEndsWith(val, vcomp);
                    break;
                }
                case "CONTAINS": {
                    decoratedVal = this.highlightContains(val, vcomp);
                    break;
                }
                default: {
                    if (!this.contaisMarkupSyntax(val)) break;
                    try {
                        decoratedVal = Ansi.ansi().render(val).toString();
                        break;
                    }
                    catch (Exception e) {
                        Logger.finest(this.getClass(), "Ansi.ansi().render(val)" + e.getLocalizedMessage(), e);
                    }
                }
            }
            if (decoratedVal.length() == val.length()) continue;
            break;
        }
        return decoratedVal;
    }

    @Override
    public void printValue(OutputStreamWriter out, int width, String val, boolean isNumber) {
        try {
            out.write(val);
        }
        catch (Exception e) {
            Logger.finest(this.getClass(), "out.write(val) " + e.getLocalizedMessage(), e);
        }
    }

    private String highlightRegex(String candidate, ValueComparator valueComparator) {
        Optional<Pattern> pattern = valueComparator.getPattern();
        if (pattern.isEmpty()) {
            return candidate;
        }
        Matcher matcher = pattern.get().matcher(candidate);
        String colorPre = "@|" + valueComparator.getColor() + " ";
        String colorPost = "|@";
        String highlightedValue = matcher.replaceAll(match -> Ansi.ansi().render(colorPre + match.group() + "|@").toString());
        return highlightedValue;
    }

    private String highlightExact(String candidate, ValueComparator valueComparator) {
        if (!candidate.equals(valueComparator.getTest())) {
            return candidate;
        }
        String highlightedValue = "@|" + valueComparator.getColor() + " " + candidate + "|@";
        return Ansi.ansi().render(highlightedValue).toString();
    }

    private String highlightStartWith(String candidate, ValueComparator valueComparator) {
        if (!candidate.startsWith(valueComparator.getTest())) {
            return candidate;
        }
        String highlightedMatch = Ansi.ansi().render("@|" + valueComparator.getColor() + " " + valueComparator.getTest() + "|@").toString();
        String ansiRepresentation = candidate.replaceFirst(valueComparator.getTest(), highlightedMatch);
        return ansiRepresentation;
    }

    private String highlightEndsWith(String candidate, ValueComparator valueComparator) {
        if (!candidate.endsWith(valueComparator.getTest())) {
            return candidate;
        }
        String highlightedMatch = Ansi.ansi().render("@|" + valueComparator.getColor() + " " + valueComparator.getTest() + "|@").toString();
        String highlightedValue = candidate.substring(0, candidate.lastIndexOf(valueComparator.getTest())) + highlightedMatch;
        return highlightedValue;
    }

    private String highlightContains(String candidate, ValueComparator valueComparator) {
        if (!candidate.contains(valueComparator.getTest())) {
            return candidate;
        }
        String highlightedMatch = Ansi.ansi().render("@|" + valueComparator.getColor() + " " + valueComparator.getTest() + "|@").toString();
        return candidate.replace(valueComparator.getTest(), highlightedMatch);
    }

    private boolean contaisMarkupSyntax(String val) {
        return val.toString().indexOf("@|") >= 0 && val.toString().indexOf("|@") > 0;
    }
}

