/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plusplus.ssh;

import java.util.List;
import oracle.dbtools.raptor.newscriptrunner.IGetPromptedFieldProvider;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.scriptrunner.cmdline.handlers.SQLCliPromptedAcceptProvider;
import org.apache.sshd.client.auth.keyboard.UserInteraction;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.config.keys.FilePasswordProvider;

public final class SSHConsole {
    private final ScriptRunnerContext ctx;

    public SSHConsole(ScriptRunnerContext ctx) {
        this.ctx = ctx;
    }

    public UserInteraction getUserInteraction() {
        return new UserInteraction(){

            public boolean isInteractionAllowed(ClientSession session) {
                return true;
            }

            public void serverVersionInfo(ClientSession session, List<String> lines) {
                if (lines != null) {
                    SSHConsole.this.ctx.write("Extended server version info\n");
                    for (String line : lines) {
                        SSHConsole.this.ctx.write(line);
                        SSHConsole.this.ctx.write("\n");
                    }
                }
            }

            public void welcome(ClientSession session, String banner, String lang) {
                SSHConsole.this.ctx.write(banner + "\n");
            }

            public String[] interactive(ClientSession session, String name, String instruction, String lang, String[] prompt, boolean[] echo) {
                String[] result = new String[]{};
                if (prompt != null && prompt.length > 0) {
                    SSHConsole.this.ctx.write(instruction + "\n");
                    result = new String[prompt.length];
                    for (int i = 0; i < prompt.length; ++i) {
                        result[i] = PromptHolder.getPromptedValue(SSHConsole.this.ctx, prompt[i], !echo[i]);
                    }
                }
                return result;
            }

            public String getUpdatedPassword(ClientSession session, String prompt, String lang) {
                return PromptHolder.getPromptedValue(SSHConsole.this.ctx, prompt, true);
            }
        };
    }

    public FilePasswordProvider getPasswordProvider() {
        return (context, resource, index) -> PromptHolder.getPromptedValue(this.ctx, "Enter passphrase for key '" + resource.getName() + "'", true);
    }

    private static class PromptHolder {
        static final PromptHolder INSTANCE = new PromptHolder();
        private IGetPromptedFieldProvider provider = new SQLCliPromptedAcceptProvider();

        private PromptHolder() {
        }

        public static String getPromptedValue(ScriptRunnerContext ctx, String prompt, boolean hide) {
            return INSTANCE._getPromptedValue(ctx, prompt, hide);
        }

        private String _getPromptedValue(ScriptRunnerContext ctx, String prompt, boolean hide) {
            return this.provider.getPromptedField(ctx, prompt, hide);
        }
    }
}

