/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plusplus.connections.db;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import oracle.dbtools.common.utils.PlatformUtils;
import oracle.dbtools.core.connections.ConnectionIdentifiers;
import oracle.dbtools.core.connections.ConnectionsResources;
import oracle.dbtools.core.connections.folder.Folder;
import oracle.dbtools.core.connections.folder.utils.FolderUtils;
import oracle.dbtools.core.connections.storage.ConnectionReference;
import oracle.dbtools.core.connections.storage.ConnectionStorage;
import oracle.dbtools.core.oci.OCICompartment;
import oracle.dbtools.core.oci.OCIIdentityClient;
import oracle.dbtools.core.oci.OCIProfile;
import oracle.dbtools.core.oci.OCIProfiles;
import oracle.dbtools.core.oci.connections.OCIStoredConnectionSupport;
import oracle.dbtools.core.util.DbtoolsException;
import oracle.dbtools.core.util.MessageLogger;
import oracle.dbtools.net.commands.CommandMessages;
import oracle.dbtools.plusplus.connections.db.ConnectionStoreCommand;
import oracle.dbtools.plusplus.connections.db.NamedConnections;
import oracle.dbtools.plusplus.util.CommandContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.NoSuchConnectionFolderException;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.save.ConnectionsFolderManager;

abstract class DisplayFormatter {
    protected final MessageLogger logger;
    protected final String path;
    protected final boolean isFlat;

    protected DisplayFormatter(CommandContext ctx, String path, boolean isFlat) {
        this.logger = ctx.getMessageLogger();
        this.path = path;
        this.isFlat = isFlat;
    }

    protected final void printTree(DisplayContainer container, String prefix, boolean isLast, boolean isFirstEver) {
        if (container == null) {
            return;
        }
        String folderName = container.getContainerName() == null ? "." : container.getContainerName();
        TreeStyle treeStyle = TreeStyle.defaultStyle();
        Object childPrefix = "";
        if (isFirstEver) {
            this.logger.logUserMessage(folderName);
        } else {
            this.logger.logUserMessage(prefix + (isLast ? treeStyle.lastBranch : treeStyle.branch) + folderName);
            childPrefix = prefix + (isLast ? "    " : treeStyle.vertical);
        }
        List<DisplayContainer> subFolders = container.getContainers();
        int subFolderCount = subFolders.size();
        int index = 0;
        for (DisplayContainer subFolder : subFolders) {
            boolean isSubFolderLast = index == subFolderCount - 1 && container.getConnections().isEmpty();
            this.printTree(subFolder, (String)childPrefix, isSubFolderLast, false);
            ++index;
        }
        List<String> connections = container.getConnections();
        for (int i = 0; i < connections.size(); ++i) {
            String current = connections.get(i);
            boolean isConnectionLast = i == connections.size() - 1;
            this.logger.logUserMessage((String)childPrefix + (isConnectionLast ? treeStyle.lastBranch : treeStyle.branch) + Colors.YELLOW.code + current + Colors.RESET.code);
        }
    }

    protected abstract void listConnections();

    static DisplayFormatter createStoredConnectionDisplay(CommandContext ctx, String path, boolean isFlat) {
        return new StoredConnectionDisplay(ctx, path, isFlat);
    }

    public static DisplayFormatter createOCIDisplay(CommandContext ctx, String path, boolean isFlat) {
        return new OCIConnectionDisplay(ctx, path, isFlat);
    }

    protected static class DisplayContainer {
        protected String displayName;
        protected List<DisplayContainer> compartments = new ArrayList<DisplayContainer>();
        protected List<String> connections = new ArrayList<String>();

        protected DisplayContainer() {
        }

        public List<DisplayContainer> getContainers() {
            return this.compartments;
        }

        public List<String> getConnections() {
            return this.connections;
        }

        public String getContainerName() {
            return this.displayName;
        }

        public void setContainerName(String containerName) {
            this.displayName = containerName;
        }

        void pruneContainers() {
            this.compartments = this.compartments.stream().filter(childCompartment -> {
                childCompartment.pruneContainers();
                return !childCompartment.connections.isEmpty() || !childCompartment.compartments.isEmpty();
            }).collect(Collectors.toList());
        }

        public void addCompartment(DisplayContainer compartment) {
            this.compartments.add(compartment);
        }

        public void addConnection(String connection) {
            this.connections.add(connection);
        }
    }

    protected static enum TreeStyle {
        ASCII("+--- ", "|   ", "|___ "),
        UNICODE("\u251c\u2500\u2500 ", "\u2502   ", "\u2514\u2500\u2500 ");

        public final String branch;
        public final String vertical;
        public final String lastBranch;

        private TreeStyle(String branch, String vertical, String lastBranch) {
            this.branch = branch;
            this.vertical = vertical;
            this.lastBranch = lastBranch;
        }

        public static TreeStyle defaultStyle() {
            if (PlatformUtils.isWindows() || !StandardCharsets.UTF_8.name().equalsIgnoreCase(Charset.defaultCharset().displayName())) {
                return ASCII;
            }
            return UNICODE;
        }
    }

    protected static enum Colors {
        YELLOW("\u001b[0;33m"),
        RESET("\u001b[0m");

        private final String code;

        private Colors(String code) {
            this.code = code;
        }
    }

    private static class StoredConnectionDisplay
    extends DisplayFormatter {
        StoredConnectionDisplay(CommandContext ctx, String path, boolean isFlat) {
            super(ctx, path, isFlat);
        }

        @Override
        protected void listConnections() {
            if (this.isFlat) {
                NamedConnections.instance().listConnections().forEach(arg_0 -> ((MessageLogger)this.logger).logUserMessage(arg_0));
                return;
            }
            ConnectionsFolderManager connectionsFolderManager = new ConnectionsFolderManager();
            this.list(connectionsFolderManager.getRootFolder());
        }

        private void list(Folder rootFolder) {
            Folder folder = (Folder)FolderUtils.findFolder((Folder)rootFolder, (String)this.path).orElseThrow(() -> new NoSuchConnectionFolderException(ConnectionsResources.format((String)"NO_SUCH_FOLDER", (Object[])new Object[]{this.path})));
            if (folder.getName() == null) {
                Set allConnections = folder.getAllNestedConnections();
                folder.addConnections(ConnectionStorage.instance().listConnectionDirectories().stream().map(arg_0 -> ((ConnectionStorage)ConnectionStorage.instance()).loadConnectionReference(arg_0)).filter(def -> !allConnections.contains(def.getConnectionIdentifier().toString())).map(ConnectionReference::getConnectionName).map(ConnectionIdentifiers::createIdentifier).collect(Collectors.toList()));
            }
            if (this.isFlat) {
                folder.getAllNestedConnections().stream().map(id -> ConnectionStorage.instance().loadConnectionReference(id)).map(ConnectionReference::getConnectionName).forEach(arg_0 -> ((MessageLogger)this.logger).logUserMessage(arg_0));
            } else {
                List connectionDirectories = ConnectionStorage.instance().listConnectionDirectories();
                DisplayContainer rootContainer = this.createDisplay(folder, connectionDirectories);
                this.printTree(rootContainer, "", true, true);
            }
        }

        private DisplayContainer createDisplay(Folder folder, List<String> connectionDirectories) {
            DisplayContainer container = new DisplayContainer();
            container.setContainerName(folder.getName());
            Map subFolders = folder.getSubFolders();
            for (Map.Entry entry : subFolders.entrySet()) {
                DisplayContainer subContainer = this.createDisplay((Folder)entry.getValue(), connectionDirectories);
                container.addCompartment(subContainer);
            }
            folder.getConnections().stream().map(c -> {
                if (connectionDirectories.contains(c.toString())) {
                    return ConnectionStorage.instance().loadConnectionReference(c.toString()).getConnectionName();
                }
                return c.toString();
            }).sorted().forEach(container::addConnection);
            return container;
        }
    }

    private static class OCIConnectionDisplay
    extends DisplayFormatter {
        private final OCIStoredConnectionSupport ociSupport;
        private final OCIIdentityClient ociIdentityClient;

        OCIConnectionDisplay(CommandContext ctx, String path, boolean isFlat) {
            super(ctx, path, isFlat);
            OCIProfile profile;
            this.ociSupport = ConnectionStoreCommand.createOciSupport(ctx.getScriptRunnerContext());
            ScriptRunnerContext scriptRunnerContext = ctx.getScriptRunnerContext();
            String profileName = (String)scriptRunnerContext.getProperty("oci.profile.name");
            if (profileName == null) {
                throw new DbtoolsException(CommandMessages.getString((String)"OCI_PROFILE_NOT_SET"));
            }
            try {
                OCIProfiles profiles = OCIProfiles.builder().build();
                profile = profiles.getProfile(profileName);
                if (profile == null) {
                    throw new DbtoolsException(CommandMessages.format((String)"OCI_PROFILE_NOT_VALID", (Object[])new Object[]{profile}));
                }
            }
            catch (IOException e) {
                throw new DbtoolsException((Throwable)e);
            }
            OCIIdentityClient.Builder builder = OCIIdentityClient.builder((OCIProfile)profile);
            if (scriptRunnerContext.getProperty("oci.region.name") != null) {
                builder.region((String)scriptRunnerContext.getProperty("oci.region.name"));
            }
            this.ociIdentityClient = builder.build();
        }

        @Override
        protected void listConnections() {
            Collection connections = this.ociSupport.listConnections(OCIStoredConnectionSupport.ORACLE_DATABASES);
            if (this.isFlat) {
                connections.forEach(p -> this.logger.logUserMessage(p.getDisplayName()));
            } else {
                String tenancy = this.ociIdentityClient.getAuthenticationProvider().getTenantId();
                HashMap compartmentDisplayMap = new HashMap();
                Map compartmentMap = this.ociIdentityClient.getCompartmentMap();
                connections.forEach(searchResult -> {
                    String compartmentId = searchResult.getCompartmentID();
                    String displayName = searchResult.getDisplayName();
                    DisplayContainer compartmentDisplay = (DisplayContainer)compartmentDisplayMap.get(compartmentId);
                    if (compartmentDisplay == null) {
                        compartmentDisplay = new DisplayContainer();
                        OCICompartment compartment = (OCICompartment)compartmentMap.get(compartmentId);
                        if (compartment != null) {
                            compartmentDisplay.setContainerName(compartment.getDisplayName());
                        }
                        compartmentDisplayMap.put(compartmentId, compartmentDisplay);
                    }
                    compartmentDisplay.addConnection(displayName);
                });
                this.ociIdentityClient.getCompartmentMap().values().forEach(compartment -> {
                    String resourceId = compartment.getResourceId();
                    String parentID = compartment.getCompartmentID();
                    DisplayContainer display = (DisplayContainer)compartmentDisplayMap.get(resourceId);
                    if (display == null) {
                        display = new DisplayContainer();
                        compartmentDisplayMap.put(resourceId, display);
                    }
                    display.setContainerName(compartment.getDisplayName());
                    DisplayContainer parentDisplay = (DisplayContainer)compartmentDisplayMap.get(parentID);
                    if (parentDisplay == null) {
                        parentDisplay = new DisplayContainer();
                        compartmentDisplayMap.put(parentID, parentDisplay);
                    }
                    parentDisplay.addCompartment(display);
                });
                DisplayContainer rootCompartmentDisplay = (DisplayContainer)compartmentDisplayMap.get(tenancy);
                rootCompartmentDisplay.pruneContainers();
                this.printTree(rootCompartmentDisplay, "", true, true);
            }
        }
    }
}

