/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.cpat.generators;

import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.ReportFormat;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import oracle.dbtools.cpat.CpatResources;
import oracle.dbtools.cpat.commands.MigrateAdvisorOptions;
import oracle.dbtools.cpat.common.CpatArguments;
import oracle.dbtools.cpat.common.CpatModel;
import oracle.dbtools.cpat.common.CpatOption;
import oracle.dbtools.cpat.common.CpatOptionValues;
import oracle.dbtools.cpat.common.CpatOptions;
import oracle.dbtools.cpat.common.CpatQuery;
import oracle.dbtools.cpat.utilities.CpatFileUtils;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.LockManager;

public class CpatPreprocessor {
    private static final String DQ = "\"";
    private static final String SQ = "'";
    private static final String NL = "\n";
    private CpatModel _model;
    private CpatArguments _args;
    private CpatOptionValues _optionValues;

    public CpatPreprocessor(CpatModel model) {
        this._model = model;
        this._args = this._model.getArgs();
        this._optionValues = this._model.getOptionValues();
    }

    public boolean check() {
        if (this._model.isVerbose() || this._model.isDebug()) {
            this._model.getToolLogger().logProcessStart(CpatResources.getString("CP_PREPROCESS"));
        }
        if (this.validateConflictingArguments() && this.checkArgumentValues()) {
            this.checkAccess();
        }
        this.handleArgConversions();
        return this._model.isValid();
    }

    public boolean validateConflictingArguments() {
        List<String> schemasArg = this._optionValues.getOptionStringList(MigrateAdvisorOptions.Symbol.SCHEMAS);
        List<String> xschemasArg = this._optionValues.getOptionStringList(MigrateAdvisorOptions.Symbol.EXCLUDESCHEMAS);
        if (schemasArg != null && xschemasArg != null) {
            this._model.getToolLogger().logError(CpatResources.format("CPPRE_OPTS_CONFLICT", "schemas", "excludeschemas"));
            this._model.isValid(false);
        }
        return this._model.isValid();
    }

    public boolean checkArgumentValues() {
        return this._model.isValid();
    }

    public boolean checkAccess() {
        if (this._model.isAdvise()) {
            this.handleDir("outdir");
            this.handlePrefix("outfileprefix");
            this.handleProperties("analysisprops");
            this.handleMigrationMethod("migrationmethod");
            this.handleReportFormat("reportformat");
            this.handleMaxTextDataRows("maxtextdatarows");
        } else if (this._model.isProperties()) {
            this.handleDir("outdir");
            this.handlePrefix("outfileprefix");
        }
        if (this._model.isValid()) {
            List<String> reports = this._model.getUserFileLocations();
            if (this._model.isVerbose() || this._model.isDebug()) {
                for (String report : reports) {
                    this._model.getToolLogger().log("User File: " + report);
                }
            }
        }
        return this._model.isValid();
    }

    private void handleDir(String optName) {
        String dir = this.unquote(this._optionValues.getOptionString(MigrateAdvisorOptions.Symbol.OUTDIR));
        String cdDir = (String)this._model.getCtx().getProperty("script.runner.cd_command");
        Path path = null;
        if (dir == null) {
            dir = cdDir;
            if (dir != null) {
                path = Paths.get(dir, new String[0]);
                if (!Files.exists(path, new LinkOption[0])) {
                    this._model.getToolLogger().logError(CpatResources.format("CPPRE_CD_NOT_EXIST", path.toString()));
                    this._model.isValid(false);
                } else if (!Files.isDirectory(path, new LinkOption[0])) {
                    this._model.getToolLogger().logError(CpatResources.format("CPPRE_CD_NOT_DIRECTORY", path.toString()));
                    this._model.isValid(false);
                } else if (!Files.isWritable(path)) {
                    this._model.getToolLogger().logError(CpatResources.format("CPPRE_CD_NOT_WRITABLE", path.toString()));
                    this._model.isValid(false);
                } else {
                    this._args.put(optName, dir);
                    this._optionValues.setOptionString(MigrateAdvisorOptions.Symbol.OUTDIR, dir);
                }
            } else {
                this._args.put(optName, new File("").getAbsolutePath());
                this._optionValues.setOptionString(MigrateAdvisorOptions.Symbol.OUTDIR, new File("").getAbsolutePath());
            }
        } else {
            path = Paths.get(dir, new String[0]);
            if (!path.isAbsolute()) {
                path = cdDir != null ? CpatFileUtils.concatDir(cdDir, dir) : CpatFileUtils.concatDir(new File("").getAbsolutePath(), dir);
            }
            if (Files.exists(path, new LinkOption[0])) {
                if (!Files.isDirectory(path, new LinkOption[0])) {
                    this._model.getToolLogger().logError(CpatResources.format("CPPRE_OUTDIR_NOT_DIRECTORY", path.toString()));
                    this._model.isValid(false);
                }
                if (!Files.isWritable(path)) {
                    this._model.getToolLogger().logError(CpatResources.format("CPPRE_OUTDIR_NOT_DIRECTORY", path.toString()));
                    this._model.isValid(false);
                }
            } else {
                try {
                    Files.createDirectories(path, new FileAttribute[0]);
                    if (!Files.isWritable(path)) {
                        this._model.getToolLogger().logError(CpatResources.format("CPPRE_OUTDIR_NOT_WRITABLE", path.toString()));
                        this._model.isValid(false);
                    }
                }
                catch (IOException e) {
                    this._model.getToolLogger().logError(CpatResources.format("CPPRE_OUTDIR_NOT_CREATE", path.toString()));
                    this._model.isValid(false);
                }
            }
            this._args.put(optName, path.toString());
            this._optionValues.setOptionString(MigrateAdvisorOptions.Symbol.OUTDIR, path.toString());
        }
    }

    private void handleMaxTextDataRows(String optName) {
        List<String> reports = this._optionValues.getOptionStringList(MigrateAdvisorOptions.Symbol.REPORTFORMAT);
        Integer maxText = this._optionValues.getOptionInteger(MigrateAdvisorOptions.Symbol.MAXTEXTDATAROWS);
        Integer maxRel = this._optionValues.getOptionInteger(MigrateAdvisorOptions.Symbol.MAXRELEVANTOBJECTS);
        if (maxText != null) {
            if (!reports.stream().anyMatch(report -> report.equalsIgnoreCase(ReportFormat.TEXT.toString()))) {
                this._model.getToolLogger().logError(CpatResources.getString("CPPRE_CPAT1009"));
                this._model.isValid(false);
            }
            if (maxRel != null && maxText > maxRel) {
                this._model.getToolLogger().logWarning(CpatResources.getString("CPPRE_CPAT1012"));
                this._args.put(optName, maxRel);
                this._optionValues.setOptionInteger(MigrateAdvisorOptions.Symbol.MAXTEXTDATAROWS, maxRel);
            }
        }
    }

    private void handleMigrationMethod(String optName) {
        ArrayList<String> listArg = new ArrayList<String>(this._optionValues.getOptionStringList(MigrateAdvisorOptions.Symbol.MIGRATIONMETHOD));
        boolean dp = false;
        boolean dplink = false;
        if (this.listHasValues(listArg)) {
            for (String value : listArg) {
                if (value.equalsIgnoreCase(MigrationMethod.DATAPUMP.toString())) {
                    dp = true;
                }
                if (!value.equalsIgnoreCase(MigrationMethod.DATAPUMP_DBLINK.toString())) continue;
                dplink = true;
            }
            if (dp && dplink) {
                this._model.getToolLogger().logWarning(CpatResources.getString("CPPRE_CPAT1010"));
                listArg.remove(MigrationMethod.DATAPUMP.toString().toLowerCase());
                this._args.put(optName, listArg);
                this._optionValues.setOptionStringList(MigrateAdvisorOptions.Symbol.MIGRATIONMETHOD, listArg);
            }
        }
    }

    private void handlePrefix(String optName) {
        String prefix = this.unquote(this._optionValues.getOptionString(MigrateAdvisorOptions.Symbol.OUTFILEPREFIX));
        if (!(prefix == null || Pattern.matches("^[-_\\.A-Za-z0-9]+$", prefix) && !prefix.equals("") && Character.isAlphabetic(prefix.charAt(0)))) {
            this._model.getToolLogger().logError(CpatResources.getString("CPPRE_CPAT1011"));
            this._model.isValid(false);
        }
        this._args.put(optName, prefix);
        this._optionValues.setOptionString(MigrateAdvisorOptions.Symbol.OUTFILEPREFIX, prefix);
    }

    private void handleProperties(String optName) {
        String propFileStr = this.unquote(this._optionValues.getOptionString(MigrateAdvisorOptions.Symbol.ANALYSISPROPS));
        if (propFileStr != null) {
            String cdDir;
            Path path = null;
            File propFile = null;
            try {
                path = Paths.get(propFileStr, new String[0]);
                propFile = path.toFile();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (path != null && !path.isAbsolute() && (cdDir = (String)this._model.getCtx().getProperty("script.runner.cd_command")) != null) {
                String prepend = this._model.getCtx().prependCD(propFileStr);
                if (prepend != null) {
                    propFile = new File(prepend);
                } else {
                    this._model.getToolLogger().logError(CpatResources.format("CPPRE_PROPS_FILE_NOT_VALID", propFileStr));
                    this._model.isValid(false);
                    return;
                }
            }
            if (propFile != null) {
                if (!propFile.exists()) {
                    this._model.getToolLogger().logError(CpatResources.format("CPPRE_PROP_FILE_NOT_EXIST", propFile.getAbsolutePath()));
                    this._model.isValid(false);
                } else if (!propFile.isFile()) {
                    this._model.getToolLogger().logError(CpatResources.format("CPPRE_PROP_FILE_NOT_FILE", propFile.getAbsolutePath()));
                    this._model.isValid(false);
                } else if (!propFile.canRead()) {
                    this._model.getToolLogger().logError(CpatResources.format("CPPRE_PROP_FILE_NOT_READABLE", propFile.getAbsolutePath()));
                    this._model.isValid(false);
                } else {
                    this._args.put(optName, propFile.getPath());
                    this._optionValues.setOptionString(MigrateAdvisorOptions.Symbol.ANALYSISPROPS, propFile.getPath());
                }
            }
        }
    }

    private void handleReportFormat(String optName) {
        List<String> listArg = this._optionValues.getOptionStringList(MigrateAdvisorOptions.Symbol.REPORTFORMAT);
        ArrayList<String> newListArg = new ArrayList<String>();
        boolean json = false;
        if (this.listHasValues(listArg)) {
            for (String value : listArg) {
                if (value.equalsIgnoreCase(ReportFormat.JSON.toString())) {
                    json = true;
                    newListArg.add(ReportFormat.JSON.toString());
                    continue;
                }
                if (value.equalsIgnoreCase("html")) {
                    this._model.isDoHtml(true);
                    continue;
                }
                newListArg.add(value);
            }
            if (!json) {
                newListArg.add(ReportFormat.JSON.toString());
                this._model.isUserJson(false);
            }
        } else {
            newListArg.add(ReportFormat.JSON.toString());
            this._model.isUserJson(false);
            this._model.isDoHtml(true);
        }
        this._args.put("reportformat", newListArg);
        this._optionValues.setOptionStringList(MigrateAdvisorOptions.Symbol.REPORTFORMAT, newListArg);
    }

    private boolean listHasValues(List<String> list) {
        if (list == null) {
            return false;
        }
        return !list.isEmpty();
    }

    private boolean canCreateIn(File dir) {
        File tmpFile = null;
        try {
            tmpFile = File.createTempFile("cpat", ".tmp", dir);
            FileOutputStream tmpStream = new FileOutputStream(tmpFile);
            tmpStream.write(1);
            tmpStream.close();
            tmpFile.delete();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private void handleArgConversions() {
        Map<String, CpatOption> options = CpatOptions.getGenBooleanOptions();
        for (Map.Entry<String, CpatOption> entry : options.entrySet()) {
            CpatOption opt = entry.getValue();
            String key = entry.getKey();
            if (opt.getGenBoolean().equals("t")) {
                if (this._model.isArgTrue(key)) continue;
                this._args.remove(key);
                continue;
            }
            if (!this._model.isArgTrue(key)) continue;
            this._args.remove(key);
        }
    }

    private String cleanName(String name) {
        if (name == null || name.isEmpty()) {
            return name;
        }
        if (name.startsWith(DQ) && name.endsWith(DQ)) {
            return name.substring(1, name.length() - 1);
        }
        return name.toUpperCase();
    }

    private String cleanObjectType(String type) {
        if (type.startsWith(DQ) && type.endsWith(DQ) && type.length() > 1) {
            return type.substring(1, type.length() - 1).toUpperCase();
        }
        return type;
    }

    private String unquote(String string) {
        if (string != null && !string.isEmpty() && string.startsWith(DQ) && string.endsWith(DQ) && string.length() > 1) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    private boolean existsSchema(String name) {
        String value = null;
        try {
            String query = CpatQuery.getQuery("cpatExistsSchema", this._model.getConn());
            if (query != null) {
                HashMap<String, Object> binds = new HashMap<String, Object>();
                binds.put("SCHEMA", name);
                value = (String)this.executeOneCol(query, binds);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return value != null && value.equals("1");
    }

    private boolean assertName(String name) {
        String value = null;
        try {
            String query = CpatQuery.getQuery("cpatAssertName", this._model.getConn());
            if (query != null) {
                HashMap<String, Object> binds = new HashMap<String, Object>();
                binds.put("NAME", name);
                value = (String)this.executeOneCol(query, binds);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return value != null;
    }

    private Object executeOneCol(String query) throws SQLException {
        return this.executeOneCol(query, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeOneCol(String query, Map<String, Object> binds) throws SQLException {
        String rtn = null;
        if (LockManager.lock((Connection)this._model.getConn())) {
            try {
                DBUtil dbUtil = DBUtil.getInstance((Connection)this._model.getConn());
                rtn = dbUtil.executeReturnOneCol(query, binds);
                SQLException e = dbUtil.getLastException();
                if (e != null) {
                    throw e;
                }
            }
            finally {
                LockManager.unlock((Connection)this._model.getConn());
            }
        }
        return rtn;
    }

    private String[] utilSplit(String baseString, String separator) {
        String[] retVal = null;
        String nullBase = baseString;
        String nullSeparator = separator;
        if (baseString == null) {
            nullBase = "";
        }
        if (separator == null) {
            nullSeparator = "";
        }
        if (baseString == null || separator == null) {
            retVal = null;
        } else {
            retVal = baseString.split(separator, -1);
            boolean isNull = false;
            for (String val : retVal) {
                if (!val.isEmpty()) continue;
                isNull = true;
            }
            if (retVal == null || retVal.length == 0) {
                isNull = true;
            }
            if (isNull) {
                retVal = null;
            }
        }
        if (retVal == null) {
            this._model.getToolLogger().logError(CpatResources.format("CPPRE_INVALID_LIST", nullBase, nullSeparator));
            this._model.isValid(false);
        }
        return retVal;
    }
}

