/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.importer.writers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.importer.writers.IImportGenerator;
import oracle.dbtools.importer.writers.ImportGenDbmsCloud;
import oracle.dbtools.util.Logger;

public class ImportGenRegistry {
    private static Map<Integer, Class<? extends IImportGenerator>> s_registry = new HashMap<Integer, Class<? extends IImportGenerator>>();

    public static synchronized void registerImportGen(IImportGenerator clazz) {
        s_registry.put(clazz.getType(), clazz.getClass());
    }

    public static synchronized void unregisterImportGen(IImportGenerator clazz) {
        s_registry.remove(clazz.getType());
    }

    public static synchronized IImportGenerator getGenerator(Integer type) {
        try {
            return s_registry.get(type).newInstance();
        }
        catch (InstantiationException e) {
            Logger.severe(ImportGenRegistry.class, (String)"Unable to instantiate the Generator");
        }
        catch (IllegalAccessException e) {
            Logger.severe(ImportGenRegistry.class, (String)"Unable to instantiate the Generator");
        }
        return null;
    }

    public static synchronized List<Integer> getTypes() {
        ArrayList<Integer> types = new ArrayList<Integer>();
        types.addAll(s_registry.keySet());
        return types;
    }

    public static boolean isTypeRegistered(Integer type) {
        return s_registry.get(type) != null;
    }

    static {
        ImportGenRegistry.registerImportGen(new ImportGenDbmsCloud());
    }
}

