/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.importer.writers;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import oracle.dbtools.data.loadservice.ExitCode;
import oracle.dbtools.data.model.Column;
import oracle.dbtools.data.model.GenericTable;
import oracle.dbtools.data.model.LoadField;
import oracle.dbtools.data.model.LoadFile;
import oracle.dbtools.datatools.BaseDataFormat;
import oracle.dbtools.db.ConnectionResolver;
import oracle.dbtools.export.ExportResources;
import oracle.dbtools.extract.models.ExtractObject;
import oracle.dbtools.importer.ImportResources;
import oracle.dbtools.importer.core.ImportDataFormat;
import oracle.dbtools.importer.core.ImportKeys;
import oracle.dbtools.importer.core.ImportProperties;
import oracle.dbtools.importer.writers.ImportGenHelper;
import oracle.dbtools.raptor.format.FormatRegistry;
import oracle.dbtools.raptor.format.ResultsFormatter;
import oracle.dbtools.raptor.utils.GuidGen;
import oracle.dbtools.util.Logger;

public class ImportGenFile
extends ResultsFormatter {
    private static String _term = "\n";
    public static final String TYPE = "LOADER";
    public static final String EXT = "ctl";
    public static final String EXT_DAT = "ldr";
    private ExtractObject _EO;
    private ImportProperties _iProps;
    private LoadFile _loadFile;
    private String _dataFileName;
    private boolean _isMetaTable;
    private ImportDataFormat _dataFormat;
    private long numRows = 0L;
    String EOL = FormatRegistry.getLineTerminator();
    private static final String COMMA = ",";
    private static final String COMMENT_SEP_LINE = "--------------------------------------------------------";
    private static final String COMMENT_LINE_START = "==  ";
    private static final String LEFT_PAREN = "(";
    private static final String RIGHT_PAREN = ")";
    private static final String SEMI_COLON = ";";
    private static final String SPACE = " ";

    public ImportGenFile() {
        super(TYPE, ExportResources.getString("LOADER_FILE"), EXT_DAT);
    }

    public void setTableName(String tName) {
    }

    public ExitCode start(ExtractObject EO) {
        Logger.info(((Object)((Object)this)).getClass(), (String)ImportResources.getString("GEN_START"));
        try {
            this._EO = EO;
            this._iProps = this._EO.getImportProperties();
            this._isMetaTable = this._iProps.getValueBoolean(ImportKeys.IS_EXISTING_TABLE);
            this._dataFormat = (ImportDataFormat)this._iProps.get(ImportKeys.IMPORT_DATA_FORMAT);
            this._loadFile = (LoadFile)this._iProps.get(ImportKeys.LOAD_FILE);
        }
        catch (Exception e) {
            Logger.warn(((Object)((Object)this)).getClass(), (Throwable)e);
            ExitCode exitCode = ExitCode.EXIT_SEVERE;
            exitCode.setMessage(e.getMessage());
            return exitCode;
        }
        return ExitCode.EXIT_SUCCESS;
    }

    public int print() {
        int ret = 0;
        try {
            this.end();
        }
        catch (Exception e) {
            Logger.warn(((Object)((Object)this)).getClass(), (Throwable)e);
        }
        finally {
            if (this._out != null) {
                try {
                    this._out.flush();
                }
                catch (IOException iOException) {}
            }
        }
        return ret;
    }

    public void start() throws IOException {
    }

    public void startRow() throws IOException {
    }

    public void printColumn(Object col, int viewIndex, int modelIndex) throws IOException {
    }

    public void endRow() throws IOException {
    }

    public void end() throws IOException {
        this._dataFileName = this.getNewFileName(EXT_DAT, "");
        String ctl = this.genControlFile(this._EO);
        String controlFileName = this.getNewFileName(EXT, "");
        long rowSize = 0L;
        if (this.numRows == 0L) {
            List loadFields = this._loadFile.getFields();
            for (LoadField loadField : loadFields) {
                rowSize += (long)loadField.getLength();
            }
        }
        if (rowSize > 0L) {
            this.numRows = new File(this._loadFile.getName()).length() / rowSize;
        }
        this.numRows = this.numRows > 500L ? (this.numRows /= 10L) : 50L;
        Integer skip = this._dataFormat.isHeader() ? this._dataFormat.getSkipRows() + 1 : this._dataFormat.getSkipRows();
        Integer load = this._iProps.getValueInteger(ImportKeys.LOAD_LIMIT);
        String options = "OPTIONS (ERRORS=" + Long.toString(this.numRows) + ", SKIP=" + Integer.toString(skip) + (String)(load > 0 ? ", LOAD=" + Integer.toString(load) : "") + RIGHT_PAREN + this.EOL;
        if (this._zipper == null) {
            if (!controlFileName.equals("")) {
                Writer ctlWriter = this.getNewWriter(controlFileName);
                this.addToControllingFile(controlFileName);
                ctlWriter.write(options);
                ctlWriter.write(ctl.toString());
                ctlWriter.close();
            }
        } else if (this._zipper != null) {
            this._zipper.closeEntry();
            this._zipper.openEntry(controlFileName);
            this.write(options);
            this.write(ctl.toString());
            this._zipper.closeEntry();
            this._zipper.writeFileEntry(this._loadFile.getName(), this._dataFileName, true);
        }
    }

    public void setExtractObject(ExtractObject eo) {
        this._EO = eo;
    }

    public static String getDDL(ExtractObject EO) {
        StringBuffer ddl = new StringBuffer();
        SimpleDateFormat bartDateFormat = new SimpleDateFormat("EEEE-MMMM-dd-yyyy");
        Date date = new Date();
        String hdrLines = COMMENT_SEP_LINE + ImportGenFile.getTerm() + ExportResources.getString("FILE_CREATED") + bartDateFormat.format(date) + "   " + ImportGenFile.getTerm() + COMMENT_SEP_LINE + ImportGenFile.getTerm();
        ddl.append(hdrLines);
        ddl.append(COMMENT_SEP_LINE + ImportGenFile.getTerm());
        ddl.append(ImportResources.getString("DDL_FOR_Table"));
        ddl.append(SPACE + EO.getTableName() + ImportGenFile.getTerm());
        ddl.append(COMMENT_SEP_LINE + ImportGenFile.getTerm());
        ImportProperties iProps = EO.getImportProperties();
        String[] colList = ImportGenHelper.formatTableColumns(iProps, iProps.getValueBoolean(ImportKeys.IS_EXISTING_TABLE));
        ddl.append("CREATE TABLE " + ImportGenHelper.addUser(iProps, EO.getTableName()) + ImportGenFile.getTerm() + LEFT_PAREN);
        boolean first = true;
        for (String col : colList) {
            if (!first) {
                ddl.append(COMMA);
            } else {
                first = false;
            }
            ddl.append(col + ImportGenFile.getTerm());
        }
        ddl.append(");" + ImportGenFile.getTerm());
        return ddl.toString();
    }

    public String genControlFile(ExtractObject EO) {
        Column[] selectedCols;
        ImportProperties iProps = EO.getImportProperties();
        ImportDataFormat dataFormat = (ImportDataFormat)iProps.get(ImportKeys.IMPORT_DATA_FORMAT);
        GenericTable genericTable = (GenericTable)iProps.get(ImportKeys.TABLE);
        for (Column selectedCol : selectedCols = (Column[])iProps.get(ImportKeys.SELECTED_COLUMNS)) {
            Column tblCol = genericTable.getTable().getColumnByName(selectedCol.getName());
            tblCol.setSourceColumnName(selectedCol.getSourceColumnName());
            tblCol.setSourceColID(selectedCol.getSourceColID());
        }
        iProps.put(ImportKeys.TABLE, genericTable);
        iProps.put(ImportKeys.IS_BATCH, true);
        iProps.put(ImportKeys.ERROR_LIMIT, 5);
        iProps.put(ImportKeys.REPLACE_GEN_FILES, true);
        iProps.put(ImportKeys.SEND_TO_WORKSHEET, true);
        iProps.put(ImportKeys.LOAD_METHOD, 4);
        StringBuffer ctl = new StringBuffer();
        String fileName = this._dataFileName;
        ctl.append("LOAD DATA CHARACTERSET ");
        String defCharSet = dataFormat == null ? "UTF8" : Charset.forName(dataFormat.getEncoding()).name();
        ctl.append("\"" + defCharSet + "\"");
        ctl.append(" LENGTH CHAR" + this.EOL);
        ctl.append("INFILE '" + fileName + "' \"str '" + ImportDataFormat.getRecordTerminatorString(dataFormat.getRecordTerminatorValue()) + "'\"" + this.EOL);
        ctl.append("APPEND" + this.EOL);
        String[] names = EO.getTableName().split("\\.");
        if (names.length == 1) {
            ctl.append("INTO TABLE " + names[0] + this.EOL);
        } else {
            ctl.append("INTO TABLE " + names[0] + ".");
            ctl.append(names[1] + this.EOL);
        }
        String fieldDelimiter = BaseDataFormat.singleQuote(BaseDataFormat.getDelimiterString(dataFormat.getDelimiter()));
        if (fieldDelimiter == null || fieldDelimiter.equals("")) {
            fieldDelimiter = "','";
        } else if (fieldDelimiter.equals("'WHITESPACE'")) {
            fieldDelimiter = "WHITESPACE";
        }
        ctl.append("FIELDS TERMINATED BY " + fieldDelimiter + this.EOL);
        if (dataFormat.getEnclosureLeftValue().length() != 0) {
            ctl.append("OPTIONALLY ENCLOSED BY '" + this.handleSpecialEnclosure(dataFormat.getEnclosureLeftValue()) + "' AND '" + this.handleSpecialEnclosure(dataFormat.getEnclosureRightValue()) + "'" + this.EOL);
        }
        ctl.append("TRAILING NULLCOLS ( " + this.EOL);
        ArrayList<String> al = new ArrayList<String>();
        ImportGenHelper.genControlFileFields(al, this._iProps, this._isMetaTable);
        for (int i = 0; i < al.size(); ++i) {
            String colSpec = al.get(i);
            ctl.append(colSpec);
            ctl.append(i != al.size() - 1 ? COMMA + this.EOL : this.EOL + RIGHT_PAREN);
        }
        return ctl.toString();
    }

    private String getConnectionName(String displayName) {
        String connectionName = null;
        for (String aConnectionName : ConnectionResolver.getConnectionNames()) {
            String aDisplayName = ConnectionResolver.getDisplayName((String)aConnectionName);
            if (!aDisplayName.equals(displayName)) continue;
            connectionName = aConnectionName;
            break;
        }
        return connectionName;
    }

    private static String getTerm() {
        return FormatRegistry.getLineTerminator();
    }

    private String getNewFileName(String ext) {
        return this.getNewFileName(ext, GuidGen.toString((byte[])GuidGen.uuidCreate()).replaceAll("\\" + this._delimiter, "_"));
    }

    private String getNewFileName(String ext, String opfile) {
        Object fileName = this.getFileName();
        if (fileName == null) {
            return "";
        }
        int extIndex = ((String)fileName).lastIndexOf(".");
        String baseFileName = extIndex != -1 ? ((String)fileName).substring(0, extIndex) : fileName;
        int spin = 0;
        fileName = baseFileName + opfile + "." + ext;
        if (!new File((String)fileName).exists()) {
            return fileName;
        }
        while (new File((String)fileName).exists()) {
            fileName = baseFileName + opfile + "_" + ++spin + "." + ext;
        }
        return fileName;
    }

    private Writer getNewWriter(String file) {
        FileOutputStream fos = null;
        OutputStreamWriter osw = null;
        BufferedWriter bw = null;
        try {
            fos = new FileOutputStream(file);
            try {
                osw = new OutputStreamWriter((OutputStream)fos, this.getEncode());
            }
            catch (UnsupportedEncodingException e1) {
                Logger.warn(((Object)((Object)this)).getClass(), (Throwable)e1);
                osw = new OutputStreamWriter(fos);
            }
            bw = new BufferedWriter(osw);
        }
        catch (FileNotFoundException e) {
            Logger.warn(((Object)((Object)this)).getClass(), (Throwable)e);
        }
        return bw;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeFile(String file, Reader reader) {
        Writer writer = this.getNewWriter(file);
        boolean isNull = true;
        if (writer != null) {
            try {
                char[] buffer = new char[4096];
                int length = 0;
                while ((length = reader.read(buffer)) != -1) {
                    writer.write(buffer, 0, length);
                    isNull = false;
                }
            }
            catch (FileNotFoundException e) {
                Logger.warn(((Object)((Object)this)).getClass(), (Throwable)e);
            }
            catch (IOException e) {
                Logger.warn(((Object)((Object)this)).getClass(), (Throwable)e);
            }
            finally {
                try {
                    writer.close();
                }
                catch (IOException e) {}
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return isNull;
    }
}

