/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.importer.readers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.importer.readers.CSVReader;
import oracle.dbtools.importer.readers.DelimitedReader;
import oracle.dbtools.importer.readers.IDataReadable;
import oracle.dbtools.importer.readers.TxtReader;
import oracle.dbtools.importer.readers.TxtReader2;
import oracle.dbtools.importer.readers.XLSReader;
import oracle.dbtools.importer.readers.XLSXReader;
import oracle.dbtools.util.Logger;

public class DataReaderRegistry {
    private static Map<String, Class<? extends IDataReadable>> s_registry = new HashMap<String, Class<? extends IDataReadable>>();
    private static Map<String, String> s_mapFormatToType = new HashMap<String, String>();

    public static synchronized void registerReader(IDataReadable clazz) {
        s_registry.put(clazz.getType().toLowerCase(), clazz.getClass());
        s_mapFormatToType.put(clazz.getFormat(), clazz.getType());
    }

    public static synchronized void unregisterReader(IDataReadable clazz) {
        s_registry.remove(clazz.getType().toLowerCase());
        s_mapFormatToType.remove(clazz.getFormat().toLowerCase());
    }

    public static synchronized IDataReadable getReader(String type) {
        try {
            return s_registry.get(type.toLowerCase()).newInstance();
        }
        catch (InstantiationException e) {
            Logger.severe(DataReaderRegistry.class, (String)"Unable to instantiate the Data Reader", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            Logger.severe(DataReaderRegistry.class, (String)"Unable to instantiate the Data Reader", (Throwable)e);
        }
        return null;
    }

    public static synchronized IDataReadable getReaderUsingFormat(String format) {
        String type = "";
        try {
            type = s_mapFormatToType.get(format.toLowerCase());
            if (type == null) {
                type = format;
            }
            return s_registry.get(type.toLowerCase()).newInstance();
        }
        catch (InstantiationException e) {
            Logger.severe(DataReaderRegistry.class, (String)"Unable to instantiate the Data Reader", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            Logger.severe(DataReaderRegistry.class, (String)"Unable to instantiate the Data Reader", (Throwable)e);
        }
        return null;
    }

    public static synchronized List<String> getTypes() {
        ArrayList<String> types = new ArrayList<String>();
        types.addAll(s_registry.keySet());
        return types;
    }

    public static boolean isTypeRegistered(String type) {
        return s_registry.get(type.toLowerCase()) != null;
    }

    static {
        DataReaderRegistry.registerReader(new DelimitedReader());
        DataReaderRegistry.registerReader(new CSVReader());
        DataReaderRegistry.registerReader(new TxtReader());
        DataReaderRegistry.registerReader(new TxtReader2());
        DataReaderRegistry.registerReader(new XLSReader());
        DataReaderRegistry.registerReader(new XLSXReader());
    }
}

