/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.formatter;

import java.io.IOException;
import oracle.dbtools.formatter.XLSFormatter;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class XLSXFormatter
extends XLSFormatter {
    public static final String TYPE = "XLSX";
    public static final String EXT = "xlsx";
    public static String XLSX_HEADER = "EXPORT_XLSX_HEADER";
    public static String XLSX_SAVE_QUERY = "EXPORT_XLSX_SAVE_QUERY";
    public static String XLSX_QUERY_WS_NAME = "EXPORT_XLSX_QUERY_WS_NAME";
    public static String XLSX_WS_NAME = "EXPORT_XLSX_WS_NAME";
    public static final String KEY_HEADER = XLSX_HEADER;
    public static final String KEY_DATA_NAME = XLSX_WS_NAME;
    public static final String KEY_QUERY = XLSX_SAVE_QUERY;
    public static final String KEY_QUERY_NAME = XLSX_QUERY_WS_NAME;

    public XLSXFormatter() {
        super(TYPE, TYPE, EXT);
    }

    public XLSXFormatter(String type, String filter, String ext) {
        super(type, filter, ext);
    }

    public String getExt() {
        return EXT;
    }

    public String getType() {
        return TYPE;
    }

    @Override
    protected Workbook newWorkbook() {
        return new SXSSFWorkbook(-1);
    }

    @Override
    public void startRow() throws IOException {
        if (this._rownum > (long)this.getRowLimit()) {
            ((SXSSFSheet)this.sheet).flushRows(0);
            this.sheet = this.workbook.createSheet();
            this._rownum = 0L;
        } else {
            this.checkAndFlush();
        }
        ++this._rownum;
        int s = Integer.parseInt("" + this._rownum);
        this._currRow = this.sheet.createRow(s);
    }

    protected void checkAndFlush() throws IOException {
        if (this._writeTracker < 20) {
            ++this._writeTracker;
        } else {
            ((SXSSFSheet)this.sheet).flushRows(20);
            this._writeTracker = 0;
        }
    }

    public void closeStream() {
        super.closeStream();
    }

    @Override
    protected int getRowLimit() {
        return 1048000;
    }
}

