/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.export.service;

import oracle.dbtools.common.config.IEnvironmentConfig;
import oracle.dbtools.data.loadservice.ExitCode;
import oracle.dbtools.export.service.ExportToolRunMode;
import oracle.dbtools.importer.core.ImportKeys;
import oracle.dbtools.importer.core.ImportProperties;
import oracle.dbtools.importer.writers.IImportGenerator;
import oracle.dbtools.importer.writers.ImportAPI;
import oracle.dbtools.importer.writers.ImportGenModel;
import oracle.dbtools.raptor.utils.IToolRunMode;

public class ImportGenLauncherCart {
    private ImportProperties _iProps;
    private ImportAPI _importAPI;
    private IImportGenerator _service;
    private ImportGenModel _iGenModel;
    private IToolRunMode _tRunMode;

    public ExitCode start(ImportProperties iProps, IToolRunMode runMode) {
        try {
            this._iProps = iProps;
            this._tRunMode = new ExportToolRunMode();
            this._tRunMode.setParms(runMode.getParms());
            this._tRunMode.setLineTerminator(runMode.getLineTerminator());
            this._tRunMode.isShowELog(this._iProps.getValueBoolean(ImportKeys.IS_CART) == false);
            this._tRunMode.setEncoding(runMode.getEncoding());
            this._importAPI = new ImportAPI(this._iProps, this._tRunMode);
            ExitCode exitCode = this._importAPI.start();
            this._iGenModel = this._importAPI.getModel();
            this._iGenModel.start();
            this._tRunMode.setRunMode(this._iGenModel.isBatch() ? IToolRunMode.RunMode.NO_GUI : IToolRunMode.RunMode.GUI);
            this._service = this._importAPI.getService();
            this._iGenModel.setService(this._service);
            return exitCode;
        }
        catch (Exception e) {
            ExitCode exitCode = ExitCode.EXIT_SEVERE;
            exitCode.setMessage(exitCode.getMessage() + " " + e.toString());
            return ExitCode.EXIT_SEVERE;
        }
    }

    public ImportGenModel getGenModel() {
        return this._iGenModel;
    }

    public IImportGenerator getService() {
        return this._service;
    }

    protected String getLineTerminator() {
        return IEnvironmentConfig.Storage.getInstance().getString("ENV_LINE_TERMINATOR");
    }
}

