/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.export.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.export.ExportResources;
import oracle.dbtools.export.service.ExportService;
import oracle.dbtools.export.service.ExportServiceType;
import oracle.dbtools.export.service.XSDeployCloudSchema;
import oracle.dbtools.export.service.XSDeployCloudWallet;
import oracle.dbtools.export.service.XSFull;
import oracle.dbtools.export.service.XSQuick;
import oracle.dbtools.util.Logger;

public class ExportServicesRegistry {
    private static Map<ExportServiceType, Class<? extends ExportService>> s_registry = new HashMap<ExportServiceType, Class<? extends ExportService>>();

    public static synchronized void registerService(ExportServiceType type, ExportService clazz) {
        s_registry.put(type, clazz.getClass());
    }

    public static synchronized void unregisterService(ExportServiceType type, ExportService clazz) {
        s_registry.remove((Object)type);
    }

    public static synchronized ExportService getService(ExportServiceType type) {
        try {
            return s_registry.get((Object)type).newInstance();
        }
        catch (InstantiationException e) {
            Logger.severe(ExportServicesRegistry.class, (String)ExportResources.getString("EXPORT_INSTANTIATE_ERR"));
        }
        catch (IllegalAccessException e) {
            Logger.severe(ExportServicesRegistry.class, (String)ExportResources.getString("EXPORT_INSTANTIATE_ERR"));
        }
        return null;
    }

    public static synchronized List<ExportServiceType> getTypes() {
        ArrayList<ExportServiceType> types = new ArrayList<ExportServiceType>();
        types.addAll(s_registry.keySet());
        return types;
    }

    public static boolean isServiceRegistered(ExportServiceType type) {
        return s_registry.get((Object)type) != null;
    }

    static {
        ExportServicesRegistry.registerService(ExportServiceType.QUICK, new XSQuick());
        ExportServicesRegistry.registerService(ExportServiceType.STANDARD, new XSFull());
        ExportServicesRegistry.registerService(ExportServiceType.DEPLOY_CLOUD_SCHEMA, new XSDeployCloudSchema());
        ExportServicesRegistry.registerService(ExportServiceType.DEPLOY_CLOUD_WALLET, new XSDeployCloudWallet());
    }
}

