/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.ddl.oracle;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import oracle.dbtools.common.config.ICommonConfig;
import oracle.dbtools.common.ddl.DDLFormat;
import oracle.dbtools.common.ddl.DDLFormatConfig;
import oracle.dbtools.common.ddl.DDLGenerator;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.util.Logger;

public class OracleMetaSetup {
    Connection _conn = null;
    private static final String META_SETUP = "begin   DBMS_METADATA.SET_TRANSFORM_PARAM(dbms_metadata.SESSION_TRANSFORM , 'SEGMENT_ATTRIBUTES', :SEGMENTS);   DBMS_METADATA.SET_TRANSFORM_PARAM(dbms_metadata.SESSION_TRANSFORM, 'PARTITIONING' , :PARTITIONING);   DBMS_METADATA.SET_TRANSFORM_PARAM(dbms_metadata.SESSION_TRANSFORM, 'TABLESPACE' , :TABLESPACE);   dbms_metadata.set_transform_param(dbms_metadata.SESSION_TRANSFORM,'SQLTERMINATOR' , :TERMINATOR);  dbms_metadata.set_transform_param(dbms_metadata.SESSION_TRANSFORM,'PRETTY' , :PRETTY);  DBMS_METADATA.SET_TRANSFORM_PARAM( dbms_metadata.SESSION_TRANSFORM , 'SIZE_BYTE_KEYWORD', :BYTE);  DBMS_METADATA.SET_TRANSFORM_PARAM( dbms_metadata.SESSION_TRANSFORM, 'FORCE' , :FORCE);  DBMS_METADATA.SET_TRANSFORM_PARAM( dbms_metadata.SESSION_TRANSFORM , 'CONSTRAINTS_AS_ALTER', :ALTER);  DBMS_METADATA.SET_TRANSFORM_PARAM( dbms_metadata.SESSION_TRANSFORM, 'EMIT_SCHEMA' , :SHOWSCHEMA);  DBMS_METADATA.SET_TRANSFORM_PARAM( dbms_metadata.SESSION_TRANSFORM, 'CONSTRAINTS' , :CONSTRAINT);   DBMS_METADATA.SET_TRANSFORM_PARAM( dbms_metadata.SESSION_TRANSFORM, 'REF_CONSTRAINTS' , :REF_CONSTRAINT); end;";
    private static final String META_SETUP_SCRIPT = " begin   DBMS_METADATA.SET_TRANSFORM_PARAM(dbms_metadata.SESSION_TRANSFORM , 'SEGMENT_ATTRIBUTES', :SEGMENTS);   DBMS_METADATA.SET_TRANSFORM_PARAM(dbms_metadata.SESSION_TRANSFORM, 'PARTITIONING' , :PARTITIONING);   DBMS_METADATA.SET_TRANSFORM_PARAM(dbms_metadata.SESSION_TRANSFORM, 'TABLESPACE' , :TABLESPACE);   dbms_metadata.set_transform_param(dbms_metadata.SESSION_TRANSFORM, 'SQLTERMINATOR' , :TERMINATOR);  dbms_metadata.set_transform_param(dbms_metadata.SESSION_TRANSFORM, 'PRETTY' , :PRETTY);  DBMS_METADATA.SET_TRANSFORM_PARAM( dbms_metadata.SESSION_TRANSFORM , 'SIZE_BYTE_KEYWORD',  :BYTE);  DBMS_METADATA.SET_TRANSFORM_PARAM( dbms_metadata.SESSION_TRANSFORM, 'FORCE' , :FORCE);  DBMS_METADATA.SET_TRANSFORM_PARAM( dbms_metadata.SESSION_TRANSFORM, 'EMIT_SCHEMA' , :SHOWSCHEMA);  DBMS_METADATA.SET_TRANSFORM_PARAM( dbms_metadata.SESSION_TRANSFORM, 'CONSTRAINTS' , :CONSTRAINT);   DBMS_METADATA.SET_TRANSFORM_PARAM( dbms_metadata.SESSION_TRANSFORM, 'REF_CONSTRAINTS' , :REF_CONSTRAINT);   DBMS_METADATA.SET_TRANSFORM_PARAM( dbms_metadata.SESSION_TRANSFORM , 'CONSTRAINTS_AS_ALTER', false);  end;";

    public OracleMetaSetup(Connection conn, String type) {
        this._conn = conn;
        this.setup(type);
    }

    public void setConnection(Connection conn) {
        this._conn = conn;
    }

    private void setup(String type) {
        SQLException ex;
        String stmt;
        HashMap<String, Boolean> binds = new HashMap<String, Boolean>();
        DDLFormat format = DDLGenerator.getInstance().getFormating();
        if (format == null) {
            format = new DDLFormat();
        }
        if (type.equals("SCRIPT")) {
            binds.put("CONSTRAINT", false);
            binds.put("REF_CONSTRAINT", false);
        } else if (type.equals("COPY")) {
            binds.put("CONSTRAINT", false);
            binds.put("REF_CONSTRAINT", false);
        } else if (type.startsWith("DDL ")) {
            binds.put("CONSTRAINT", true);
            binds.put("REF_CONSTRAINT", true);
            binds.put("ALTER", ICommonConfig.Storage.getInstance().getBoolean("DDL_ALTER"));
        }
        binds.put("SHOWSCHEMA", format.getSchema());
        binds.put("SEGMENTS", format.getSegments());
        binds.put("PARTITIONING", format.getPartitioning());
        binds.put("TABLESPACE", format.getTablespace());
        binds.put("TERMINATOR", format.getTerminator());
        binds.put("PRETTY", format.getPretty());
        binds.put("BYTE", format.getByte());
        binds.put("FORCE", format.getForce());
        DBUtil dbUtil = DBUtil.getInstance((Connection)this._conn);
        dbUtil.setRaiseError(false);
        String string = stmt = type.equals("COPY") || type.equals("SCRIPT") || type.equals("DEP") ? META_SETUP_SCRIPT : META_SETUP;
        if (!dbUtil.execute(stmt, binds) && (ex = dbUtil.getLastException()) != null) {
            Logger.severe(OracleMetaSetup.class, (String)"Error loading DDL", (Throwable)ex);
        }
    }

    static {
        DDLFormatConfig.DefaultInitializer.init();
    }
}

