/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows.updateconfiguration;

import java.io.File;
import java.sql.Connection;
import java.util.ArrayList;
import oracle.dbtools.extension.rcv.commands.RCVCommand;
import oracle.dbtools.extension.rcv.models.database.Database;
import oracle.dbtools.extension.rcv.models.database.FleetAgentContext;
import oracle.dbtools.extension.rcv.workflows.ProtectedDatabaseWorkflow;
import oracle.dbtools.extension.rcv.workflows.Step;
import oracle.dbtools.extension.rcv.workflows.updateconfiguration.UpdateConfigurationStep;
import oracle.dbtools.extension.rcv.workflows.updateconfiguration.UpdateWalletStep;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;

public class UpdateZRCVConfigurationWorkflow
extends ProtectedDatabaseWorkflow {
    private Database database;

    public UpdateZRCVConfigurationWorkflow(ParsedCommand command, Connection conn, ScriptRunnerContext ctx) {
        this(conn, ctx);
    }

    public UpdateZRCVConfigurationWorkflow(Connection conn, ScriptRunnerContext ctx) {
        super(RCVCommand.SubCommand.FETCH_CONFIG, conn, ctx);
    }

    @Override
    public void initState() {
        this.database = this.getDatabase();
        ArrayList<Step> steps = new ArrayList<Step>();
        steps.add(new UpdateConfigurationStep(this.database.getDbUniqueName(), this.database.getOcid(), this.getWorkflowLogger()));
        steps.add(new UpdateWalletStep(this.database.getDbUniqueName(), this.getWorkflowLogger()));
        super.setSteps(steps);
    }

    @Override
    public String getLockFileName() {
        return String.join((CharSequence)File.separator, FleetAgentContext.get(this.getDbUniqueName()).getLocksDirectory(), String.valueOf((Object)RCVCommand.SubCommand.FETCH_CONFIG) + ".lock");
    }

    @Override
    public int getLockTimeout() {
        return 10;
    }
}

