/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows.updateconfiguration;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import oracle.dbtools.extension.rcv.commands.RCVCommandBase;
import oracle.dbtools.extension.rcv.models.DatabaseUser;
import oracle.dbtools.extension.rcv.models.WalletEntry;
import oracle.dbtools.extension.rcv.models.database.FleetAgentContext;
import oracle.dbtools.extension.rcv.models.database.ProtectedDatabaseCache;
import oracle.dbtools.extension.rcv.utils.WalletManager;
import oracle.dbtools.extension.rcv.workflows.FileLocker;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.extension.rcv.workflows.Status;
import oracle.dbtools.extension.rcv.workflows.Step;
import oracle.dbtools.extension.rcv.workflows.WorkflowLogger;
import oracle.security.pki.OracleWallet;

public class UpdateWalletStep
implements Step {
    private WorkflowLogger logger;
    private String dbUniqueName;
    private FleetAgentContext fleetAgentContext;
    private char[] password;

    public UpdateWalletStep(String dbUniqueName, WorkflowLogger logger) {
        this.dbUniqueName = dbUniqueName;
        this.logger = logger;
        this.fleetAgentContext = FleetAgentContext.get(dbUniqueName);
    }

    public UpdateWalletStep password(char[] password) {
        this.password = password;
        return this;
    }

    @Override
    public Result run() {
        FileLocker fl = new FileLocker(String.join((CharSequence)File.separator, this.fleetAgentContext.getLocksDirectory(), "update_wallet.lock"), 10);
        Optional<Result> resultOptional = fl.execute(this::runStep);
        return resultOptional.orElseGet(() -> new Result(Status.FAILED, "Timed out waiting for lock."));
    }

    public Result runStep() {
        ProtectedDatabaseCache protectedDatabaseCache = this.fleetAgentContext.getProtectedDatabaseCache();
        String walletLocation = protectedDatabaseCache.getWalletLocation();
        List<String> aliases = protectedDatabaseCache.getRecoveryApplianceAliases();
        ArrayList<String> missingAliases = new ArrayList<String>();
        String vpcUserName = protectedDatabaseCache.getVpcUserName();
        if (vpcUserName == null) {
            return Result.ucwGetVpcUserError();
        }
        OracleWallet wallet = WalletManager.createWallet(walletLocation);
        HashMap<String, WalletEntry> walletEntries = WalletManager.getWalletEntries(wallet);
        for (String alias : aliases) {
            boolean foundEntry = false;
            for (String id : walletEntries.keySet()) {
                String walletAlias = walletEntries.get(id).getCredentialAlias();
                String username = walletEntries.get(id).getUserName();
                if (!walletAlias.equalsIgnoreCase(alias) || !username.equals(vpcUserName)) continue;
                foundEntry = true;
                break;
            }
            if (foundEntry) continue;
            missingAliases.add(alias);
        }
        if (!missingAliases.isEmpty()) {
            char[] password = this.getVpcPassword(vpcUserName);
            if (password != null) {
                DatabaseUser vpcUser = new DatabaseUser(vpcUserName, password);
                for (String alias : missingAliases) {
                    vpcUser.storePassword(wallet, alias);
                }
            } else {
                return Result.ucwGetVpcUserPwdError(vpcUserName, walletLocation);
            }
        }
        return new Result(Status.SUCCESS);
    }

    private char[] getVpcPassword(String vpcUserName) {
        String defaultWallet;
        char[] passwordCharArray = null;
        String walletLocation = this.fleetAgentContext.getProtectedDatabaseCache().getWalletLocation();
        OracleWallet wallet = WalletManager.createWallet(walletLocation);
        passwordCharArray = WalletManager.getSecretForUser(wallet, vpcUserName);
        if (passwordCharArray == null && !walletLocation.equals(defaultWallet = RCVCommandBase.getWalletDirectory(this.dbUniqueName))) {
            OracleWallet alternateWallet = WalletManager.createWallet(defaultWallet);
            passwordCharArray = WalletManager.getSecretForUser(alternateWallet, vpcUserName);
        }
        return passwordCharArray;
    }
}

