/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows.importprotecteddatabase;

import com.oracle.bmc.recovery.model.ProtectedDatabase;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import oracle.dbtools.extension.rcv.commands.RCVCommand;
import oracle.dbtools.extension.rcv.commands.RCVOptions;
import oracle.dbtools.extension.rcv.models.DatabaseUser;
import oracle.dbtools.extension.rcv.models.database.FleetAgentContext;
import oracle.dbtools.extension.rcv.models.database.ProtectedDatabaseCache;
import oracle.dbtools.extension.rcv.oci.RecoveryClientManager;
import oracle.dbtools.extension.rcv.utils.FleetEngine;
import oracle.dbtools.extension.rcv.utils.WalletManager;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.extension.rcv.workflows.Status;
import oracle.dbtools.extension.rcv.workflows.Step;
import oracle.dbtools.extension.rcv.workflows.Workflow;
import oracle.dbtools.extension.rcv.workflows.WorkflowLogger;
import oracle.dbtools.extension.rcv.workflows.addprotecteddatabase.OnboardDatabaseStep;
import oracle.dbtools.extension.rcv.workflows.configureeprotecteddatabase.UpdateProtectedDatabaseStep;
import oracle.dbtools.extension.rcv.workflows.importprotecteddatabase.VerifyDatabaseStep;
import oracle.dbtools.extension.rcv.workflows.updateconfiguration.UpdateConfigurationStep;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.security.pki.OracleWallet;

public class ImportProtectedDatabaseWorkflow
extends Workflow {
    private String id;
    private String endpoint;
    private char[] newVpcPassword;

    public ImportProtectedDatabaseWorkflow(ParsedCommand command, Connection conn, ScriptRunnerContext ctx) {
        super(RCVCommand.SubCommand.IMPORT_DATABASE, conn, ctx);
        this.id = (String)command.getOptionValue((Id)RCVOptions.Options.ID);
        this.endpoint = (String)command.getOptionValue((Id)RCVOptions.Options.ENDPOINT);
    }

    public ImportProtectedDatabaseWorkflow(String id, ScriptRunnerContext ctx) {
        super(RCVCommand.SubCommand.IMPORT_DATABASE, null, ctx);
        this.id = id;
    }

    public ImportProtectedDatabaseWorkflow endpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public ImportProtectedDatabaseWorkflow password(char[] newVpcPassword) {
        this.newVpcPassword = newVpcPassword;
        return this;
    }

    @Override
    public Result run(boolean verbose) {
        boolean updateVpcPassword;
        WorkflowLogger logger;
        block15: {
            logger = this.getWorkflowLogger();
            if (verbose) {
                logger.log(Level.INFO, "Log file: " + logger.getLogFile());
            }
            RecoveryClientManager recoveryClientManager = this.endpoint != null ? new RecoveryClientManager(this.endpoint, logger.getLogger()) : new RecoveryClientManager(this.getWorkflowLogger().getLogger());
            updateVpcPassword = false;
            ProtectedDatabase protectedDatabase = recoveryClientManager.getProtectedDatabase(this.id);
            ArrayList<Step> steps = new ArrayList<Step>();
            String dbUniqueName = protectedDatabase.getDbUniqueName();
            FleetAgentContext fleetAgentContext = FleetAgentContext.get(dbUniqueName);
            ProtectedDatabaseCache cache = fleetAgentContext.getProtectedDatabaseCache();
            String walletLocation = fleetAgentContext.getWalletLocation();
            Path walletPath = Paths.get(walletLocation, new String[0]);
            if (this.endpoint != null) {
                cache.setEndpoint(this.endpoint);
            }
            steps.add(new VerifyDatabaseStep(protectedDatabase, recoveryClientManager, logger));
            steps.add(new UpdateConfigurationStep(dbUniqueName, this.id, logger));
            for (Step step : steps) {
                Result result = step.run();
                if (!result.getStatus().equals((Object)Status.FAILED)) continue;
                return result;
            }
            String vpcUserName = protectedDatabase.getVpcUserName();
            if (Files.exists(walletPath, new LinkOption[0])) {
                OracleWallet wallet = WalletManager.createWallet(walletLocation);
                if (WalletManager.walletContainsUser(wallet, vpcUserName)) {
                    List<String> vpcAliases = WalletManager.getAliasesForUser(wallet, vpcUserName);
                    if (!vpcAliases.contains(cache.getCredentialAlias())) {
                        char[] password = WalletManager.getSecretForUser(wallet, vpcUserName);
                        DatabaseUser vpcUser = new DatabaseUser(protectedDatabase.getVpcUserName(), password);
                        vpcUser.storePassword(wallet, cache.getCredentialAlias());
                    }
                    try {
                        Connection conn = FleetEngine.getEngineConnection(fleetAgentContext.getTnsAdmin(), cache.getWalletLocation(), cache.getCredentialAlias());
                        if (conn != null) {
                            conn.close();
                        }
                        break block15;
                    }
                    catch (Exception e) {
                        if (e.getCause() != null && e.getCause().getMessage().contains("ORA-01017")) {
                            updateVpcPassword = true;
                        }
                        break block15;
                    }
                }
                updateVpcPassword = true;
            } else {
                try {
                    Files.createDirectories(walletPath, new FileAttribute[0]);
                }
                catch (IOException e) {
                    String error = String.format("Failed to create wallet %s: %s", walletLocation, e.getMessage());
                    return new Result(Status.FAILED, error);
                }
                updateVpcPassword = true;
            }
        }
        if (updateVpcPassword) {
            Step step;
            if (this.newVpcPassword == null) {
                this.newVpcPassword = OnboardDatabaseStep.generateRandomPassword();
            }
            step = new UpdateProtectedDatabaseStep(this.endpoint, this.id, logger);
            ((UpdateProtectedDatabaseStep)step).password(this.newVpcPassword);
            return ((UpdateProtectedDatabaseStep)step).run();
        }
        logger.log(Level.FINE, "Vpc credentials already exist in the wallet for this database. Not updating password.");
        return new Result(Status.SUCCESS);
    }
}

