/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows.fetchtask;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.LocalTime;
import java.util.List;
import java.util.logging.Level;
import oracle.dbtools.extension.rcv.commands.RCVCommand;
import oracle.dbtools.extension.rcv.commands.RCVOptions;
import oracle.dbtools.extension.rcv.commands.RcvMessages;
import oracle.dbtools.extension.rcv.models.commandengine.FleetEngineResponse;
import oracle.dbtools.extension.rcv.models.commandengine.GetActionRequest;
import oracle.dbtools.extension.rcv.models.commandengine.InitRequest;
import oracle.dbtools.extension.rcv.models.commandengine.NextActionRequest;
import oracle.dbtools.extension.rcv.models.commandengine.UpdateActionStatusRequest;
import oracle.dbtools.extension.rcv.models.database.Database;
import oracle.dbtools.extension.rcv.models.database.DatabaseInstanceInfo;
import oracle.dbtools.extension.rcv.models.task.TaskInfo;
import oracle.dbtools.extension.rcv.utils.FleetEngine;
import oracle.dbtools.extension.rcv.utils.TaskManager;
import oracle.dbtools.extension.rcv.utils.Utils;
import oracle.dbtools.extension.rcv.workflows.ProtectedDatabaseWorkflow;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.extension.rcv.workflows.Status;
import oracle.dbtools.extension.rcv.workflows.Workflow;
import oracle.dbtools.extension.rcv.workflows.WorkflowLogger;
import oracle.dbtools.extension.rcv.workflows.updateconfiguration.UpdateZRCVConfigurationWorkflow;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;

public class FetchTaskWorkflow
extends ProtectedDatabaseWorkflow {
    private boolean fetchLatestConfig;
    private Connection conn = this.getConnection();
    private int agentId;
    private int actionId;
    private int incorrectActionIdCount;
    private Connection fleetEngineConn;
    private int instanceId;
    private boolean scheduled;
    private Database database;

    public FetchTaskWorkflow(ParsedCommand command, Connection conn, ScriptRunnerContext ctx) {
        this(conn, ctx, true, command.isFlagSet((Id)RCVOptions.Options.SCHEDULED));
    }

    public FetchTaskWorkflow(Connection conn, ScriptRunnerContext ctx, boolean fetchLatestConfig, boolean scheduled) {
        super(RCVCommand.SubCommand.FETCH_TASK, conn, ctx);
        this.fetchLatestConfig = fetchLatestConfig;
        this.scheduled = scheduled;
        this.database = this.getDatabase();
        this.instanceId = this.database.getDatabaseMetadataCache().getInstanceId();
    }

    @Override
    public boolean isApplicable() {
        boolean applicable;
        if (!this.scheduled || !this.database.getDatabaseMetadataCache().runsOnMultipleNodes()) {
            return true;
        }
        LocalTime now = LocalTime.now();
        int hour = now.getHour();
        int minute = now.getMinute();
        List<DatabaseInstanceInfo> instances = DatabaseInstanceInfo.getAllInstanceInfo(this.conn);
        int N = instances.size();
        WorkflowLogger logger = this.getWorkflowLogger();
        logger.log(Level.FINE, "INSTANCE ID: " + this.instanceId);
        logger.log(Level.FINE, "HOUR: " + hour);
        logger.log(Level.FINE, "MIN: " + minute);
        logger.log(Level.FINE, "number of nodes: " + N);
        int i = hour * minute % N;
        int nodeId = instances.get(i).getId();
        boolean bl = applicable = nodeId == this.instanceId;
        if (!applicable) {
            logger.log(Level.FINE, String.format("A remote node with instance ID %d will fetch a task at this time. Please go to the remote node to check the task log.", nodeId));
        }
        return applicable;
    }

    @Override
    public Result run(boolean verbose) {
        Result result;
        block12: {
            WorkflowLogger logger = this.getWorkflowLogger();
            String dbUniqueName = this.getDbUniqueName();
            if (this.fetchLatestConfig) {
                UpdateZRCVConfigurationWorkflow wf = new UpdateZRCVConfigurationWorkflow(this.getConnection(), this.getContext());
                wf.setLogger(logger);
                try {
                    Result updateConfigResult = wf.run(false);
                    if (!updateConfigResult.getStatus().equals((Object)Status.SUCCESS)) {
                        logger.log(Level.FINE, updateConfigResult.getMessage());
                        logger.log(Level.WARNING, "Failed to update client with latest ZRCV config. Will attempt to fetch task with old config.");
                    }
                }
                catch (Exception e) {
                    logger.getLogger().log(Level.FINE, "Failed to update client with latest ZRCV config.", e);
                    logger.log(Level.WARNING, "Failed to update client with latest ZRCV config. Will attempt to fetch task with old config.");
                }
            }
            Connection fleetEngineConn = FleetEngine.getEngineConnection(this.getDatabase());
            try {
                int agentId = FetchTaskWorkflow.init(dbUniqueName, this.instanceId, fleetEngineConn, logger);
                logger.log(Level.FINE, "Agent ID: " + agentId);
                int actionId = FetchTaskWorkflow.nextAction(dbUniqueName, agentId, fleetEngineConn, logger);
                logger.log(Level.FINE, "Action ID: " + actionId);
                result = FetchTaskWorkflow.executeTask(this.getDatabase(), agentId, actionId, fleetEngineConn, logger);
                if (fleetEngineConn == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (fleetEngineConn != null) {
                        try {
                            fleetEngineConn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    logger.log(Level.FINE, e.getMessage());
                    return new Result(Status.FAILED, "Failed to either execute the RMAN task or close the catalog connection. Please see log for details.");
                }
            }
            fleetEngineConn.close();
        }
        return result;
    }

    public static int init(String dbUniqueName, int instanceId, Connection fleetEngineConn, WorkflowLogger logger) {
        try {
            int maxErrorCount = 2;
            InitRequest initRequest = new InitRequest.Builder(fleetEngineConn, dbUniqueName.toUpperCase(), instanceId, logger.getLogger()).build();
            FleetEngineResponse response = FleetEngine.retry(maxErrorCount, initRequest);
            FleetEngineResponse.Status status = response.getStatus();
            if (!status.equals((Object)FleetEngineResponse.Status.SUCCESS)) {
                throw Result.ftwEngineActionException(RcvMessages.format("FTW_INIT_RESPONSE_ERROR_EXCEPTION_MSG1", response.getMessage() != null ? response.getMessage() : ""));
            }
            if (response.getData() == null) {
                throw Result.ftwEngineActionException(RcvMessages.format("FTW_INIT_FAILED_GET_AGENT_ID_EXCEPTION_MSG2", response.getMessage()));
            }
            return (Integer)response.getData();
        }
        catch (SQLException e) {
            throw Result.fengDatabaseSqlException(RcvMessages.format("FENG_INIT_CONNECTION_ERROR_MSG", new Object[0]), e);
        }
    }

    public static int nextAction(String dbUniqueName, int agentId, Connection fleetEngineConn, WorkflowLogger logger) {
        try {
            int maxErrorCount = 2;
            NextActionRequest nextActionRequest = new NextActionRequest.Builder(fleetEngineConn, dbUniqueName, agentId, logger.getLogger()).build();
            FleetEngineResponse response = FleetEngine.retry(maxErrorCount, nextActionRequest);
            FleetEngineResponse.Status status = response.getStatus();
            if (!status.equals((Object)FleetEngineResponse.Status.SUCCESS)) {
                throw Result.ftwEngineActionException(RcvMessages.format("FTW_INIT_FAILED_GET_ACTION_ID_EXCEPTION_MSG3", response.getMessage() != null ? response.getMessage() : ""));
            }
            if (response.getData() == null) {
                throw Result.ftwEngineActionException(RcvMessages.format("FENG_NEXT_ACTION_ERROR_MSG", response.getMessage()));
            }
            return (Integer)response.getData();
        }
        catch (SQLException e) {
            throw Result.fengDatabaseSqlException(RcvMessages.format("FENG_NEXT_ACTION_ERROR_MSG", new Object[0]), e);
        }
    }

    public static Result executeTask(Database database, int agentId, int actionId, Connection fleetEngineConn, WorkflowLogger logger) {
        block10: {
            FleetEngineResponse<TaskInfo> response = null;
            String dbUniqueName = database.getDbUniqueName();
            try {
                Result taskResult;
                GetActionRequest getActionRequest = new GetActionRequest.Builder(fleetEngineConn, dbUniqueName, agentId, actionId, logger.getLogger()).build();
                response = getActionRequest.execute();
                FleetEngineResponse.Status status = response.getStatus();
                if (!status.equals((Object)FleetEngineResponse.Status.SUCCESS)) {
                    return Result.ftwEngineActionError(RcvMessages.format("FTW_FAILED_TO_FETCH_TASK_ERROR_MSG", response.getStatus() != null ? response.getStatus() : "", response.getMessage() != null ? response.getMessage() : ""));
                }
                TaskInfo taskInfo = response.getData();
                String taskLogDirectory = database.getFleetAgentContext().getTaskLogsDirectory();
                Path taskLogPath = Paths.get(taskLogDirectory, new String[0]);
                if (!Files.exists(taskLogPath, new LinkOption[0])) {
                    try {
                        Files.createDirectories(taskLogPath, new FileAttribute[0]);
                    }
                    catch (IOException e) {
                        Workflow.logException(e, logger.getLogger());
                        return Result.fileCreateDirectoryError(taskLogDirectory);
                    }
                }
                String taskLog = String.join((CharSequence)File.separator, taskLogDirectory, "task_" + taskInfo.getId() + ".log");
                logger.log(Level.INFO, "Fetching task from Recovery Service...");
                if (taskInfo.getType() != 1) {
                    logger.log(Level.INFO, String.format("See %s for detailed output", taskLog));
                }
                if ((taskResult = TaskManager.executeTask(taskInfo, database, taskLog, logger.getLogger())).getStatus().equals((Object)Status.SUCCESS)) {
                    UpdateActionStatusRequest updateActionStatusRequest = new UpdateActionStatusRequest.Builder(fleetEngineConn, database.getDbUniqueName(), agentId, actionId, logger.getLogger()).build();
                    FleetEngineResponse<Void> updateStatusResponse = updateActionStatusRequest.execute();
                    logger.log(Level.FINE, "Notified Command Engine on task result: " + String.valueOf((Object)updateStatusResponse.getStatus()));
                    break block10;
                }
                if (taskResult.getStatus().equals((Object)Status.SKIPPED)) {
                    logger.log(Level.INFO, "Command Engine did not return a backup task. No work required.");
                    break block10;
                }
                long errorStringIndex = Utils.findStringPosition(taskLog, "ERROR MESSAGE STACK FOLLOWS");
                String errorString = "";
                if (errorStringIndex != -1L) {
                    errorString = Utils.readBytesFromPosition(taskLog, errorStringIndex, 4000);
                    logger.log(Level.FINE, errorString);
                }
                UpdateActionStatusRequest updateActionStatusRequest = new UpdateActionStatusRequest.Builder(fleetEngineConn, dbUniqueName, agentId, actionId, logger.getLogger()).errorNum(UpdateActionStatusRequest.Status.AGENT_FAIL.getValue()).errorString(errorString).build();
                FleetEngineResponse<Void> updateStatusResponse = updateActionStatusRequest.execute();
                logger.log(Level.FINE, "Notified Command Engine on failed task: " + String.valueOf((Object)updateStatusResponse.getStatus()));
                return taskResult;
            }
            catch (Exception e) {
                Workflow.logException(e, logger.getLogger());
                return Result.ftwUnhandledError();
            }
        }
        return new Result(Status.SUCCESS);
    }

    @Override
    public void handleFailure() {
        if (this.fleetEngineConn != null) {
            WorkflowLogger logger = this.getWorkflowLogger();
            try {
                logger.log(Level.FINE, "closing Command Engine connection");
                this.fleetEngineConn.close();
                logger.log(Level.FINE, "closed Command Engine connection");
            }
            catch (SQLException e) {
                logger.log(Level.FINE, "Failed to close command engine connection: " + e.getMessage());
            }
        }
    }
}

