/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows.addprotecteddatabase;

import java.io.IOException;
import java.util.logging.Level;
import oracle.dbtools.extension.rcv.models.database.Database;
import oracle.dbtools.extension.rcv.models.systemcommands.SystemCommand;
import oracle.dbtools.extension.rcv.utils.BackupManager;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.extension.rcv.workflows.Status;
import oracle.dbtools.extension.rcv.workflows.Step;
import oracle.dbtools.extension.rcv.workflows.Workflow;
import oracle.dbtools.extension.rcv.workflows.WorkflowLogger;

public class RegisterDatabaseStep
implements Step {
    private Database database;
    private WorkflowLogger logger;

    public RegisterDatabaseStep(Database database, WorkflowLogger logger) {
        this.database = database;
        this.logger = logger;
    }

    @Override
    public Result run() {
        this.logger.log(Level.INFO, "Registering database with recovery catalog");
        if (this.database.getFleetAgentContext().getProtectedDatabaseCache().getVpcUserName() == null) {
            return Result.apdVpcUserMetadataError();
        }
        try {
            SystemCommand.ExecutionResult registerResult = BackupManager.registerDatabase(this.database, this.logger.getLogger());
            if (registerResult.getReturnCode() != 0) {
                if (registerResult.getOutput().contains("RMAN-20002")) {
                    return new Result(Status.SKIPPED);
                }
                return Result.apdRegisterDbError(this.logger.getLogFile());
            }
        }
        catch (IOException e) {
            Workflow.logException(e, this.logger.getLogger());
            return Result.apdRegisterDbError2();
        }
        return new Result(Status.SUCCESS);
    }
}

