/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows.addprotecteddatabase;

import java.io.IOException;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import oracle.dbtools.extension.rcv.commands.RCVCommandBase;
import oracle.dbtools.extension.rcv.models.database.Database;
import oracle.dbtools.extension.rcv.models.database.ProtectedDatabaseCache;
import oracle.dbtools.extension.rcv.utils.BackupManager;
import oracle.dbtools.extension.rcv.utils.DatabaseUtils;
import oracle.dbtools.extension.rcv.utils.Utils;
import oracle.dbtools.extension.rcv.workflows.ConfigureRMANWorkflow;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.extension.rcv.workflows.ShowRMANConfigWorkflow;
import oracle.dbtools.extension.rcv.workflows.Step;
import oracle.dbtools.extension.rcv.workflows.WorkflowLogger;

public class ConfigureRMANStep
implements Step {
    private Connection conn;
    private WorkflowLogger logger;

    public ConfigureRMANStep(Connection conn, WorkflowLogger logger) {
        this.conn = conn;
        this.logger = logger;
    }

    @Override
    public Result run() {
        this.logger.log(Level.INFO, "Configuring RMAN");
        Database database = RCVCommandBase.getDatabase(this.conn);
        Map<String, String> currentConfig = ShowRMANConfigWorkflow.getRMANConfig(database.getDbUniqueName());
        ProtectedDatabaseCache metadataCache = database.getFleetAgentContext().getProtectedDatabaseCache();
        HashMap<String, String> config = new HashMap<String, String>();
        String databaseVersion = DatabaseUtils.getDatabaseVersion(this.conn);
        config.put("wallet_location", metadataCache.getWalletLocation());
        config.put("credential_alias", metadataCache.getCredentialAlias());
        config.put("lib_ra_location", metadataCache.getLibraLocation());
        config.put("db_version", databaseVersion);
        config.put("node_count", String.valueOf(database.getDatabaseMetadataCache().getRemoteHostNames().size() + 1));
        config.put("client_max_channels", "16");
        config.put("compression_algorithm", "LOW");
        config.put("archive_log_backup_interval", String.valueOf(900));
        config.put("preferred_backup_db_unique_name", database.getDbUniqueName());
        config.put("backup_level_one_database", "FALSE");
        config.put("backup_level_zero_database", "FALSE");
        config.put("preferred_backup_start_time", Utils.getTimeStampWithTimeZone());
        config.put("encryption_algorithm", "AES256");
        try {
            String rmanVersion = BackupManager.getRMANVersion();
            if (rmanVersion != null && !rmanVersion.isEmpty()) {
                config.put("rman_version", rmanVersion);
            }
        }
        catch (IOException e) {
            this.logger.log(Level.FINE, "Failed to get RMAN version.");
        }
        ConfigureRMANWorkflow configureRMANWorkflow = new ConfigureRMANWorkflow.Builder(config).fetchLatestConfig(false).build(this.conn);
        configureRMANWorkflow.setLogger(this.logger);
        return configureRMANWorkflow.run(false);
    }
}

