/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows.addprotecteddatabase;

import java.io.IOException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import oracle.dbtools.extension.rcv.commands.RCVCommandBase;
import oracle.dbtools.extension.rcv.models.SCAN;
import oracle.dbtools.extension.rcv.models.SCANListener;
import oracle.dbtools.extension.rcv.models.database.Database;
import oracle.dbtools.extension.rcv.models.database.DatabaseConfig;
import oracle.dbtools.extension.rcv.models.database.FleetAgentContext;
import oracle.dbtools.extension.rcv.models.ora.Node;
import oracle.dbtools.extension.rcv.models.ora.OraConfig;
import oracle.dbtools.extension.rcv.utils.DatabaseUtils;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.extension.rcv.workflows.Status;
import oracle.dbtools.extension.rcv.workflows.Step;
import oracle.dbtools.extension.rcv.workflows.WorkflowLogger;

public class ConfigureDatabaseTNSStep
implements Step {
    private Connection conn;
    private Database database;
    private FleetAgentContext fleetAgentContext;
    private WorkflowLogger logger;
    private String serviceName;

    public ConfigureDatabaseTNSStep(Connection conn, WorkflowLogger logger) {
        this.conn = conn;
        this.database = RCVCommandBase.getDatabase(conn);
        this.fleetAgentContext = FleetAgentContext.get(this.database.getDbUniqueName());
        this.logger = logger;
    }

    public ConfigureDatabaseTNSStep serviceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    @Override
    public Result run() {
        this.logger.log(Level.INFO, "Configuring TNS entry for database");
        if (this.serviceName == null) {
            this.serviceName = DatabaseUtils.getParameter(this.conn, "SERVICE_NAMES");
        }
        if (this.serviceName != null && !this.serviceName.isEmpty()) {
            String dbnamesPath = this.fleetAgentContext.getDbNamesPath();
            String dbUniqueName = this.database.getDbUniqueName();
            String oracleHome = DatabaseConfig.getOracleHome(this.database.getDbUniqueName());
            Optional<SCAN> scanOptional = SCAN.getInstance(oracleHome);
            if (scanOptional.isPresent()) {
                SCAN scan = scanOptional.get();
                Optional<SCANListener> listenerOptional = SCANListener.getListenerWithNetworkNum(oracleHome, scan.getNetworkNum());
                int port = 1521;
                String protocol = "TCP";
                if (listenerOptional.isPresent()) {
                    SCANListener listener = listenerOptional.get();
                    port = listener.getPort();
                    protocol = listener.getProtocol();
                }
                ArrayList<Node<String>> tnsEntries = new ArrayList<Node<String>>();
                ArrayList addressChildren = new ArrayList();
                addressChildren.add(new Node<String>("PROTOCOL").addChild(new Node<String>(protocol)));
                addressChildren.add(new Node<String>("HOST").addChild(new Node<String>(scan.getName())));
                addressChildren.add(new Node<String>("PORT").addChild(new Node<String>(String.valueOf(port))));
                Node<String> addressNode = new Node<String>("ADDRESS").addChildren(addressChildren);
                List connectDataChildren = List.of(new Node<String>("SERVER").addChild(new Node<String>("DEDICATED")), new Node<String>("SERVICE_NAME").addChild(new Node<String>(this.serviceName)));
                Node<String> connectDataNode = new Node<String>("CONNECT_DATA").addChildren(connectDataChildren);
                Node<String> walletDirectoryNode = new Node<String>("MY_WALLET_DIRECTORY").addChild(new Node<String>(this.fleetAgentContext.getWalletLocation()));
                Node<String> securityNode = new Node<String>("SECURITY").addChild(walletDirectoryNode);
                Node<String> root = new Node<String>(dbUniqueName);
                Node<String> descriptionNode = new Node<String>("DESCRIPTION");
                descriptionNode.addChild(addressNode);
                descriptionNode.addChild(connectDataNode);
                descriptionNode.addChild(securityNode);
                root.addChild(descriptionNode);
                tnsEntries.add(root);
                OraConfig tnsnames = new OraConfig(tnsEntries);
                OraConfig currentTnsnames = OraConfig.load(dbnamesPath);
                if (currentTnsnames.equals(tnsnames)) {
                    return new Result(Status.SKIPPED, "No need to update " + dbnamesPath);
                }
                try {
                    tnsnames.write(dbnamesPath);
                }
                catch (IOException e) {
                    String error = String.format("Failed to write tns entry to file %s for database %s: %s", dbnamesPath, this.database.getDbUniqueName(), e.getMessage());
                    this.logger.getLogger().log(Level.FINE, error, e);
                    return new Result(Status.FAILED, error);
                }
                return new Result(Status.SUCCESS);
            }
        }
        String error = String.format("Failed to get service_name for database %s.", this.database.getDbUniqueName());
        return new Result(Status.FAILED, error);
    }
}

