/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows;

import com.oracle.bmc.recovery.model.LifecycleState;
import com.oracle.bmc.recovery.model.RecoveryServiceSubnet;
import com.oracle.bmc.recovery.model.RecoveryServiceSubnetSummary;
import com.oracle.bmc.recovery.requests.GetRecoveryServiceSubnetRequest;
import com.oracle.bmc.recovery.requests.ListRecoveryServiceSubnetsRequest;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import oracle.dbtools.extension.rcv.commands.RCVCommand;
import oracle.dbtools.extension.rcv.commands.RCVCommandBase;
import oracle.dbtools.extension.rcv.commands.RCVOptions;
import oracle.dbtools.extension.rcv.commands.RcvMessages;
import oracle.dbtools.extension.rcv.models.GlobalMetadata;
import oracle.dbtools.extension.rcv.models.database.Database;
import oracle.dbtools.extension.rcv.models.database.ProtectedDatabaseCache;
import oracle.dbtools.extension.rcv.oci.RecoveryClientManager;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.extension.rcv.workflows.Status;
import oracle.dbtools.extension.rcv.workflows.Step;
import oracle.dbtools.extension.rcv.workflows.Workflow;
import oracle.dbtools.extension.rcv.workflows.WorkflowLogger;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;

public class ShowRecoveryServiceSubnetWorkflow
extends Workflow {
    private String compartmentId;
    private String recoveryServiceSubnetId;
    private String recoveryServiceSubnetName;
    private RecoveryClientManager recoveryClientManager;
    private ParsedCommand command;

    public ShowRecoveryServiceSubnetWorkflow(ParsedCommand command, Connection conn, ScriptRunnerContext ctx) {
        super(RCVCommand.SubCommand.SHOW_RECOVERY_SERVICE_SUBNET, conn, ctx);
        this.command = command;
        ArrayList<Step> steps = new ArrayList<Step>();
        steps.add(new ShowRecoveryServiceSubnet());
        super.setSteps(steps);
    }

    @Override
    public void initState() {
        Connection conn = this.getConnection();
        this.compartmentId = (String)this.command.getOptionValue((Id)RCVOptions.Options.COMPARTMENT_ID);
        this.recoveryServiceSubnetName = (String)this.command.getOptionValue((Id)RCVOptions.Options.NAME);
        this.recoveryServiceSubnetId = (String)this.command.getOptionValue((Id)RCVOptions.Options.ID);
        String endpoint = (String)this.command.getOptionValue((Id)RCVOptions.Options.ENDPOINT);
        if (this.compartmentId == null) {
            if (conn == null) {
                this.compartmentId = GlobalMetadata.load().getAuthentication().getTenancyId();
                if (this.compartmentId == null) {
                    throw Result.missingOptionException(RcvMessages.format("WF_MISSING_COMPARTMENT_ID_OPTION", RCVOptions.Options.COMPARTMENT_ID.getName().toLowerCase()));
                }
            } else {
                Database database = RCVCommandBase.getDatabase(conn);
                ProtectedDatabaseCache protectedDatabaseCache = database.getFleetAgentContext().getProtectedDatabaseCache();
                if (protectedDatabaseCache.getCompartmentId() == null) {
                    this.compartmentId = GlobalMetadata.load().getAuthentication().getTenancyId();
                    if (this.compartmentId == null) {
                        throw Result.missingOptionException(RcvMessages.format("WF_MISSING_COMPARTMENT_ID_OPTION", RCVOptions.Options.COMPARTMENT_ID.getName().toLowerCase()));
                    }
                } else {
                    this.compartmentId = protectedDatabaseCache.getCompartmentId();
                }
            }
        }
        if (endpoint == null && conn != null) {
            endpoint = RCVCommandBase.getDatabase(conn).getFleetAgentContext().getProtectedDatabaseCache().getEndpoint();
        }
        this.recoveryClientManager = new RecoveryClientManager(endpoint, this.getWorkflowLogger().getLogger());
    }

    private static ListRecoveryServiceSubnetsRequest createListRecoveryServiceSubnetsRequest(String compartmentId, String recoveryServiceSubnetName) {
        ListRecoveryServiceSubnetsRequest.Builder requestBuilder = ListRecoveryServiceSubnetsRequest.builder().compartmentId(compartmentId).lifecycleState(LifecycleState.Active);
        if (recoveryServiceSubnetName != null) {
            requestBuilder.displayName(recoveryServiceSubnetName);
        }
        return requestBuilder.build();
    }

    private class ShowRecoveryServiceSubnet
    implements Step {
        private ShowRecoveryServiceSubnet() {
        }

        @Override
        public Result run() {
            WorkflowLogger logger = ShowRecoveryServiceSubnetWorkflow.this.getWorkflowLogger();
            if (ShowRecoveryServiceSubnetWorkflow.this.recoveryServiceSubnetName != null && ShowRecoveryServiceSubnetWorkflow.this.recoveryServiceSubnetId != null) {
                return Result.missingOption(RcvMessages.format("WF_MISSING_ONE_OF_THE_OPTIONS", RCVOptions.Options.NAME.toString().toLowerCase(), RCVOptions.Options.SUBNET_ID.toString().toLowerCase()));
            }
            if (ShowRecoveryServiceSubnetWorkflow.this.recoveryServiceSubnetId != null) {
                GetRecoveryServiceSubnetRequest request = GetRecoveryServiceSubnetRequest.builder().recoveryServiceSubnetId(ShowRecoveryServiceSubnetWorkflow.this.recoveryServiceSubnetId).build();
                RecoveryServiceSubnet subnet = ShowRecoveryServiceSubnetWorkflow.this.recoveryClientManager.getRecoveryServiceSubnet(request);
                if (subnet != null) {
                    logger.log(Level.INFO, "Display Name:            " + subnet.getDisplayName());
                    logger.log(Level.INFO, "OCID:                    " + subnet.getId());
                    logger.log(Level.INFO, "Compartment ID:          " + subnet.getCompartmentId());
                    logger.log(Level.INFO, "Lifecycle State:         " + String.valueOf(subnet.getLifecycleState()));
                    logger.log(Level.INFO, "VCN ID:                  " + subnet.getVcnId());
                    logger.log(Level.INFO, "Subnets:                 " + subnet.getSubnets().toString());
                } else {
                    logger.log(Level.INFO, "No recovery service subnet found.");
                }
                return new Result(Status.SUCCESS);
            }
            List summaryList = ShowRecoveryServiceSubnetWorkflow.this.recoveryClientManager.getAllResourcesBySearchingAllCompartments(ShowRecoveryServiceSubnetWorkflow.this.compartmentId, compId -> ShowRecoveryServiceSubnetWorkflow.this.recoveryClientManager.getRecoveryServiceSubnets(ShowRecoveryServiceSubnetWorkflow.createListRecoveryServiceSubnetsRequest(compId, ShowRecoveryServiceSubnetWorkflow.this.recoveryServiceSubnetName)));
            if (summaryList.size() > 0) {
                for (RecoveryServiceSubnetSummary summary : summaryList) {
                    logger.log(Level.INFO, "Display Name:            " + summary.getDisplayName());
                    logger.log(Level.INFO, "OCID:                    " + summary.getId());
                    logger.log(Level.INFO, "Compartment ID:          " + summary.getCompartmentId());
                    logger.log(Level.INFO, "Lifecycle State:         " + String.valueOf(summary.getLifecycleState()));
                    logger.log(Level.INFO, "VCN ID:                  " + summary.getVcnId());
                    logger.log(Level.INFO, "Subnets:                 " + summary.getSubnets().toString());
                    logger.log(Level.INFO, "\n");
                }
            } else {
                logger.log(Level.INFO, "No recovery service subnets found for compartment " + ShowRecoveryServiceSubnetWorkflow.this.compartmentId);
            }
            return new Result(Status.SUCCESS);
        }
    }
}

