/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows;

import java.sql.Connection;
import java.util.logging.Level;
import oracle.dbtools.extension.rcv.commands.RCVCommand;
import oracle.dbtools.extension.rcv.models.GlobalMetadata;
import oracle.dbtools.extension.rcv.models.OCIAuthentication;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.extension.rcv.workflows.Status;
import oracle.dbtools.extension.rcv.workflows.Workflow;
import oracle.dbtools.extension.rcv.workflows.WorkflowLogger;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;

public class ShowAuthenticationWorkflow
extends Workflow {
    private WorkflowLogger logger = this.getWorkflowLogger();

    public ShowAuthenticationWorkflow(ParsedCommand command, Connection conn, ScriptRunnerContext ctx) {
        super(RCVCommand.SubCommand.SHOW_AUTHENTICATION, conn, ctx);
    }

    @Override
    public Result run(boolean verbose) {
        GlobalMetadata globalMetadata = GlobalMetadata.load();
        OCIAuthentication authentication = globalMetadata.getAuthentication();
        if (authentication != null) {
            this.logger.log(Level.INFO, "OCI API Authentication Method: " + String.valueOf((Object)authentication.getMethod()));
        }
        if (authentication.getMethod().equals((Object)OCIAuthentication.Method.API_KEY)) {
            this.logger.log(Level.INFO, "\t OCI Config File: " + authentication.getConfigFile());
            this.logger.log(Level.INFO, "\t Profile Name: " + authentication.getProfileName());
        }
        return new Result(Status.SUCCESS);
    }
}

