/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import oracle.dbtools.extension.rcv.check.Check;
import oracle.dbtools.extension.rcv.check.CheckResult;
import oracle.dbtools.extension.rcv.check.Group;
import oracle.dbtools.extension.rcv.check.health.BackupHealthCheck;
import oracle.dbtools.extension.rcv.check.health.RCVConnectivityCheck;
import oracle.dbtools.extension.rcv.check.health.SchedulerStatusCheck;
import oracle.dbtools.extension.rcv.check.onboarding.ArchiveLogModeCheck;
import oracle.dbtools.extension.rcv.check.onboarding.DatabaseStatusCheck;
import oracle.dbtools.extension.rcv.check.onboarding.DatabaseVersionCheck;
import oracle.dbtools.extension.rcv.check.onboarding.EncryptionWalletCheck;
import oracle.dbtools.extension.rcv.check.onboarding.RMANEncryptionSettingCheck;
import oracle.dbtools.extension.rcv.check.rtrt.RedoTransportUserCheck;
import oracle.dbtools.extension.rcv.check.rtrt.ServerSepsWalletCheck;
import oracle.dbtools.extension.rcv.check.rtrt.WalletRootCheck;
import oracle.dbtools.extension.rcv.commands.RCVCommand;
import oracle.dbtools.extension.rcv.commands.RCVOptions;
import oracle.dbtools.extension.rcv.commands.RcvMessages;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.extension.rcv.workflows.Status;
import oracle.dbtools.extension.rcv.workflows.Step;
import oracle.dbtools.extension.rcv.workflows.Workflow;
import oracle.dbtools.extension.rcv.workflows.WorkflowLogger;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;

public class RunChecksWorkflow
extends Workflow {
    public static boolean REQUIRES_CONNECTION = true;
    private static final String MIN_DB_VERSION = "19.18";
    private Connection conn;
    private ScriptRunnerContext ctx;
    private String checkId;
    private Group checkGroup;

    public RunChecksWorkflow(ParsedCommand command, Connection conn, ScriptRunnerContext ctx) {
        super(RCVCommand.SubCommand.RUN_CHECKS, conn, ctx);
        this.checkOptions();
        this.checkId = (String)command.getOptionValue((Id)RCVOptions.Options.NAME);
        if (command.getOptionValue((Id)RCVOptions.Options.GROUP) != null) {
            String group = (String)command.getOptionValue((Id)RCVOptions.Options.GROUP);
            this.checkGroup = Group.valueOf(group.toUpperCase());
        }
        this.conn = conn;
        this.ctx = ctx;
        this.setSteps();
    }

    public RunChecksWorkflow(String checkId, Connection conn, ScriptRunnerContext ctx) {
        super(RCVCommand.SubCommand.RUN_CHECKS, conn, ctx);
        this.checkId = checkId;
        this.conn = conn;
        this.ctx = ctx;
        this.setSteps();
    }

    public RunChecksWorkflow(Group checkGroup, Connection conn, ScriptRunnerContext ctx) {
        super(RCVCommand.SubCommand.RUN_CHECKS, conn, ctx);
        this.conn = conn;
        this.ctx = ctx;
        this.checkGroup = checkGroup;
        this.setSteps();
    }

    private void setSteps() {
        ArrayList<Step> steps = new ArrayList<Step>();
        steps.add(new RunChecks());
        super.setSteps(steps);
    }

    private void checkOptions() {
        if (this.checkId != null && this.checkGroup != null) {
            throw Result.invalidOptionException(RcvMessages.format("WF_INVALID_MUTUALLY_EXCLUSIVE2", RCVOptions.Options.NAME.getName().toLowerCase(), RCVOptions.Options.GROUP.getName().toLowerCase()));
        }
    }

    public Check getCheck(String checkId) {
        switch (checkId) {
            case "backup_health": {
                return new BackupHealthCheck(this.conn);
            }
            case "db_version": {
                return new DatabaseVersionCheck(this.conn, MIN_DB_VERSION);
            }
            case "encryption_wallet": {
                return new EncryptionWalletCheck(this.conn, this.ctx);
            }
            case "catalog_connectivity": {
                return new RCVConnectivityCheck(this.conn);
            }
            case "rman_encryption_check": {
                return new RMANEncryptionSettingCheck(this.conn);
            }
            case "scheduler_status": {
                return new SchedulerStatusCheck(this.conn);
            }
            case "server_seps_wallet": {
                return new ServerSepsWalletCheck(this.conn);
            }
        }
        return null;
    }

    public List<Check> getChecks(Group checkGroup) {
        ArrayList<Check> checks = new ArrayList<Check>();
        switch (checkGroup) {
            case ALL: 
            case HEALTH: {
                checks.add(new RCVConnectivityCheck(this.conn));
                checks.add(new BackupHealthCheck(this.conn));
                checks.add(new EncryptionWalletCheck(this.conn, this.ctx));
                checks.add(new RMANEncryptionSettingCheck(this.conn));
                checks.add(new SchedulerStatusCheck(this.conn));
                break;
            }
            case ONBOARDING_PRECHECKS: {
                checks.add(new DatabaseVersionCheck(this.conn, MIN_DB_VERSION));
                checks.add(new EncryptionWalletCheck(this.conn, this.ctx));
                checks.add(new ArchiveLogModeCheck(this.conn));
                checks.add(new DatabaseStatusCheck(this.conn));
                checks.add(new RMANEncryptionSettingCheck(this.conn));
                break;
            }
            case REALTIME_REDO_PRECHECKS: {
                checks.add(new RedoTransportUserCheck(this.conn));
                checks.add(new WalletRootCheck(this.conn));
                checks.add(new ServerSepsWalletCheck(this.conn));
                break;
            }
            default: {
                return checks;
            }
        }
        return checks;
    }

    public List<Check> getChecks() {
        List<Object> checks = new ArrayList();
        if (this.checkId != null) {
            Check check = this.getCheck(this.checkId);
            if (check != null) {
                checks.add(check);
            }
        } else {
            checks = this.checkGroup != null ? this.getChecks(this.checkGroup) : this.getChecks(Group.ALL);
        }
        return checks;
    }

    public CheckResult runCheck(Check check) {
        WorkflowLogger logger = this.getWorkflowLogger();
        logger.log(Level.INFO, check.getName());
        check.setLogger(logger);
        CheckResult checkResult = check.run();
        logger.log(Level.INFO, String.format("\tStatus:      " + String.valueOf((Object)checkResult.getStatus()), new Object[0]));
        if (!checkResult.getStatus().equals((Object)CheckResult.Status.PASS)) {
            if (checkResult.getMessage() != null) {
                logger.log(Level.INFO, "\tDetails:     " + checkResult.getMessage());
            }
            if (checkResult.getActionPlan() != null) {
                logger.log(Level.INFO, "\tAction Plan: " + checkResult.getActionPlan());
            }
        }
        return checkResult;
    }

    public boolean runChecks(List<Check> checks) {
        WorkflowLogger logger = this.getWorkflowLogger();
        boolean ok = true;
        for (Check check : checks) {
            if (this.runCheck(check).getStatus().equals((Object)CheckResult.Status.FAIL)) {
                ok = false;
            }
            logger.log(Level.INFO, "--------------------------------------------------");
        }
        return ok;
    }

    private class RunChecks
    implements Step {
        private RunChecks() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Result run() {
            WorkflowLogger logger = RunChecksWorkflow.this.getWorkflowLogger();
            boolean ok = false;
            if (RunChecksWorkflow.this.checkId != null) {
                Check check = RunChecksWorkflow.this.getCheck(RunChecksWorkflow.this.checkId);
                if (check == null) return Result.chwInvalidCheckNameError(RunChecksWorkflow.this.checkId);
                CheckResult checkResult = RunChecksWorkflow.this.runCheck(check);
                ok = !checkResult.getStatus().equals((Object)CheckResult.Status.FAIL);
            } else {
                List<Check> checks = RunChecksWorkflow.this.getChecks();
                if (checks.isEmpty()) {
                    return Result.chwInvalidGroupNameError(RunChecksWorkflow.this.checkId);
                }
                ok = RunChecksWorkflow.this.runChecks(checks);
            }
            if (ok) {
                logger.log(Level.INFO, "All checks passed.");
                return new Result(Status.SUCCESS);
            } else {
                logger.log(Level.INFO, "Some checks failed!");
            }
            return new Result(Status.SUCCESS);
        }
    }
}

