/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows;

import com.oracle.bmc.recovery.model.ProtectedDatabase;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import oracle.dbtools.extension.rcv.check.Check;
import oracle.dbtools.extension.rcv.check.Group;
import oracle.dbtools.extension.rcv.commands.RCVCommand;
import oracle.dbtools.extension.rcv.commands.RCVOptions;
import oracle.dbtools.extension.rcv.commands.RcvMessages;
import oracle.dbtools.extension.rcv.models.LogArchiveConfig;
import oracle.dbtools.extension.rcv.models.LogArchiveDestination;
import oracle.dbtools.extension.rcv.models.database.Database;
import oracle.dbtools.extension.rcv.models.database.DatabaseMetadataCache;
import oracle.dbtools.extension.rcv.models.database.FleetAgentContext;
import oracle.dbtools.extension.rcv.models.database.ProtectedDatabaseCache;
import oracle.dbtools.extension.rcv.models.ora.OraConfig;
import oracle.dbtools.extension.rcv.models.systemcommands.SystemCommand;
import oracle.dbtools.extension.rcv.oci.RecoveryClientManager;
import oracle.dbtools.extension.rcv.utils.ConfigurationManager;
import oracle.dbtools.extension.rcv.utils.DatabaseUtils;
import oracle.dbtools.extension.rcv.utils.FleetEngine;
import oracle.dbtools.extension.rcv.utils.NamedConnectionsManager;
import oracle.dbtools.extension.rcv.utils.SshHelper;
import oracle.dbtools.extension.rcv.utils.TnsnamesHelper;
import oracle.dbtools.extension.rcv.utils.WalletManager;
import oracle.dbtools.extension.rcv.workflows.ConfigureRMANWorkflow;
import oracle.dbtools.extension.rcv.workflows.ProtectedDatabaseWorkflow;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.extension.rcv.workflows.RunChecksWorkflow;
import oracle.dbtools.extension.rcv.workflows.Status;
import oracle.dbtools.extension.rcv.workflows.Step;
import oracle.dbtools.extension.rcv.workflows.WorkflowLogger;
import oracle.dbtools.extension.rcv.workflows.configureeprotecteddatabase.UpdateProtectedDatabaseStep;
import oracle.dbtools.extension.rcv.workflows.updateconfiguration.UpdateConfigurationStep;
import oracle.dbtools.extension.rcv.workflows.updateconfiguration.UpdateZRCVConfigurationWorkflow;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.security.pki.OracleWallet;

public class EnableRealtimeRedoWorkflow
extends ProtectedDatabaseWorkflow {
    private Connection conn;
    private ScriptRunnerContext ctx;
    private WorkflowLogger logger;
    private LogArchiveConfig currentLogArchiveConfig;
    private LogArchiveConfig targetLogArchiveConfig;
    private HashMap<Integer, LogArchiveDestination> currentDestinations;
    private List<LogArchiveDestination> targetDestinations;
    private ProtectedDatabase protectedDatabase;
    private boolean restartDatabase = false;
    private RecoveryClientManager recoveryClientManager;
    private String walletRoot;
    private boolean localOnly;
    private List<SshHelper> sshConnections = new ArrayList<SshHelper>();
    private Database database;
    private ProtectedDatabaseCache protectedDatabaseCache;

    public EnableRealtimeRedoWorkflow(ParsedCommand command, Connection conn, ScriptRunnerContext ctx) {
        this(command.isFlagSet((Id)RCVOptions.Options.LOCAL), conn, ctx);
    }

    public EnableRealtimeRedoWorkflow(boolean local, Connection conn, ScriptRunnerContext ctx) {
        super(RCVCommand.SubCommand.ADD_REALTIME_REDO, conn, ctx);
        this.localOnly = local;
        this.conn = conn;
        this.ctx = ctx;
        this.logger = this.getWorkflowLogger();
        ArrayList<Step> steps = new ArrayList<Step>();
        if (!this.localOnly) {
            steps.add(new RunChecks());
        }
        steps.add(new ConfigureWallet());
        steps.add(new ConfigureSqlnet());
        steps.add(new ConfigureTnsNames());
        steps.add(new VerifyConnection());
        steps.add(new ConfigureLogArchiveDestinations());
        steps.add(new ConfigureRedoTransportUser());
        if (!this.localOnly) {
            steps.add(new EnableRealtimeRedoOnRemoteNodes());
            steps.add(new UpdateRMANConfiguration());
            steps.add(new NotifyControlPlane());
            steps.add(new RestartDatabase());
        }
        super.setSteps(steps);
    }

    @Override
    public String getLockFileName() {
        return String.join((CharSequence)File.separator, FleetAgentContext.get(this.getDbUniqueName()).getLocksDirectory(), String.valueOf((Object)RCVCommand.SubCommand.ADD_REALTIME_REDO) + ".lock");
    }

    @Override
    public void initState() {
        this.database = this.getDatabase();
        this.protectedDatabaseCache = this.database.getFleetAgentContext().getProtectedDatabaseCache();
        String dbUniqueName = this.getDbUniqueName();
        String rcvConf = ConfigurationManager.getRcvConf(dbUniqueName);
        this.recoveryClientManager = new RecoveryClientManager(this.protectedDatabaseCache.getEndpoint(), this.logger.getLogger());
        String dgConfigString = DatabaseUtils.getLogArchiveConfig(this.conn);
        this.currentLogArchiveConfig = new LogArchiveConfig();
        if (dgConfigString != null) {
            this.currentLogArchiveConfig = new LogArchiveConfig(dgConfigString);
        }
        UpdateZRCVConfigurationWorkflow wf = new UpdateZRCVConfigurationWorkflow(this.conn, this.ctx);
        wf.setLogger(this.logger);
        Result updateConfigResult = wf.runWithLock(false);
        if (updateConfigResult.getStatus().equals((Object)Status.FAILED)) {
            String error = updateConfigResult.getMessage() != null ? updateConfigResult.getMessage() : "";
            throw Result.wfResultToException(error);
        }
        this.targetDestinations = new ArrayList<LogArchiveDestination>();
        this.targetLogArchiveConfig = new LogArchiveConfig(ConfigurationManager.getLogArchiveConfig(rcvConf));
        ArrayList<String> dgConfig = new ArrayList<String>();
        for (String name : this.targetLogArchiveConfig.getDgConfig()) {
            dgConfig.add(ConfigurationManager.prependAliasWithDbUniqueName(dbUniqueName, name));
        }
        this.targetLogArchiveConfig.setDgConfig(dgConfig);
        try {
            this.targetDestinations = ConfigurationManager.getLogArchiveDestinationGroups(rcvConf);
            for (LogArchiveDestination destination : this.targetDestinations) {
                String serviceName = ConfigurationManager.prependAliasWithDbUniqueName(dbUniqueName, destination.getService());
                destination.setService(serviceName);
                destination.setDbUniqueName(serviceName);
            }
        }
        catch (IOException e) {
            throw Result.errInitLogDestException(rcvConf, e);
        }
        try {
            this.currentDestinations = this.getLogArchiveDestinationsByDestinationName(this.targetLogArchiveConfig.getDgConfig());
        }
        catch (SQLException e) {
            throw Result.errInitLogDestDbException(e);
        }
        this.protectedDatabase = this.recoveryClientManager.getProtectedDatabase(this.database.getOcid());
        DatabaseMetadataCache dbMetadataCache = this.database.getDatabaseMetadataCache();
        this.walletRoot = dbMetadataCache.getWalletRoot();
        this.sshConnections = dbMetadataCache.getSshConnections(this.logger.getLogger());
    }

    private HashMap<Integer, LogArchiveDestination> getLogArchiveDestinationsByDestinationName(List<String> destinationNames) throws SQLException {
        ResultSet rs = DatabaseUtils.getLogArchiveDestinations(this.conn, destinationNames);
        ArrayList<String> logArchiveDestinationParameters = new ArrayList<String>();
        HashMap<Integer, LogArchiveDestination> destinations = new HashMap<Integer, LogArchiveDestination>();
        if (rs != null) {
            while (rs.next()) {
                int destId = rs.getInt("DEST_ID");
                logArchiveDestinationParameters.add("log_archive_dest_" + destId);
            }
            HashMap<String, String> logArchiveDestinationMap = DatabaseUtils.getParameters(this.conn, logArchiveDestinationParameters);
            for (String parameterName : logArchiveDestinationMap.keySet()) {
                String destinationValue = logArchiveDestinationMap.get(parameterName);
                int i = (parameterName = parameterName.trim()).lastIndexOf("_");
                if (i == -1) continue;
                int id = Integer.parseInt(parameterName.substring(i + 1));
                destinations.put(id, LogArchiveDestination.createInstance(destinationValue));
            }
        }
        return destinations;
    }

    private List<String> getMissingDgConfig() {
        ArrayList<String> missing = new ArrayList<String>();
        for (String targetDest : this.targetLogArchiveConfig.getDgConfig()) {
            boolean found = false;
            for (String currentDest : this.currentLogArchiveConfig.getDgConfig()) {
                if (!currentDest.equalsIgnoreCase(targetDest)) continue;
                found = true;
                break;
            }
            if (found) continue;
            missing.add(targetDest);
        }
        return missing;
    }

    private boolean isZRCVInLogArchiveConfig() {
        for (String targetDest : this.targetLogArchiveConfig.getDgConfig()) {
            boolean found = false;
            for (String currentDest : this.currentLogArchiveConfig.getDgConfig()) {
                if (!currentDest.equalsIgnoreCase(targetDest)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private class RunChecks
    implements Step {
        private RunChecks() {
        }

        @Override
        public Result run() {
            EnableRealtimeRedoWorkflow.this.logger.log(Level.INFO, "Running prechecks");
            if (DatabaseUtils.isMultitenant(EnableRealtimeRedoWorkflow.this.conn) && DatabaseUtils.isPDB(EnableRealtimeRedoWorkflow.this.conn)) {
                return Result.pdCheckPdbError();
            }
            RunChecksWorkflow runChecksWorkflow = new RunChecksWorkflow(Group.REALTIME_REDO_PRECHECKS, EnableRealtimeRedoWorkflow.this.conn, EnableRealtimeRedoWorkflow.this.ctx);
            runChecksWorkflow.setLogger(EnableRealtimeRedoWorkflow.this.logger);
            List<Check> checks = runChecksWorkflow.getChecks();
            boolean ok = runChecksWorkflow.runChecks(checks);
            if (ok) {
                return new Result(Status.SUCCESS);
            }
            return Result.chwChecksError();
        }
    }

    private class ConfigureWallet
    implements Step {
        private ConfigureWallet() {
        }

        @Override
        public Result run() {
            EnableRealtimeRedoWorkflow.this.logger.log(Level.INFO, "Configuring wallet");
            String serverSeps = EnableRealtimeRedoWorkflow.this.database.getDatabaseMetadataCache().getServerSeps();
            String currentWallet = EnableRealtimeRedoWorkflow.this.protectedDatabaseCache.getWalletLocation();
            if (serverSeps == null) {
                return new Result(Status.FAILED, "wallet_root is not set. Please set it before proceeding with realtime-redo setup.");
            }
            Path serverSepsPath = Paths.get(serverSeps, new String[0]);
            if (!currentWallet.equals(serverSeps)) {
                Path certPath;
                if (!Files.exists(serverSepsPath, new LinkOption[0])) {
                    try {
                        Files.createDirectories(serverSepsPath, new FileAttribute[0]);
                    }
                    catch (IOException e) {
                        EnableRealtimeRedoWorkflow.this.logException(e);
                        return Result.fileCreateDirectoryError(RcvMessages.format("ERR_CREATE_WALLET_ERROR_MSG", serverSeps));
                    }
                }
                if (Files.exists(certPath = ConfigurationManager.getCertificatePath(EnableRealtimeRedoWorkflow.this.getDbUniqueName()), new LinkOption[0])) {
                    OracleWallet wallet = WalletManager.createWallet(serverSeps);
                    WalletManager.addCertificate(wallet, certPath);
                }
                WalletManager.migrateWallet(currentWallet, serverSeps);
                EnableRealtimeRedoWorkflow.this.protectedDatabaseCache.setWalletLocation(serverSeps);
                EnableRealtimeRedoWorkflow.this.protectedDatabaseCache.save();
                return new Result(Status.SUCCESS);
            }
            return new Result(Status.SKIPPED, "server_seps wallet is already configured.");
        }
    }

    private class ConfigureSqlnet
    implements Step {
        private ConfigureSqlnet() {
        }

        @Override
        public Result run() {
            EnableRealtimeRedoWorkflow.this.logger.log(Level.INFO, "Configuring sqlnet");
            String dbUniqueName = EnableRealtimeRedoWorkflow.this.getDbUniqueName();
            try {
                UpdateConfigurationStep.updateSqlnetOra(dbUniqueName);
            }
            catch (IOException e) {
                EnableRealtimeRedoWorkflow.this.logException(e);
                String sqlnetPath = FleetAgentContext.get(dbUniqueName).getSqlnetPath();
                return Result.fileWriteError(RcvMessages.format("ERR_CONFIG_SQLNET_ERROR_MSG", sqlnetPath));
            }
            return new Result(Status.SUCCESS);
        }
    }

    private class ConfigureTnsNames
    implements Step {
        private ConfigureTnsNames() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Result run() {
            EnableRealtimeRedoWorkflow.this.logger.log(Level.INFO, "Configuring tnsnames");
            String dbUniqueName = EnableRealtimeRedoWorkflow.this.getDbUniqueName();
            String dbrsTnsnamesPath = EnableRealtimeRedoWorkflow.this.database.getFleetAgentContext().getTnsnamesPath();
            String defaultTnsnamesPath = TnsnamesHelper.getDefaultTnsnamesFile(dbUniqueName);
            try {
                UpdateConfigurationStep.updateTnsnamesOra(dbUniqueName);
            }
            catch (IOException e) {
                EnableRealtimeRedoWorkflow.this.logException(e);
                return Result.fileWriteError(RcvMessages.format("ERR_CONFIG_TNSNAMES_ERROR_MSG", dbrsTnsnamesPath));
            }
            OraConfig defaultTnsnames = OraConfig.load(defaultTnsnamesPath);
            boolean needsUpdate = defaultTnsnames.addIfile(dbrsTnsnamesPath);
            if (!needsUpdate) return new Result(Status.SKIPPED);
            try {
                Files.move(Paths.get(defaultTnsnamesPath, new String[0]), Paths.get(defaultTnsnamesPath + ".prev", new String[0]), StandardCopyOption.ATOMIC_MOVE);
            }
            catch (IOException e) {
                EnableRealtimeRedoWorkflow.this.logger.getLogger().log(Level.FINE, "Failed to rename " + defaultTnsnamesPath, e);
            }
            try {
                defaultTnsnames.write(defaultTnsnamesPath);
                return new Result(Status.SUCCESS);
            }
            catch (IOException e) {
                EnableRealtimeRedoWorkflow.this.logException(e);
                return Result.fileWriteError(RcvMessages.format("ERR_CONFIG_TNSNAMES_ERROR_MSG", defaultTnsnamesPath));
            }
        }
    }

    private class VerifyConnection
    implements Step {
        private VerifyConnection() {
        }

        @Override
        public Result run() {
            EnableRealtimeRedoWorkflow.this.logger.log(Level.INFO, "Verifying connection to recovery service");
            String tnsAdmin = TnsnamesHelper.getDefaultTnsAdmin(EnableRealtimeRedoWorkflow.this.getDbUniqueName());
            for (LogArchiveDestination dest : EnableRealtimeRedoWorkflow.this.targetDestinations) {
                FleetEngine.getEngineConnection(tnsAdmin, EnableRealtimeRedoWorkflow.this.protectedDatabaseCache.getWalletLocation(), dest.getService());
            }
            return new Result(Status.SUCCESS);
        }
    }

    private class ConfigureLogArchiveDestinations
    implements Step {
        private ConfigureLogArchiveDestinations() {
        }

        @Override
        public Result run() {
            EnableRealtimeRedoWorkflow.this.logger.log(Level.INFO, "Configuring log archive destinations");
            List<Object> freeDestinations = new ArrayList();
            int freeDestinationIndex = 0;
            HashMap<String, String> updatedParameters = new HashMap<String, String>();
            try {
                freeDestinations = DatabaseUtils.getFreeLogArchiveDestinations(EnableRealtimeRedoWorkflow.this.conn);
            }
            catch (SQLException e) {
                EnableRealtimeRedoWorkflow.this.logException(e);
                return Result.databaseSqlError(RcvMessages.format("ERR_CONF_LOG_DEST_FREE_ERROR_MSG", new Object[0]));
            }
            ArrayList<Integer> destinationIds = new ArrayList<Integer>();
            for (LogArchiveDestination targetDest : EnableRealtimeRedoWorkflow.this.targetDestinations) {
                String string = targetDest.getDbUniqueName();
                String targetDestService = targetDest.getService();
                boolean foundTarget = false;
                for (int id : EnableRealtimeRedoWorkflow.this.currentDestinations.keySet()) {
                    LogArchiveDestination currentDest = EnableRealtimeRedoWorkflow.this.currentDestinations.get(id);
                    String currentDestDbUniqueName = currentDest.getDbUniqueName();
                    String currentDestService = currentDest.getService();
                    if (!currentDestDbUniqueName.equalsIgnoreCase(string) || !currentDestService.equalsIgnoreCase(targetDestService)) continue;
                    foundTarget = true;
                    destinationIds.add(id);
                    if (targetDest.equals(currentDest)) break;
                    String updateSql = "alter system set log_archive_dest_" + id + " = '" + targetDest.toString() + "'";
                    EnableRealtimeRedoWorkflow.this.logger.log(Level.FINE, "The following sql will be executed:");
                    EnableRealtimeRedoWorkflow.this.logger.log(Level.FINE, "\t" + updateSql + "\n");
                    updatedParameters.put("log_archive_dest_" + id, targetDest.toString());
                    break;
                }
                if (foundTarget) continue;
                if (freeDestinationIndex < freeDestinations.size()) {
                    String freeDestination = (String)freeDestinations.get(freeDestinationIndex);
                    String sql = String.format("alter system set %s = '%s'", freeDestination, targetDest.toString());
                    EnableRealtimeRedoWorkflow.this.logger.log(Level.FINE, "The following sql will be executed:");
                    EnableRealtimeRedoWorkflow.this.logger.log(Level.FINE, "\t" + sql + "\n");
                    ++freeDestinationIndex;
                    int ui = freeDestination.lastIndexOf("_");
                    if (ui >= 0) {
                        destinationIds.add(Integer.parseInt(freeDestination.substring(ui + 1)));
                    }
                    updatedParameters.put(freeDestination, targetDest.toString());
                    continue;
                }
                String error = "There are not enough free log archive destinations left to configure real-time redo log shipping to the Recovery Service.Please remove existing log archive destinations to free them up. You can view the list of log archive destinations by running 'show parameter log_archive_dest'";
                throw new RuntimeException(error);
            }
            HashMap<Object, Object> destinationStates = new HashMap();
            try {
                destinationStates = DatabaseUtils.getLogArchiveDestinationState(EnableRealtimeRedoWorkflow.this.conn, destinationIds);
            }
            catch (SQLException e) {
                EnableRealtimeRedoWorkflow.this.logException(e);
                return Result.databaseSqlError(RcvMessages.format("ERR_CONF_LOG_DEST_STATE_ERROR_MSG", destinationIds));
            }
            for (String string : destinationStates.keySet()) {
                if (((String)destinationStates.get(string)).equalsIgnoreCase("ENABLE")) continue;
                EnableRealtimeRedoWorkflow.this.logger.log(Level.FINE, "The following sql will be executed:");
                String sql = String.format("alter system set parameter %s = '%s'", string, "enable");
                EnableRealtimeRedoWorkflow.this.logger.log(Level.FINE, "\t" + sql + "\n");
                updatedParameters.put(string, "enable");
            }
            List<String> missingDgConfig = EnableRealtimeRedoWorkflow.this.getMissingDgConfig();
            if (!missingDgConfig.isEmpty()) {
                ArrayList<String> arrayList = new ArrayList<String>();
                List<String> currentDgConfig = EnableRealtimeRedoWorkflow.this.currentLogArchiveConfig.getDgConfig();
                arrayList.addAll(currentDgConfig);
                arrayList.addAll(missingDgConfig);
                EnableRealtimeRedoWorkflow.this.currentLogArchiveConfig.setDgConfig(arrayList);
                updatedParameters.put("log_archive_config", EnableRealtimeRedoWorkflow.this.currentLogArchiveConfig.toString());
                String sql = String.format("alter system set log_archive_config = '%s'", EnableRealtimeRedoWorkflow.this.currentLogArchiveConfig.toString());
                EnableRealtimeRedoWorkflow.this.logger.log(Level.FINE, "The following sql will be executed:");
                EnableRealtimeRedoWorkflow.this.logger.log(Level.FINE, "\t" + sql);
            }
            if (!updatedParameters.keySet().isEmpty()) {
                try {
                    DatabaseUtils.updateParameter(EnableRealtimeRedoWorkflow.this.conn, updatedParameters);
                }
                catch (SQLException sQLException) {
                    EnableRealtimeRedoWorkflow.this.logException(sQLException);
                    return Result.databaseSqlError(RcvMessages.format("ERR_CONF_LOG_DEST_UPDATE_ERROR_MSG", destinationIds));
                }
            } else {
                return new Result(Status.SKIPPED);
            }
            EnableRealtimeRedoWorkflow.this.restartDatabase = true;
            return new Result(Status.SUCCESS);
        }
    }

    private class ConfigureRedoTransportUser
    implements Step {
        private ConfigureRedoTransportUser() {
        }

        @Override
        public Result run() {
            EnableRealtimeRedoWorkflow.this.logger.log(Level.INFO, "Configuring redo transport user");
            String currentRedoTransportUser = DatabaseUtils.getRedoTransportUser(EnableRealtimeRedoWorkflow.this.conn);
            String vpcUser = EnableRealtimeRedoWorkflow.this.protectedDatabase.getVpcUserName();
            if (currentRedoTransportUser != null && currentRedoTransportUser.equals(vpcUser)) {
                return new Result(Status.SKIPPED);
            }
            if (currentRedoTransportUser != null && !currentRedoTransportUser.equals("null") && !currentRedoTransportUser.equals(vpcUser)) {
                return Result.errConfRedoUserError(currentRedoTransportUser);
            }
            if (currentRedoTransportUser == null || currentRedoTransportUser.equals("null")) {
                HashMap<String, String> updatedParameters = new HashMap<String, String>();
                updatedParameters.put("redo_transport_user", vpcUser);
                try {
                    DatabaseUtils.updateParameter(EnableRealtimeRedoWorkflow.this.conn, updatedParameters);
                }
                catch (SQLException e) {
                    EnableRealtimeRedoWorkflow.this.logException(e);
                    Result.databaseSqlError(RcvMessages.format("ERR_CONF_REDO_USER_UPDATE_ERROR_MSG", new Object[0]));
                }
                EnableRealtimeRedoWorkflow.this.logger.log(Level.FINE, "The following sql will be executed:");
                EnableRealtimeRedoWorkflow.this.logger.log(Level.FINE, String.format("alter system set redo_transport_user='%s'", EnableRealtimeRedoWorkflow.this.protectedDatabaseCache.getVpcUserName()));
                EnableRealtimeRedoWorkflow.this.restartDatabase = true;
                return new Result(Status.SUCCESS);
            }
            return new Result(Status.SKIPPED);
        }
    }

    private class EnableRealtimeRedoOnRemoteNodes
    implements Step {
        private EnableRealtimeRedoOnRemoteNodes() {
        }

        @Override
        public Result run() {
            EnableRealtimeRedoWorkflow.this.logger.log(Level.INFO, "Enabling real-time redo on remote nodes");
            FleetAgentContext fleetAgentContext = EnableRealtimeRedoWorkflow.this.database.getFleetAgentContext();
            if (EnableRealtimeRedoWorkflow.this.sshConnections.isEmpty()) {
                return new Result(Status.SKIPPED);
            }
            String connectionName = fleetAgentContext.getConnectionName();
            NamedConnectionsManager.saveConnection(EnableRealtimeRedoWorkflow.this.conn, EnableRealtimeRedoWorkflow.this.ctx, connectionName);
            if (!EnableRealtimeRedoWorkflow.this.localOnly) {
                NamedConnectionsManager.propagateNamedConnectionToRemoteNodes(connectionName, EnableRealtimeRedoWorkflow.this.sshConnections);
                RCVCommand rcvCommand = new RCVCommand(RCVCommand.SubCommand.ADD_REALTIME_REDO).addFlag(RCVOptions.Options.LOCAL);
                for (SshHelper sshConnection : EnableRealtimeRedoWorkflow.this.sshConnections) {
                    String remoteHost = sshConnection.getHost();
                    SystemCommand.ExecutionResult remoteResult = sshConnection.executeRcvCommand(connectionName, rcvCommand, fleetAgentContext.getScriptsDirectory() + File.separator + "enable_realtime_redo.sql", DatabaseUtils.getInstanceNameForHost(EnableRealtimeRedoWorkflow.this.conn, remoteHost));
                    String output = remoteResult.getOutput();
                    if (output != null) {
                        EnableRealtimeRedoWorkflow.this.logger.log(Level.FINE, output);
                    }
                    if (remoteResult.getReturnCode() == 0) continue;
                    return Result.wfRemoteCommandError(RcvMessages.format("ERR_FAILED_ADD_REMOTE_ERROR_MSG", remoteHost));
                }
            }
            return new Result(Status.SUCCESS);
        }
    }

    private class UpdateRMANConfiguration
    implements Step {
        private UpdateRMANConfiguration() {
        }

        @Override
        public Result run() {
            ConfigureRMANWorkflow wf = new ConfigureRMANWorkflow.Builder("wallet_location", EnableRealtimeRedoWorkflow.this.protectedDatabaseCache.getWalletLocation()).build(EnableRealtimeRedoWorkflow.this.conn);
            wf.setLogger(EnableRealtimeRedoWorkflow.this.logger);
            return wf.runWithLock(false);
        }
    }

    private class NotifyControlPlane
    implements Step {
        private NotifyControlPlane() {
        }

        @Override
        public Result run() {
            EnableRealtimeRedoWorkflow.this.logger.log(Level.INFO, "Notifying control plane");
            if (!EnableRealtimeRedoWorkflow.this.protectedDatabase.getIsRedoLogsShipped().booleanValue()) {
                String endpoint = EnableRealtimeRedoWorkflow.this.getDatabase().getFleetAgentContext().getProtectedDatabaseCache().getEndpoint();
                UpdateProtectedDatabaseStep step = new UpdateProtectedDatabaseStep(endpoint, EnableRealtimeRedoWorkflow.this.getProtectedDatabaseOcid(), EnableRealtimeRedoWorkflow.this.getWorkflowLogger()).realtimeRedo(true);
                return step.run();
            }
            return new Result(Status.SKIPPED);
        }
    }

    private class RestartDatabase
    implements Step {
        private RestartDatabase() {
        }

        @Override
        public Result run() {
            EnableRealtimeRedoWorkflow.this.logger.log(Level.INFO, "Checking database");
            if (EnableRealtimeRedoWorkflow.this.restartDatabase) {
                EnableRealtimeRedoWorkflow.this.logger.log(Level.INFO, "!! Action Required: Please restart the database to finish enabling real-time redo !!");
            }
            return new Result(Status.SUCCESS);
        }
    }
}

