/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.sql.Connection;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import oracle.dbtools.core.collections.ConfigurationProperties;
import oracle.dbtools.core.connections.storage.ConnectionDefinition;
import oracle.dbtools.core.secrets.TextSecret;
import oracle.dbtools.extension.rcv.commands.RCVCommand;
import oracle.dbtools.extension.rcv.commands.RCVCommandBase;
import oracle.dbtools.extension.rcv.commands.RCVOptions;
import oracle.dbtools.extension.rcv.models.RCVContext;
import oracle.dbtools.extension.rcv.models.SCAN;
import oracle.dbtools.extension.rcv.models.SCANListener;
import oracle.dbtools.extension.rcv.models.database.DatabaseConfig;
import oracle.dbtools.extension.rcv.models.database.FleetAgentContext;
import oracle.dbtools.extension.rcv.models.database.FullDatabaseConfig;
import oracle.dbtools.extension.rcv.models.database.Oratab;
import oracle.dbtools.extension.rcv.models.database.SimpleDatabaseConfig;
import oracle.dbtools.extension.rcv.models.ora.Node;
import oracle.dbtools.extension.rcv.models.ora.OraConfig;
import oracle.dbtools.extension.rcv.models.systemcommands.SystemCommand;
import oracle.dbtools.extension.rcv.utils.DatabaseUtils;
import oracle.dbtools.extension.rcv.utils.NamedConnectionsManager;
import oracle.dbtools.extension.rcv.utils.ScriptFactory;
import oracle.dbtools.extension.rcv.utils.TnsnamesHelper;
import oracle.dbtools.extension.rcv.utils.Utils;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.extension.rcv.workflows.Status;
import oracle.dbtools.extension.rcv.workflows.Workflow;
import oracle.dbtools.extension.rcv.workflows.WorkflowLogger;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;

public class AddSysbackupUserWorkflow
extends Workflow {
    private static final String SYSBACKUP_USER = "rcv_sysbackup";
    private Connection conn;
    private String dbUniqueName;
    private String oracleSid;
    private String oracleHome;

    public AddSysbackupUserWorkflow(ParsedCommand command, Connection conn, ScriptRunnerContext ctx) {
        super(RCVCommand.SubCommand.ADD_SYSBACKUP_USER, conn, ctx);
        this.conn = conn;
        this.dbUniqueName = (String)command.getOptionValue((Id)RCVOptions.Options.DB_UNIQUE_NAME);
        this.oracleSid = (String)command.getOptionValue((Id)RCVOptions.Options.ORACLE_SID);
        this.oracleHome = (String)command.getOptionValue((Id)RCVOptions.Options.ORACLE_HOME);
    }

    @Override
    public Result run(boolean verbose) {
        Optional<FullDatabaseConfig> dbConfigOptional;
        WorkflowLogger logger = this.getWorkflowLogger();
        if (verbose) {
            logger.log(Level.INFO, "Log file: " + logger.getLogFile());
        }
        Result result = new Result(Status.SUCCESS);
        if (this.dbUniqueName != null && this.oracleSid != null && this.oracleHome != null) {
            result = AddSysbackupUserWorkflow.createSysbackupUser(new SimpleDatabaseConfig(this.dbUniqueName, this.oracleSid, this.oracleHome), logger.getLogger());
        }
        if (this.conn == null) {
            if (this.dbUniqueName == null) {
                String error = "Please either specify a db_unique_name or connect to the database you want to create the sysbackup for.";
                throw Result.invalidOptionException(error);
            }
        } else if (this.dbUniqueName == null) {
            this.dbUniqueName = DatabaseUtils.getDbUniqueName(this.conn);
            if (this.dbUniqueName == null) {
                String error = String.format("Failed to get the db_unique_name. Please specify it using the option -%s <name>", new Object[]{RCVOptions.Options.DB_UNIQUE_NAME});
                return new Result(Status.FAILED, error);
            }
        }
        if ((dbConfigOptional = FullDatabaseConfig.getDatabaseConfig(this.dbUniqueName)).isPresent()) {
            result = AddSysbackupUserWorkflow.createSysbackupUser(dbConfigOptional.get(), logger.getLogger());
        } else {
            Optional<String> oracleHomeOptional;
            if (this.oracleSid == null) {
                this.oracleSid = System.getenv("ORACLE_SID");
                if (this.oracleSid == null) {
                    String error = String.format("Failed to find ORACLE_SID. Please specify it by using the -%s option", new Object[]{RCVOptions.Options.ORACLE_SID});
                    return new Result(Status.FAILED, error);
                }
            }
            if ((oracleHomeOptional = Oratab.getOracleHome(this.dbUniqueName, this.oracleSid)).isPresent()) {
                result = AddSysbackupUserWorkflow.createSysbackupUser(new SimpleDatabaseConfig(this.dbUniqueName, this.oracleSid, oracleHomeOptional.get()), logger.getLogger());
            } else {
                String oracleHome = RCVCommandBase.getOracleHome();
                if (oracleHome == null) {
                    String error = String.format("Failed to find ORACLE_HOME. Please provide it using the -%s option.", new Object[]{RCVOptions.Options.ORACLE_HOME});
                    return new Result(Status.FAILED, error);
                }
                result = AddSysbackupUserWorkflow.createSysbackupUser(new SimpleDatabaseConfig(this.dbUniqueName, this.oracleSid, RCVCommandBase.getOracleHome()), logger.getLogger());
            }
        }
        Status status = result.getStatus();
        if (status.equals((Object)Status.SUCCESS) || status.equals((Object)Status.SKIPPED)) {
            Level logLevel = verbose ? Level.INFO : Level.FINE;
            String userStatus = status.equals((Object)Status.SUCCESS) ? "Successfully created sysbackup user" : "Sysbackup user already exists";
            String msg = String.format("%s. You can login to the database as the sysbackup user by running \"sql -name %s\".", userStatus, FleetAgentContext.get(this.dbUniqueName.toLowerCase()).getConnectionName());
            logger.log(logLevel, msg);
        }
        return result;
    }

    public static Result createSysbackupUser(DatabaseConfig databaseConfig, Logger logger) {
        String sqlplus;
        Optional<ConnectionDefinition> definitionOptional;
        if (logger == null) {
            logger = RCVCommandBase.getLogger().getLogger();
        }
        String dbUniqueName = databaseConfig.getDbUniqueName().toLowerCase();
        String sysbackupPassword = new String(Utils.generateRandomPassword(15));
        String scriptsDirectory = String.join((CharSequence)File.separator, RCVCommandBase.getAgentBaseDirectory(), "scripts");
        String script = ScriptFactory.generateCreateSysbackupScript(scriptsDirectory);
        String connectionName = FleetAgentContext.getConnectionName(dbUniqueName);
        if (NamedConnectionsManager.connectionExists(connectionName) && (definitionOptional = NamedConnectionsManager.getConnectionDefinition(connectionName)).isPresent()) {
            logger.log(Level.FINE, "Named connection for sysbackup user already exists");
            ConnectionDefinition definition = definitionOptional.get();
            List<ConnectionDefinition> allMatchingDefintions = NamedConnectionsManager.getConnectionDefinitions(connectionName);
            ConfigurationProperties properties = definition.getDbtoolsProperties();
            String username = properties.getProperty((CharSequence)"userName");
            String connectString = properties.getProperty((CharSequence)"connectionString");
            TextSecret textSecret = definition.getWallet().getPassword();
            if (allMatchingDefintions.size() > 1) {
                for (int i = 0; i < allMatchingDefintions.size(); ++i) {
                    NamedConnectionsManager.deleteConnection(connectionName);
                }
                textSecret.set(secret -> NamedConnectionsManager.saveConnection(connectionName, connectString, username, secret, "sysbackup"));
                return new Result(Status.SUCCESS);
            }
            return new Result(Status.SKIPPED);
        }
        SystemCommand sqlplusCommand = new SystemCommand().logger(logger).setEnvironmentVariable("ORACLE_HOME", databaseConfig.getOracleHome()).setEnvironmentVariable("ORACLE_SID", databaseConfig.getOracleSid());
        SystemCommand.ExecutionResult execResult = sqlplusCommand.run(List.of(sqlplus = String.join((CharSequence)File.separator, databaseConfig.getOracleHome(), "bin", "sqlplus"), "-L", "/", "as", "sysdba", "@" + script), dbUniqueName + "\nrcv_sysbackup\n" + sysbackupPassword);
        if (execResult.getReturnCode() == 0) {
            String[] lines;
            for (String line : lines = execResult.getOutput().split("\n")) {
                String maskedLine = line.contains(sysbackupPassword) ? line.replace(sysbackupPassword, "***") : line;
                logger.log(Level.FINE, maskedLine);
            }
            List errors = Arrays.stream(lines).filter(s -> s.contains("ORA-") || s.contains("ERROR")).collect(Collectors.toList());
            if (!errors.isEmpty()) {
                List invalidDbUniqueName = errors.stream().filter(s -> s.contains("ORA-20001")).collect(Collectors.toList());
                Object error = !invalidDbUniqueName.isEmpty() ? String.format("An invalid db_unique_name of %s was specified.", dbUniqueName) : "Failed to create sysbackup user for database " + databaseConfig.getDbUniqueName() + ". Please see log for details.";
                return new Result(Status.FAILED, (String)error);
            }
        } else {
            String error = "Failed to create sysbackup user for database " + databaseConfig.getDbUniqueName() + ". Please check the log file for details.";
            if (execResult.getOutput() != null) {
                List lines = Arrays.stream(execResult.getOutput().split("\n")).map(s -> s.contains(sysbackupPassword) ? s.replace(sysbackupPassword, "***") : s).collect(Collectors.toList());
                for (String line : lines) {
                    logger.log(Level.FINE, line);
                }
            }
            return new Result(Status.FAILED, error);
        }
        String sysbackupUserName = AddSysbackupUserWorkflow.getUserName(databaseConfig);
        NamedConnectionsManager.saveConnection(connectionName, AddSysbackupUserWorkflow.getConnectString(databaseConfig), sysbackupUserName, sysbackupPassword, "sysbackup");
        return new Result(Status.SUCCESS);
    }

    private static String getUserName(DatabaseConfig databaseConfig) {
        boolean isMultitenant = DatabaseUtils.isMultitenant(databaseConfig.getOracleHome(), databaseConfig.getOracleSid());
        if (isMultitenant) {
            return "c##rcv_sysbackup";
        }
        return SYSBACKUP_USER;
    }

    public static String getConnectString(DatabaseConfig databaseConfig) {
        String oracleHome = databaseConfig.getOracleHome();
        String dbUniqueName = databaseConfig.getDbUniqueName();
        int port = 1521;
        String host = null;
        Optional<SCAN> scanOptional = SCAN.getInstance(oracleHome);
        if (scanOptional.isPresent()) {
            SCAN scan = scanOptional.get();
            int networkNum = scan.getNetworkNum();
            Optional<SCANListener> listenerOptional = SCANListener.getListenerWithNetworkNum(oracleHome, networkNum);
            host = scan.getName();
            if (listenerOptional.isPresent()) {
                port = listenerOptional.get().getPort();
            }
        } else {
            String listenerOraFile = String.join((CharSequence)File.separator, TnsnamesHelper.getDefaultTnsAdmin(dbUniqueName), "listener.ora");
            if (Files.exists(Paths.get(listenerOraFile, new String[0]), new LinkOption[0])) {
                OraConfig listenerOra = OraConfig.load(listenerOraFile);
                block0: for (Node<String> entry : listenerOra.getEntries()) {
                    List<Node<String>> addressEntries = entry.getAllNodes("ADDRESS");
                    if (addressEntries.isEmpty()) continue;
                    for (Node<String> addressEntry : addressEntries) {
                        Node<String> protocolEntry = addressEntry.getNode("PROTOCOL");
                        if (protocolEntry == null || !listenerOra.getParameterValue(protocolEntry).equalsIgnoreCase("TCP")) continue;
                        Node<String> hostEntry = addressEntry.getNode("HOST");
                        Node<String> portEntry = addressEntry.getNode("PORT");
                        if (hostEntry == null || portEntry == null) continue;
                        host = listenerOra.getParameterValue(hostEntry);
                        port = Integer.parseInt(listenerOra.getParameterValue(portEntry).strip());
                        continue block0;
                    }
                }
            }
        }
        if (host == null) {
            host = RCVContext.getLocalHost(true);
        }
        return "jdbc:oracle:thin:@" + host + ":" + port + ":" + databaseConfig.getOracleSid();
    }
}

