/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows;

import com.oracle.bmc.recovery.model.CreateProtectionPolicyDetails;
import com.oracle.bmc.recovery.model.LifecycleState;
import com.oracle.bmc.recovery.requests.CreateProtectionPolicyRequest;
import com.oracle.bmc.recovery.responses.CreateProtectionPolicyResponse;
import java.sql.Connection;
import java.util.Date;
import java.util.logging.Level;
import oracle.dbtools.extension.rcv.commands.RCVCommand;
import oracle.dbtools.extension.rcv.commands.RCVCommandBase;
import oracle.dbtools.extension.rcv.commands.RCVOptions;
import oracle.dbtools.extension.rcv.commands.RcvMessages;
import oracle.dbtools.extension.rcv.models.GlobalMetadata;
import oracle.dbtools.extension.rcv.oci.RecoveryClientManager;
import oracle.dbtools.extension.rcv.utils.Utils;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.extension.rcv.workflows.Status;
import oracle.dbtools.extension.rcv.workflows.Workflow;
import oracle.dbtools.extension.rcv.workflows.WorkflowLogger;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;

public class AddProtectionPolicyWorkflow
extends Workflow {
    private Connection conn;
    private WorkflowLogger logger = this.getWorkflowLogger();
    private RecoveryClientManager recoveryClientManager;
    private String endpoint;
    private int retentionPeriod;
    private String compartmentId;
    private String displayName;
    private ParsedCommand command;
    private Date policyLockedDateTime;

    public AddProtectionPolicyWorkflow(ParsedCommand command, Connection conn, ScriptRunnerContext ctx) {
        super(RCVCommand.SubCommand.ADD_PROTECTION_POLICY, conn, ctx);
        this.conn = conn;
        this.command = command;
    }

    @Override
    public void initState() {
        this.retentionPeriod = (Integer)this.command.getOptionValue((Id)RCVOptions.Options.RETENTION_PERIOD);
        this.endpoint = (String)this.command.getOptionValue((Id)RCVOptions.Options.ENDPOINT);
        this.displayName = (String)this.command.getOptionValue((Id)RCVOptions.Options.DISPLAY_NAME);
        this.compartmentId = (String)this.command.getOptionValue((Id)RCVOptions.Options.COMPARTMENT_ID);
        this.policyLockedDateTime = (Date)this.command.getOptionValue((Id)RCVOptions.Options.POLICY_LOCKED_DATETIME);
        if (this.displayName == null) {
            this.displayName = "protection_policy_" + Utils.getDateAsString();
        }
        if (this.compartmentId == null) {
            this.compartmentId = GlobalMetadata.load().getAuthentication().getTenancyId();
            if (this.compartmentId == null) {
                throw Result.missingOptionException(RcvMessages.format("WF_MISSING_COMPARTMENT_ID_OPTION", RCVOptions.Options.COMPARTMENT_ID.getName().toLowerCase()));
            }
        }
        if (this.endpoint == null && this.conn != null) {
            this.endpoint = RCVCommandBase.getDatabase(this.conn).getFleetAgentContext().getProtectedDatabaseCache().getEndpoint();
        }
        this.recoveryClientManager = new RecoveryClientManager(this.endpoint, this.logger.getLogger());
    }

    @Override
    public Result run(boolean verbose) {
        this.initState();
        CreateProtectionPolicyRequest request = this.createProtectionPolicyRequest();
        this.logger.log(Level.FINE, request.toString());
        CreateProtectionPolicyResponse response = this.recoveryClientManager.createProtectionPolicy(request);
        this.logger.log(Level.FINE, response.toString());
        this.logger.log(Level.INFO, "Waiting for policy to be created");
        String ocid = response.getProtectionPolicy().getId();
        LifecycleState state = this.recoveryClientManager.waitForResourceUpdate(600, 20, () -> this.recoveryClientManager.getProtectionPolicy(ocid).getLifecycleState());
        if (state.equals((Object)LifecycleState.Active)) {
            this.logger.log(Level.INFO, "The protection policy ID is: " + response.getProtectionPolicy().getId());
            return new Result(Status.SUCCESS);
        }
        if (state.equals((Object)LifecycleState.Creating)) {
            return Result.addResourceLifecycleStatusTmt("protection policy");
        }
        return Result.verifyLifecycleStatusError("protection policy", state.getValue(), LifecycleState.Active.getValue(), LifecycleState.Creating.getValue());
    }

    private CreateProtectionPolicyRequest createProtectionPolicyRequest() {
        CreateProtectionPolicyDetails.Builder builder = new CreateProtectionPolicyDetails.Builder().compartmentId(this.compartmentId).displayName(this.displayName).backupRetentionPeriodInDays(Integer.valueOf(this.retentionPeriod));
        if (this.policyLockedDateTime != null) {
            String rfc3339Format = Utils.getRFC3339Format(this.policyLockedDateTime);
            builder.policyLockedDateTime(rfc3339Format);
        }
        return new CreateProtectionPolicyRequest.Builder().body$(builder.build()).build();
    }
}

