/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.utils;

import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.extension.rcv.commands.RCVCommandBase;
import oracle.dbtools.extension.rcv.commands.RcvMessages;
import oracle.dbtools.extension.rcv.models.systemcommands.SystemCommand;
import oracle.dbtools.extension.rcv.workflows.Result;

public class DatabaseUtils {
    private static final String GET_ARCHIVE_LOG_MODE = "SELECT LOG_MODE FROM V$DATABASE";
    private static final String GET_CON_ID = "SELECT sys_context('USERENV', 'CON_ID') as con_id FROM DUAL";
    private static final String GET_DB_ID = "SELECT dbid FROM v$database";
    private static final String GET_DB_NAME = "SELECT name FROM v$database";
    private static final String GET_DB_OWNER = "select osuser from v$session where program like '%PMON%'";
    private static final String GET_DB_UNIQUE_NAME = "SELECT db_unique_name FROM v$database";
    private static final String GET_DB_SIZE = "SELECT ROUND(SUM(bytes) / 1024 / 1024 / 1024) FROM CDB_DATA_FILES";
    private static final String GET_DB_STATUS = "SELECT STATUS FROM V$INSTANCE";
    private static final String GET_GLOBAL_DB_STATUS = "SELECT HOST_NAME, STATUS FROM GV$INSTANCE";
    private static final String GET_FREE_LOG_ARCHIVE_DEST = "SELECT DEST_NAME FROM V$ARCHIVE_DEST WHERE STATUS = 'INACTIVE'";
    private static final String GET_LOCAL_HOST = "SELECT sys_context('USERENV', 'HOST') AS LOCAL_HOST FROM dual";
    private static final String GET_NODE_ID = "SELECT inst_id FROM gv$instance WHERE upper(host_name) = upper(?)";
    private static final String GET_INSTANCE_NAME = "SELECT instance_name FROM gv$instance WHERE host_name = ?";
    private static final String GET_LOG_ARCHIVE_CONFIG = "SELECT value from gv$parameter where name='log_archive_config'";
    private static final String GET_REDO_TRANSPORT_USER = "SELECT value from gv$parameter where name='redo_transport_user'";
    private static final String GET_REMOTE_HOSTNAMES = "SELECT host_name from gv$instance where host_name != :LOCALHOST";
    private static final String GET_USER = "SELECT USER FROM DUAL";
    private static final String GET_VERSION_FULL = "SELECT version_full FROM v$instance";
    private static final String IS_CDB = "SELECT cdb from v$database";
    private static final String DEST_NAME = "dest_name";

    public static String getDatabaseVersion(Connection conn) {
        DBUtil dbutil = DBUtil.getInstance((Connection)conn);
        if (dbutil == null) {
            System.out.println("Not connected to a database.");
            return "";
        }
        return dbutil.executeReturnOneCol(GET_VERSION_FULL);
    }

    public static String queryOneRow(Connection conn, String sql) {
        return DBUtil.getInstance((Connection)conn).executeReturnOneCol(sql);
    }

    public static int compareDatabaseVersion(String v1, String v2) {
        int j;
        String[] subVersions1 = v1.split("\\.");
        String[] subVersions2 = v2.split("\\.");
        int i = 0;
        for (j = 0; i < subVersions1.length && j < subVersions2.length; ++i, ++j) {
            int sv2;
            int sv1 = Integer.parseInt(subVersions1[i]);
            if (sv1 < (sv2 = Integer.parseInt(subVersions2[i]))) {
                return -1;
            }
            if (sv1 <= sv2) continue;
            return 1;
        }
        if (i >= subVersions1.length && j >= subVersions2.length) {
            return 0;
        }
        if (i < subVersions1.length) {
            return 1;
        }
        return -1;
    }

    public static String getDbUniqueName(Connection conn) {
        return DatabaseUtils.queryOneRow(conn, GET_DB_UNIQUE_NAME).toLowerCase();
    }

    public static String getDbUniqueName(String oracleSid, String oracleHome) {
        String sqlplus = String.join((CharSequence)File.separator, oracleHome, "bin", "sqlplus");
        String input = "set heading off\nSELECT db_unique_name FROM v$database;\nexit;";
        SystemCommand.ExecutionResult result = new SystemCommand().setEnvironmentVariable("ORACLE_SID", oracleSid).setEnvironmentVariable("ORACLE_HOME", oracleHome).logger(RCVCommandBase.getLogger().getLogger()).run(List.of(sqlplus, "-S", "-L", "/", "as", "sysdba"), input);
        if (result.getReturnCode() == 0) {
            String output = result.getOutput();
            String[] lines = output.split("\n");
            if (Arrays.stream(lines).anyMatch(line -> line.contains("ERROR") || line.contains("ORA-"))) {
                return null;
            }
            for (String line2 : lines) {
                String trimmedLine = line2.trim();
                if (trimmedLine.isEmpty()) continue;
                return trimmedLine.toLowerCase();
            }
        }
        return null;
    }

    public static int getDbSize(Connection conn) {
        String sizeInString = DatabaseUtils.queryOneRow(conn, GET_DB_SIZE);
        try {
            return Integer.parseInt(sizeInString);
        }
        catch (NumberFormatException e) {
            throw Result.databaseSqlException(RcvMessages.format("DATABASE_GET_DB_SIZE_ERROR_MSG", new Object[0]), e);
        }
    }

    public static String getUser(Connection conn) {
        return DatabaseUtils.queryOneRow(conn, GET_USER);
    }

    public static String getConnectionId(Connection conn) {
        return DatabaseUtils.queryOneRow(conn, GET_CON_ID);
    }

    public static String getCdb(Connection conn) {
        return DatabaseUtils.queryOneRow(conn, IS_CDB);
    }

    public static String getArchiveLogMode(Connection conn) {
        return DatabaseUtils.queryOneRow(conn, GET_ARCHIVE_LOG_MODE);
    }

    public static boolean isMultitenant(Connection conn) {
        if (conn == null) {
            return false;
        }
        return DatabaseUtils.getCdb(conn).equalsIgnoreCase("YES");
    }

    public static boolean isMultitenant(String oracleHome, String oracleSid) {
        String sqlplus = String.join((CharSequence)File.separator, oracleHome, "bin", "sqlplus");
        String input = "set heading off\nSELECT cdb from v$database;\nexit;";
        SystemCommand.ExecutionResult result = new SystemCommand().setEnvironmentVariable("ORACLE_SID", oracleSid).setEnvironmentVariable("ORACLE_HOME", oracleHome).logger(RCVCommandBase.getLogger().getLogger()).run(List.of(sqlplus, "-S", "-L", "/", "as", "sysdba"), input);
        String output = result.getOutput();
        String[] lines = output.split("\n");
        if (Arrays.stream(lines).anyMatch(line -> line.contains("ERROR") || line.contains("ORA-"))) {
            throw new RuntimeException("Failed to determine if database is CDB.");
        }
        for (String line2 : lines) {
            String trimmedLine = line2.trim();
            if (trimmedLine.isEmpty()) continue;
            return trimmedLine.equalsIgnoreCase("YES");
        }
        return false;
    }

    public static boolean isPDB(Connection conn) {
        if (conn == null) {
            return false;
        }
        String connectionId = DatabaseUtils.getConnectionId(conn);
        return !connectionId.equals("1");
    }

    public static List<String> getFreeLogArchiveDestinations(Connection conn) throws SQLException {
        ResultSet rs = DBUtil.getInstance((Connection)conn).executeOracleQuery(GET_FREE_LOG_ARCHIVE_DEST, null);
        ArrayList<String> lads = new ArrayList<String>();
        if (rs != null) {
            while (rs.next()) {
                String name = rs.getString(DEST_NAME);
                lads.add(name);
            }
        }
        return lads;
    }

    public static ResultSet getLogArchiveDestinations(Connection conn, List<String> destinationNames) throws SQLException {
        Object GET_LOG_ARCHIVE_DEST = "SELECT DEST_ID, DEST_NAME, STATUS, DESTINATION FROM V$ARCHIVE_DEST WHERE UPPER(DESTINATION) IN (";
        int n = destinationNames.size();
        for (int i = 0; i < n; ++i) {
            GET_LOG_ARCHIVE_DEST = (String)GET_LOG_ARCHIVE_DEST + "?";
            if (i >= n - 1) continue;
            GET_LOG_ARCHIVE_DEST = (String)GET_LOG_ARCHIVE_DEST + ", ";
        }
        GET_LOG_ARCHIVE_DEST = (String)GET_LOG_ARCHIVE_DEST + ")";
        ArrayList<String> capitalizedDestinationNames = new ArrayList<String>();
        for (String s : destinationNames) {
            capitalizedDestinationNames.add(s.toUpperCase());
        }
        ResultSet rs = DBUtil.getInstance((Connection)conn).executeQuery((String)GET_LOG_ARCHIVE_DEST, capitalizedDestinationNames);
        return rs;
    }

    public static String getLogArchiveConfig(Connection conn) {
        return DatabaseUtils.queryOneRow(conn, GET_LOG_ARCHIVE_CONFIG);
    }

    public static String getRedoTransportUser(Connection conn) {
        return DatabaseUtils.queryOneRow(conn, GET_REDO_TRANSPORT_USER);
    }

    public static String getParameter(Connection conn, String parameterName) {
        String query = "SELECT value from v$parameter WHERE UPPER(NAME) = ?";
        List<String> binds = List.of(parameterName.toUpperCase());
        return DBUtil.getInstance((Connection)conn).executeReturnOneCol(query, binds);
    }

    public static HashMap<String, String> getParameters(Connection conn, List<String> parameterNames) throws SQLException {
        HashMap<String, String> results;
        StringBuilder sql = new StringBuilder("SELECT name, value FROM v$parameter WHERE UPPER(name) IN (");
        for (int i = 0; i < parameterNames.size(); ++i) {
            sql.append("?");
            if (i >= parameterNames.size() - 1) continue;
            sql.append(", ");
        }
        sql.append(")");
        ArrayList<String> capitalizedParameterNames = new ArrayList<String>();
        for (String s : parameterNames) {
            capitalizedParameterNames.add(s.toUpperCase());
        }
        try (ResultSet rs = DBUtil.getInstance((Connection)conn).executeQuery(sql.toString(), capitalizedParameterNames);){
            results = new HashMap<String, String>();
            if (rs != null) {
                while (rs.next()) {
                    results.put(rs.getString("name"), rs.getString("value"));
                }
            }
        }
        return results;
    }

    public static HashMap<String, String> getLogArchiveDestinationState(Connection conn, List<Integer> logArchiveDestinationIDs) throws SQLException {
        List<String> logArchiveDestinationStateNames = logArchiveDestinationIDs.stream().map(id -> "log_archive_dest_state_" + id).collect(Collectors.toList());
        return DatabaseUtils.getParameters(conn, logArchiveDestinationStateNames);
    }

    public static void updateParameter(Connection conn, HashMap<String, String> parametersMap) throws SQLException {
        for (String parameterName : parametersMap.keySet()) {
            Statement statement = conn.createStatement();
            String sql = String.format("ALTER SYSTEM SET %s = '%s'", parameterName, parametersMap.get(parameterName));
            statement.execute(sql);
        }
    }

    public static String getDbId(Connection conn) {
        return DatabaseUtils.queryOneRow(conn, GET_DB_ID);
    }

    public static String getDbName(Connection conn) {
        return DatabaseUtils.queryOneRow(conn, GET_DB_NAME);
    }

    public static Integer getNodeId(Connection conn) {
        String localHost = DatabaseUtils.getLocalHost(conn);
        if (localHost != null) {
            List<String> binds = List.of(localHost);
            String instanceIdString = DBUtil.getInstance((Connection)conn).executeReturnOneCol(GET_NODE_ID, binds);
            try {
                return Integer.parseInt(instanceIdString);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    public static String getLocalHost(Connection conn) {
        return DatabaseUtils.queryOneRow(conn, GET_LOCAL_HOST);
    }

    public static List<String> getRemoteHostNames(Connection conn) {
        ArrayList<String> hostnames = new ArrayList<String>();
        String localHost = DatabaseUtils.getLocalHost(conn);
        try (ResultSet rs = DBUtil.getInstance((Connection)conn).executeOracleQuery(GET_REMOTE_HOSTNAMES, Map.of("LOCALHOST", localHost));){
            if (rs != null) {
                while (rs.next()) {
                    String name = rs.getString("HOST_NAME");
                    hostnames.add(name);
                }
            }
        }
        catch (SQLException e) {
            throw Result.databaseSqlException(RcvMessages.format("DATABASE_GET_REMOTE_HOST_NAMES_ERROR_MSG", new Object[0]), e);
        }
        return hostnames;
    }

    public static String generateDatabaseIdForOnPremiseClient(Connection conn) {
        return DatabaseUtils.getDbId(conn) + DatabaseUtils.getDbUniqueName(conn) + DatabaseUtils.getDbName(conn);
    }

    public static String getInstanceNameForHost(Connection conn, String host) {
        return DatabaseUtils.queryOneRow(conn, String.format("SELECT instance_name FROM gv$instance WHERE host_name = '%s'", host));
    }

    public static String getInstanceName(Connection conn) {
        String localHost = DatabaseUtils.getLocalHost(conn);
        if (localHost != null) {
            List<String> binds = List.of(localHost);
            return DBUtil.getInstance((Connection)conn).executeReturnOneCol(GET_INSTANCE_NAME, binds);
        }
        return null;
    }

    public static String getDatabaseOwner(Connection conn) {
        return DatabaseUtils.queryOneRow(conn, GET_DB_OWNER);
    }

    public static String getDatabaseStatus(Connection conn) {
        return DatabaseUtils.queryOneRow(conn, GET_DB_STATUS);
    }

    public static Map<String, String> getDatabaseStatusOnAllNodes(Connection conn) {
        HashMap<String, String> statusMap = new HashMap<String, String>();
        try (ResultSet rs = DBUtil.getInstance((Connection)conn).executeOracleQuery(GET_GLOBAL_DB_STATUS, null);){
            if (rs != null) {
                while (rs.next()) {
                    String host = rs.getString("HOST_NAME");
                    String status = rs.getString("STATUS");
                    statusMap.put(host, status);
                }
            }
        }
        catch (SQLException e) {
            throw Result.databaseSqlException(RcvMessages.format("DATABASE_GET_DB_STATUS_ERROR_MSG", new Object[0]), e);
        }
        return statusMap;
    }
}

