/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.oracle.bmc.recovery.model.FetchProtectedDatabaseConfigurationDetails;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.core.jdbc.tns.TNSEntry;
import oracle.dbtools.core.jdbc.tns.TNSNames;
import oracle.dbtools.extension.rcv.commands.RCVCommandBase;
import oracle.dbtools.extension.rcv.models.LogArchiveDestination;
import oracle.dbtools.extension.rcv.models.database.Database;
import oracle.dbtools.extension.rcv.models.database.FleetAgentContext;
import oracle.dbtools.extension.rcv.models.database.ProtectedDatabaseCache;
import oracle.dbtools.extension.rcv.oci.RecoveryClientManager;
import oracle.dbtools.extension.rcv.utils.TnsnamesHelper;
import oracle.dbtools.extension.rcv.utils.Utils;
import oracle.dbtools.extension.rcv.utils.WalletManager;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.security.pki.OracleWallet;

public class ConfigurationManager {
    public static final String RCV_CONF = "rcv.conf.txt";
    public static final String DBRS_NAMES = "dbrsnames.ora.txt";
    public static final String CERT_PEM = "certChainPem.txt";
    public static final String LOG_ARCHIVE_DESTION_GROUPS = "logArchiveDestinationGroups";
    public static final String LOG_ARCHIVE_CONFIG = "logArchiveConfig";

    public static String getRcvConf(String dbUniqueName) {
        return FleetAgentContext.get(dbUniqueName).getTnsAdmin() + File.separatorChar + RCV_CONF;
    }

    public static void downloadAndUnzipConfigBundle(String endpoint, String protectedDatabaseId, String downloadDirectory) {
        RecoveryClientManager recoveryClientManager = new RecoveryClientManager(endpoint, null);
        try {
            String downloadPath = downloadDirectory + File.separatorChar + "config.zip";
            recoveryClientManager.getConfiguration(protectedDatabaseId, FetchProtectedDatabaseConfigurationDetails.ConfigurationType.All, downloadPath);
            Utils.unzipFile(downloadPath, downloadDirectory);
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause().getMessage().contains("Unknown resource CaBundle")) {
                String rcvConfPath = downloadDirectory + File.separator + RCV_CONF;
                recoveryClientManager.getConfiguration(protectedDatabaseId, FetchProtectedDatabaseConfigurationDetails.ConfigurationType.Rcvconf, rcvConfPath);
                recoveryClientManager.getConfiguration(protectedDatabaseId, FetchProtectedDatabaseConfigurationDetails.ConfigurationType.Tnsnames, downloadDirectory + File.separator + DBRS_NAMES);
            }
            throw e;
        }
    }

    public static boolean isTnsnamesOraEquals(Map<String, TNSEntry> entries1, Map<String, TNSEntry> entries2) {
        String value;
        for (String alias : entries1.keySet()) {
            value = entries1.get(alias).getConnectionDescriptor();
            if (entries2.containsKey(alias)) {
                if (entries2.get(alias).getConnectionDescriptor().equals(value)) continue;
                return false;
            }
            return false;
        }
        for (String alias : entries2.keySet()) {
            value = entries2.get(alias).getConnectionDescriptor();
            if (entries1.containsKey(alias)) {
                if (entries1.get(alias).getConnectionDescriptor().equals(value)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public static boolean updateTnsnamesOra(Database database) throws IOException {
        FleetAgentContext fleetAgentContext = database.getFleetAgentContext();
        ProtectedDatabaseCache cache = fleetAgentContext.getProtectedDatabaseCache();
        String tnsAdmin = fleetAgentContext.getTnsAdmin();
        String tnsnamesOraPath = String.join((CharSequence)File.separator, tnsAdmin, "tnsnames.ora");
        String dbrsnamesOraPath = String.join((CharSequence)File.separator, tnsAdmin, DBRS_NAMES);
        File dbrsNamesFile = new File(dbrsnamesOraPath);
        if (!dbrsNamesFile.exists()) {
            ConfigurationManager.downloadAndUnzipConfigBundle(cache.getEndpoint(), database.getOcid(), tnsAdmin);
        }
        TNSNames dbrsNames = TnsnamesHelper.getTnsNames(dbrsnamesOraPath);
        HashMap<String, TNSEntry> newTnsNamesEntries = new HashMap<String, TNSEntry>();
        boolean overwriteTnsnames = false;
        boolean isADE = System.getenv("ADE_VIEW_ROOT") != null;
        for (String alias : dbrsNames.nsNames()) {
            TNSEntry entry = dbrsNames.getTNSEntry(alias);
            String newAlias = ConfigurationManager.prependAliasWithDbUniqueName(database.getDbUniqueName(), alias);
            if (isADE) {
                String regex = "(fqdn1|fqdn2)\\.us\\.oracle\\.com";
                TNSEntry newEntry = TNSEntry.builder((String)entry.getConnectionDescriptor().replaceAll(regex, "127.0.0.1")).build();
                newTnsNamesEntries.put(newAlias.toUpperCase(), newEntry);
                continue;
            }
            newTnsNamesEntries.put(newAlias.toUpperCase(), dbrsNames.getTNSEntry(alias));
        }
        if (Files.exists(Paths.get(tnsnamesOraPath, new String[0]), new LinkOption[0])) {
            TNSNames currentTnsnames = TnsnamesHelper.getTnsNames(tnsnamesOraPath);
            HashMap<String, TNSEntry> currentTnsNamesEntries = new HashMap<String, TNSEntry>();
            for (String alias : currentTnsnames.nsNames()) {
                currentTnsNamesEntries.put(alias.toUpperCase(), currentTnsnames.getTNSEntry(alias));
            }
            overwriteTnsnames = !ConfigurationManager.isTnsnamesOraEquals(currentTnsNamesEntries, newTnsNamesEntries);
        } else {
            overwriteTnsnames = true;
        }
        if (overwriteTnsnames) {
            try {
                Utils.copyFileContent(tnsnamesOraPath, tnsnamesOraPath + ".prev");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            TnsnamesHelper.writeTnsNames(tnsnamesOraPath, newTnsNamesEntries);
        }
        return overwriteTnsnames;
    }

    public static void importRecoveryServiceCertificate(String dbUniqueName) {
        ProtectedDatabaseCache protectedDatabaseCache = RCVCommandBase.getProtectedDatabaseCache(dbUniqueName);
        String walletLocation = protectedDatabaseCache.getWalletLocation();
        Path certPath = ConfigurationManager.getCertificatePath(dbUniqueName);
        if (Files.exists(certPath, new LinkOption[0])) {
            OracleWallet wallet = WalletManager.createWallet(walletLocation);
            WalletManager.addCertificate(wallet, certPath);
        }
    }

    public static String getProtocolFromTnsnames(String tnsnamesPath) throws IOException {
        TNSNames tnsNames = TnsnamesHelper.getTnsNames(tnsnamesPath);
        Collection tnsEntries = tnsNames.tnsEntries();
        for (TNSEntry entry : tnsEntries) {
            String value = entry.getConnectionDescriptor();
            String regex = "(?i)\\(protocol=([^\\)]+)\\)";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(value);
            if (!matcher.find()) continue;
            return matcher.group(1);
        }
        return null;
    }

    public static Path getCertificatePath(String dbUniqueName) {
        return Paths.get(FleetAgentContext.get(dbUniqueName).getTnsAdmin() + File.separator + CERT_PEM, new String[0]);
    }

    public static void restoreLastConfiguration(String tnsAdmin) throws IOException {
        String goodTnsNames = String.join((CharSequence)File.separator, tnsAdmin, "tnsnames.ora.good");
        String tnsNames = String.join((CharSequence)File.separator, tnsAdmin, "tnsnames.ora");
        Files.move(Paths.get(goodTnsNames, new String[0]), Paths.get(tnsNames, new String[0]), new CopyOption[0]);
    }

    private static JsonNode readJson(ObjectMapper objectMapper, String rcvConfFile) {
        try {
            return objectMapper.readTree(new File(rcvConfFile));
        }
        catch (IOException e) {
            throw Result.conmanReadConfigException(rcvConfFile, e);
        }
    }

    public static String getCatalogAlias(String dbUniqueName) throws IOException {
        String networkDirectory = FleetAgentContext.get(dbUniqueName).getTnsAdmin();
        return ConfigurationManager.getCatalogAliasFromRcvConf(networkDirectory + File.separator + RCV_CONF);
    }

    public static String getCatalogAliasFromRcvConf(String rcvConfFile) {
        ObjectMapper objectMapper;
        JsonNode jsonNode;
        if (Files.exists(Paths.get(rcvConfFile, new String[0]), new LinkOption[0]) && (jsonNode = ConfigurationManager.readJson(objectMapper = new ObjectMapper(), rcvConfFile)).has("schema") && jsonNode.has("version")) {
            int schema = jsonNode.get("schema").asInt();
            int version = jsonNode.get("version").asInt();
            if (schema == 1 && version == 1) {
                if (jsonNode.has("actions") && jsonNode.path("actions").has("rmanCatalogConnection")) {
                    return jsonNode.path("actions").path("rmanCatalogConnection").get(0).path("payload").get(0).asText();
                }
            } else if (schema == 1 && version > 1 && jsonNode.has("currentState") && jsonNode.path("currentState").has("rmanCatalogConnection")) {
                return jsonNode.path("currentState").get("rmanCatalogConnection").asText();
            }
        }
        return "DBRS";
    }

    public static List<String> getWalletEntries(String dbUniqueName) {
        return ConfigurationManager.getWalletEntriesFromRcvConf(ConfigurationManager.getRcvConf(dbUniqueName));
    }

    public static List<String> getWalletEntriesFromRcvConf(String rcvConfFile) {
        ArrayList<String> aliases;
        block4: {
            JsonNode tnsAliasesNode;
            JsonNode walletEntriesNode;
            int version;
            int schema;
            JsonNode jsonNode;
            block5: {
                JsonNode walletEntriesNode2;
                ObjectMapper objectMapper;
                aliases = new ArrayList<String>();
                if (!Files.exists(Paths.get(rcvConfFile, new String[0]), new LinkOption[0]) || !(jsonNode = ConfigurationManager.readJson(objectMapper = new ObjectMapper(), rcvConfFile)).has("schema") || !jsonNode.has("version")) break block4;
                schema = jsonNode.get("schema").asInt();
                version = jsonNode.get("version").asInt();
                if (schema != 1 || version != 1) break block5;
                if (!jsonNode.has("actions") || !jsonNode.path("actions").has("walletEntries") || !(walletEntriesNode2 = jsonNode.path("actions").path("walletEntries")).isArray()) break block4;
                for (JsonNode entry : walletEntriesNode2) {
                    JsonNode payloadNode;
                    if (!entry.has("operationType") || !entry.get("operationType").asText().equalsIgnoreCase("ADD") || !entry.has("payload") || !(payloadNode = entry.get("payload")).isArray()) continue;
                    for (JsonNode alias : payloadNode) {
                        aliases.add(alias.asText());
                    }
                }
                break block4;
            }
            if (schema == 1 && version > 1 && jsonNode.has("currentState") && jsonNode.path("currentState").has("walletEntries") && (walletEntriesNode = jsonNode.path("currentState").path("walletEntries")).has("tnsAliases") && (tnsAliasesNode = walletEntriesNode.path("tnsAliases")).isArray()) {
                for (JsonNode alias : tnsAliasesNode) {
                    aliases.add(alias.asText());
                }
            }
        }
        return aliases;
    }

    public static String getVpcUserName(String rcvConfFile) {
        ObjectMapper objectMapper;
        JsonNode jsonNode;
        if (Files.exists(Paths.get(rcvConfFile, new String[0]), new LinkOption[0]) && (jsonNode = ConfigurationManager.readJson(objectMapper = new ObjectMapper(), rcvConfFile)).has("schema") && jsonNode.has("version")) {
            JsonNode walletEntriesNode;
            int schema = jsonNode.get("schema").asInt();
            int version = jsonNode.get("version").asInt();
            if (schema == 1 && version > 1 && jsonNode.has("actions") && jsonNode.path("actions").has("walletEntries") && (walletEntriesNode = jsonNode.path("actions").path("walletEntries")).has("vpcUser")) {
                return walletEntriesNode.get("vpcUser").asText();
            }
        }
        return null;
    }

    public static List<String> getLogArchiveConfig(String rcvConfFile) {
        ArrayList<String> destinationNames;
        block3: {
            JsonNode configsNode;
            int version;
            int schema;
            JsonNode jsonNode;
            block4: {
                JsonNode payloadNode;
                JsonNode firstConfigNode;
                JsonNode configsNode2;
                ObjectMapper objectMapper;
                destinationNames = new ArrayList<String>();
                if (!Files.exists(Paths.get(rcvConfFile, new String[0]), new LinkOption[0]) || !(jsonNode = ConfigurationManager.readJson(objectMapper = new ObjectMapper(), rcvConfFile)).has("schema") || !jsonNode.has("version")) break block3;
                schema = jsonNode.get("schema").asInt();
                version = jsonNode.get("version").asInt();
                if (schema != 1 || version != 1) break block4;
                if (!jsonNode.has("actions") || !jsonNode.path("actions").has(LOG_ARCHIVE_CONFIG) || !(configsNode2 = jsonNode.path("actions").path(LOG_ARCHIVE_CONFIG)).isArray() || !configsNode2.iterator().hasNext() || !(firstConfigNode = configsNode2.get(0)).has("payload") || !(payloadNode = firstConfigNode.path("payload")).isArray()) break block3;
                for (JsonNode node : payloadNode) {
                    destinationNames.add(node.asText());
                }
                break block3;
            }
            if (schema == 1 && version > 1 && jsonNode.has("currentState") && jsonNode.path("currentState").has(LOG_ARCHIVE_CONFIG) && (configsNode = jsonNode.path("currentState").path(LOG_ARCHIVE_CONFIG)).isArray()) {
                for (JsonNode node : configsNode) {
                    destinationNames.add(node.asText());
                }
            }
        }
        return destinationNames;
    }

    public static List<LogArchiveDestination> getLogArchiveDestinationGroups(String rcvConfFile) throws IOException {
        ArrayList<LogArchiveDestination> destinations;
        block3: {
            JsonNode firstGroupNode;
            JsonNode groupsNode;
            int version;
            int schema;
            ObjectMapper objectMapper;
            JsonNode jsonNode;
            block4: {
                JsonNode firstPayloadNode;
                JsonNode payloadNode;
                JsonNode firstGroupNode2;
                JsonNode groupsNode2;
                destinations = new ArrayList<LogArchiveDestination>();
                if (!Files.exists(Paths.get(rcvConfFile, new String[0]), new LinkOption[0]) || !(jsonNode = ConfigurationManager.readJson(objectMapper = new ObjectMapper(), rcvConfFile)).has("schema") || !jsonNode.has("version")) break block3;
                schema = jsonNode.get("schema").asInt();
                version = jsonNode.get("version").asInt();
                if (schema != 1 || version != 1) break block4;
                if (!jsonNode.has("actions") || !jsonNode.path("actions").has(LOG_ARCHIVE_DESTION_GROUPS) || !(groupsNode2 = jsonNode.path("actions").path(LOG_ARCHIVE_DESTION_GROUPS)).isArray() || !groupsNode2.iterator().hasNext() || !(firstGroupNode2 = groupsNode2.get(0)).has("payload") || !(payloadNode = firstGroupNode2.path("payload")).isArray() || !payloadNode.iterator().hasNext() || !(firstPayloadNode = payloadNode.get(0)).isArray()) break block3;
                for (JsonNode destinationNode : firstPayloadNode) {
                    LogArchiveDestination destination = (LogArchiveDestination)objectMapper.readValue(destinationNode.toString(), LogArchiveDestination.class);
                    destination.setGroup(1);
                    destinations.add(destination);
                }
                break block3;
            }
            if (schema == 1 && version > 1 && jsonNode.has("currentState") && jsonNode.path("currentState").has(LOG_ARCHIVE_DESTION_GROUPS) && (groupsNode = jsonNode.path("currentState").path(LOG_ARCHIVE_DESTION_GROUPS)).isArray() && groupsNode.iterator().hasNext() && (firstGroupNode = groupsNode.get(0)).isArray() && firstGroupNode.iterator().hasNext()) {
                for (JsonNode destinationNode : firstGroupNode) {
                    LogArchiveDestination destination = (LogArchiveDestination)objectMapper.readValue(destinationNode.toString(), LogArchiveDestination.class);
                    destination.setGroup(1);
                    destinations.add(destination);
                }
            }
        }
        return destinations;
    }

    public static String prependAliasWithDbUniqueName(String dbUniqueName, String alias) {
        return dbUniqueName + "_" + alias;
    }
}

