/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.extension.rcv.commands.RCVCommandBase;
import oracle.dbtools.extension.rcv.commands.RcvMessages;
import oracle.dbtools.extension.rcv.models.ConnectString;
import oracle.dbtools.extension.rcv.models.RMANScript;
import oracle.dbtools.extension.rcv.models.database.Database;
import oracle.dbtools.extension.rcv.models.database.DatabaseConfig;
import oracle.dbtools.extension.rcv.models.database.FleetAgentContext;
import oracle.dbtools.extension.rcv.models.database.ProtectedDatabaseCache;
import oracle.dbtools.extension.rcv.models.systemcommands.RMANCommand;
import oracle.dbtools.extension.rcv.models.systemcommands.SystemCommand;
import oracle.dbtools.extension.rcv.utils.ScriptFactory;
import oracle.dbtools.extension.rcv.utils.Utils;
import oracle.dbtools.extension.rcv.workflows.Result;

public class BackupManager {
    private static final String REGISTER_SCRIPT = "register.rman";
    private static final String INCREMENTAL_BACKUP_SCRIPT = "incremental_backup.rman";
    private static final String BACKUP_ARCHIVED_REDO_LOG_SCRIPT = "backup_archived_redo_logs.rman";
    private static final String BACKUP_CONTROLFILE_SCRIPT = "backup_controlfile.rman";
    private static final String BACKUP_SPFILE_SCRIPT = "backup_spfile.rman";

    public static String getRMANVersion() throws IOException {
        String fileName = Objects.requireNonNull(RCVCommandBase.getAgentBaseDirectory()) + File.separator + "version.rman";
        File f = new File(fileName);
        if (f.exists()) {
            if (f.length() != 0L) {
                Files.delete(f.toPath());
                f.createNewFile();
            }
        } else {
            f.createNewFile();
        }
        RMANCommand rmanCommand = new RMANCommand.Builder(null, null, new RMANScript(fileName)).build();
        SystemCommand.ExecutionResult result = rmanCommand.execute();
        Pattern version = Pattern.compile("Version\\s+((\\d+\\.)+\\d+)");
        Matcher matcher = version.matcher(result.getOutput());
        boolean matchFound = matcher.find();
        if (matchFound) {
            return matcher.group(1);
        }
        return null;
    }

    public static SystemCommand.ExecutionResult registerDatabase(Database database, Logger logger) throws IOException {
        String dbUniqueName = database.getDbUniqueName();
        FleetAgentContext fleetAgentContext = FleetAgentContext.get(database.getDbUniqueName());
        RMANScript rmanScript = ScriptFactory.generateRegisterDatabaseScript(fleetAgentContext.getScriptsDirectory());
        ConnectString target = new ConnectString.Builder().build();
        ConnectString catalog = new ConnectString.Builder(fleetAgentContext.getProtectedDatabaseCache().getCredentialAlias()).build();
        RMANCommand rmanCommand = new RMANCommand.Builder(target, catalog, rmanScript).tnsAdmin(fleetAgentContext.getTnsAdmin()).oracleSid(database.getDatabaseMetadataCache().getOracleSid()).oracleHome(DatabaseConfig.getOracleHome(dbUniqueName)).logger(logger).append(true).build();
        return rmanCommand.execute();
    }

    public static SystemCommand.ExecutionResult backupArchivedRedoLogs(Database database, String logFile, boolean checkConfig) throws IOException {
        FleetAgentContext fleetAgentContext = database.getFleetAgentContext();
        RMANScript rmanScript = ScriptFactory.generateArchivedRedoLogsBackupScript(fleetAgentContext.getScriptsDirectory());
        ProtectedDatabaseCache protectedDatabaseCache = fleetAgentContext.getProtectedDatabaseCache();
        Map<String, String> backupScriptArgs = Map.of("1", protectedDatabaseCache.getLibraLocation(), "2", protectedDatabaseCache.getWalletLocation(), "3", fleetAgentContext.getProtectedDatabaseCache().getCredentialAlias());
        ConnectString target = new ConnectString.Builder().build();
        ConnectString catalog = new ConnectString.Builder(fleetAgentContext.getProtectedDatabaseCache().getCredentialAlias()).build();
        RMANCommand rmanCommand = new RMANCommand.Builder(target, catalog, rmanScript).args(backupScriptArgs).tnsAdmin(fleetAgentContext.getTnsAdmin()).logFile(logFile).append(true).build();
        return rmanCommand.execute();
    }

    public static SystemCommand.ExecutionResult backupSpfile(Database database, String logFile, boolean checkConfig) throws IOException {
        FleetAgentContext fleetAgentContext = database.getFleetAgentContext();
        ProtectedDatabaseCache protectedDatabaseCache = fleetAgentContext.getProtectedDatabaseCache();
        RMANScript rmanScript = ScriptFactory.generateSpfileBackupScript(fleetAgentContext.getScriptsDirectory());
        Map<String, String> backupScriptArgs = Map.of("1", protectedDatabaseCache.getLibraLocation(), "2", protectedDatabaseCache.getWalletLocation(), "3", protectedDatabaseCache.getCredentialAlias());
        ConnectString target = new ConnectString.Builder().build();
        ConnectString catalog = new ConnectString.Builder(protectedDatabaseCache.getCredentialAlias()).build();
        RMANCommand rmanCommand = new RMANCommand.Builder(target, catalog, rmanScript).args(backupScriptArgs).tnsAdmin(fleetAgentContext.getTnsAdmin()).logFile(logFile).append(true).build();
        return rmanCommand.execute();
    }

    public static SystemCommand.ExecutionResult backupControlFile(Database database, String logFile) {
        RMANScript rmanScript;
        FleetAgentContext fleetAgentContext = database.getFleetAgentContext();
        ProtectedDatabaseCache protectedDatabaseCache = fleetAgentContext.getProtectedDatabaseCache();
        try {
            rmanScript = ScriptFactory.generateControlFileBackupScript(fleetAgentContext.getScriptsDirectory());
        }
        catch (IOException e) {
            throw Result.fileWriteException(RcvMessages.format("FILE_CREATE_RMAN_SCRIPT_ERROR_MSG", fleetAgentContext.getScriptsDirectory()), e);
        }
        Map<String, String> backupScriptArgs = Map.of("1", protectedDatabaseCache.getLibraLocation(), "2", protectedDatabaseCache.getWalletLocation(), "3", protectedDatabaseCache.getCredentialAlias());
        ConnectString target = new ConnectString.Builder().build();
        ConnectString catalog = new ConnectString.Builder(protectedDatabaseCache.getCredentialAlias()).build();
        RMANCommand rmanCommand = new RMANCommand.Builder(target, catalog, rmanScript).args(backupScriptArgs).logFile(logFile).oracleSid(database.getDatabaseMetadataCache().getOracleSid()).oracleHome(DatabaseConfig.getOracleHome(database.getDbUniqueName())).tnsAdmin(fleetAgentContext.getTnsAdmin()).append(true).build();
        return rmanCommand.execute();
    }

    public static String generateBackupTag() {
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String timestamp = now.format(formatter);
        return String.format("rcv-incremental-%s.%s", timestamp, Utils.generateRandomString(3));
    }
}

