/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.oci;

import com.oracle.bmc.ConfigFileReader;
import com.oracle.bmc.Region;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ConfigFileAuthenticationDetailsProvider;
import com.oracle.bmc.database.model.DatabaseSummary;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.identity.IdentityClient;
import com.oracle.bmc.identity.model.Compartment;
import com.oracle.bmc.identity.requests.ListCompartmentsRequest;
import com.oracle.bmc.identity.responses.ListCompartmentsResponse;
import com.oracle.bmc.model.BmcException;
import com.oracle.bmc.recovery.DatabaseRecoveryClient;
import com.oracle.bmc.recovery.model.ChangeProtectedDatabaseCompartmentDetails;
import com.oracle.bmc.recovery.model.CreateProtectedDatabaseDetails;
import com.oracle.bmc.recovery.model.CreateRecoveryServiceSubnetDetails;
import com.oracle.bmc.recovery.model.DeletionSchedule;
import com.oracle.bmc.recovery.model.FetchProtectedDatabaseConfigurationDetails;
import com.oracle.bmc.recovery.model.LifecycleState;
import com.oracle.bmc.recovery.model.ProtectedDatabase;
import com.oracle.bmc.recovery.model.ProtectedDatabaseCollection;
import com.oracle.bmc.recovery.model.ProtectedDatabaseSummary;
import com.oracle.bmc.recovery.model.ProtectionPolicy;
import com.oracle.bmc.recovery.model.ProtectionPolicySummary;
import com.oracle.bmc.recovery.model.RecoveryServiceSubnet;
import com.oracle.bmc.recovery.model.RecoveryServiceSubnetSummary;
import com.oracle.bmc.recovery.model.UpdateProtectedDatabaseDetails;
import com.oracle.bmc.recovery.model.WorkRequest;
import com.oracle.bmc.recovery.requests.CancelProtectedDatabaseDeletionRequest;
import com.oracle.bmc.recovery.requests.ChangeProtectedDatabaseCompartmentRequest;
import com.oracle.bmc.recovery.requests.ChangeProtectionPolicyCompartmentRequest;
import com.oracle.bmc.recovery.requests.ChangeRecoveryServiceSubnetCompartmentRequest;
import com.oracle.bmc.recovery.requests.CreateProtectedDatabaseRequest;
import com.oracle.bmc.recovery.requests.CreateProtectionPolicyRequest;
import com.oracle.bmc.recovery.requests.CreateRecoveryServiceSubnetRequest;
import com.oracle.bmc.recovery.requests.DeleteProtectedDatabaseRequest;
import com.oracle.bmc.recovery.requests.DeleteProtectionPolicyRequest;
import com.oracle.bmc.recovery.requests.FetchProtectedDatabaseConfigurationRequest;
import com.oracle.bmc.recovery.requests.GetProtectedDatabaseRequest;
import com.oracle.bmc.recovery.requests.GetProtectionPolicyRequest;
import com.oracle.bmc.recovery.requests.GetRecoveryServiceSubnetRequest;
import com.oracle.bmc.recovery.requests.GetWorkRequestRequest;
import com.oracle.bmc.recovery.requests.ListProtectedDatabasesRequest;
import com.oracle.bmc.recovery.requests.ListProtectionPoliciesRequest;
import com.oracle.bmc.recovery.requests.ListRecoveryServiceSubnetsRequest;
import com.oracle.bmc.recovery.requests.UpdateProtectedDatabaseRequest;
import com.oracle.bmc.recovery.requests.UpdateProtectionPolicyRequest;
import com.oracle.bmc.recovery.requests.UpdateRecoveryServiceSubnetRequest;
import com.oracle.bmc.recovery.responses.CancelProtectedDatabaseDeletionResponse;
import com.oracle.bmc.recovery.responses.ChangeProtectedDatabaseCompartmentResponse;
import com.oracle.bmc.recovery.responses.ChangeProtectionPolicyCompartmentResponse;
import com.oracle.bmc.recovery.responses.ChangeRecoveryServiceSubnetCompartmentResponse;
import com.oracle.bmc.recovery.responses.CreateProtectedDatabaseResponse;
import com.oracle.bmc.recovery.responses.CreateProtectionPolicyResponse;
import com.oracle.bmc.recovery.responses.CreateRecoveryServiceSubnetResponse;
import com.oracle.bmc.recovery.responses.DeleteProtectedDatabaseResponse;
import com.oracle.bmc.recovery.responses.DeleteProtectionPolicyResponse;
import com.oracle.bmc.recovery.responses.FetchProtectedDatabaseConfigurationResponse;
import com.oracle.bmc.recovery.responses.GetProtectedDatabaseResponse;
import com.oracle.bmc.recovery.responses.GetProtectionPolicyResponse;
import com.oracle.bmc.recovery.responses.GetRecoveryServiceSubnetResponse;
import com.oracle.bmc.recovery.responses.ListProtectedDatabasesResponse;
import com.oracle.bmc.recovery.responses.ListProtectionPoliciesResponse;
import com.oracle.bmc.recovery.responses.ListRecoveryServiceSubnetsResponse;
import com.oracle.bmc.recovery.responses.UpdateProtectedDatabaseResponse;
import com.oracle.bmc.recovery.responses.UpdateProtectionPolicyResponse;
import com.oracle.bmc.recovery.responses.UpdateRecoveryServiceSubnetResponse;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import oracle.dbtools.extension.rcv.commands.RCVCommandBase;
import oracle.dbtools.extension.rcv.commands.RcvMessages;
import oracle.dbtools.extension.rcv.models.GlobalMetadata;
import oracle.dbtools.extension.rcv.models.OCIAuthentication;
import oracle.dbtools.extension.rcv.models.database.Database;
import oracle.dbtools.extension.rcv.oci.DatabaseClientManager;
import oracle.dbtools.extension.rcv.oci.OCIUtils;
import oracle.dbtools.extension.rcv.utils.DatabaseUtils;
import oracle.dbtools.extension.rcv.workflows.Result;

public class RecoveryClientManager {
    private static ConcurrentMap<String, DatabaseRecoveryClient> clients = new ConcurrentHashMap<String, DatabaseRecoveryClient>(){};
    private DatabaseRecoveryClient client;
    private static AbstractAuthenticationDetailsProvider provider;
    private static String defaultEndpoint;
    private Logger logger;

    public RecoveryClientManager(OCIAuthentication authentication, String endpoint, Logger logger) {
        if (endpoint == null) {
            endpoint = RecoveryClientManager.getDefaultEndpoint();
        }
        if (!clients.containsKey(endpoint)) {
            provider = OCIUtils.getAuthenticationDetailsProvider(authentication);
            this.client = DatabaseRecoveryClient.builder().build(provider);
            this.client.setEndpoint(endpoint);
            clients.put(endpoint, this.client);
        } else {
            this.client = (DatabaseRecoveryClient)clients.get(endpoint);
        }
        this.logger = logger;
    }

    public RecoveryClientManager() {
        this(RecoveryClientManager.getDefaultEndpoint(), null);
    }

    public RecoveryClientManager(String endpoint, Logger logger) {
        this(GlobalMetadata.load().getAuthentication(), endpoint, logger);
    }

    public RecoveryClientManager(Logger logger) {
        this.logger = logger;
        GlobalMetadata globalMetadata = GlobalMetadata.load();
        String endpoint = RecoveryClientManager.getDefaultEndpoint();
        if (!clients.containsKey(endpoint)) {
            provider = OCIUtils.getAuthenticationDetailsProvider(globalMetadata.getAuthentication());
            this.client = DatabaseRecoveryClient.builder().build(provider);
            this.client.setEndpoint(endpoint);
            clients.put(endpoint, this.client);
        } else {
            this.client = (DatabaseRecoveryClient)clients.get(endpoint);
        }
    }

    public static String getDefaultEndpoint() {
        if (defaultEndpoint == null) {
            GlobalMetadata globalMetadata = GlobalMetadata.load();
            if (globalMetadata.getSystemType().equals("OCI")) {
                defaultEndpoint = OCIUtils.getRecoveryServiceEndpoint();
            } else {
                OCIAuthentication auth = globalMetadata.getAuthentication();
                String configFilePath = auth.getConfigFile();
                if (configFilePath == null) {
                    String error = "Failed to find oci config file. Please provide it using rcv configure authentication. If your database client is in OCI (not on-premises), you can also use resource principal as an authentication method by running 'rcv configure authentication -method resource_principal'.";
                    throw new RuntimeException(error);
                }
                try {
                    ConfigFileReader.ConfigFile configFile = ConfigFileReader.parse((String)configFilePath);
                    Region region = ConfigFileAuthenticationDetailsProvider.getRegionFromConfigFile((ConfigFileReader.ConfigFile)configFile);
                    if (region == null) {
                        throw Result.metadataGetServiceEndpointException(auth.getConfigFile());
                    }
                    defaultEndpoint = OCIUtils.getRecoveryServiceEndpoint(region.getRegionId());
                }
                catch (IOException e) {
                    throw Result.fileReadError(RcvMessages.format("FILE_READ_METADATA_AUTH_CONFIG_ERROR_MSG", auth.getConfigFile()), e);
                }
            }
        }
        return defaultEndpoint;
    }

    private void log(Level level, String message) {
        if (this.logger != null) {
            this.logger.log(level, message);
        } else if (level.equals(Level.INFO)) {
            System.out.println(message);
        }
    }

    public CreateProtectedDatabaseResponse onboardProtectedDatabase(CreateProtectedDatabaseDetails database, boolean dryRun) {
        CreateProtectedDatabaseRequest createProtectedDatabaseRequest = CreateProtectedDatabaseRequest.builder().createProtectedDatabaseDetails(database).opcDryRun(Boolean.valueOf(dryRun)).build();
        String requestString = createProtectedDatabaseRequest.toString();
        requestString = requestString.replaceAll("password=[^\\s+]*", "password=***");
        this.log(Level.FINEST, requestString);
        CreateProtectedDatabaseResponse response = this.client.createProtectedDatabase(createProtectedDatabaseRequest);
        this.log(Level.FINEST, String.valueOf(response));
        return response;
    }

    public UpdateProtectedDatabaseResponse updateProtectedDatabase(UpdateProtectedDatabaseDetails details, String protectedDatabaseId) {
        UpdateProtectedDatabaseRequest request = UpdateProtectedDatabaseRequest.builder().body$(details).protectedDatabaseId(protectedDatabaseId).build();
        String requestString = request.toString();
        requestString = requestString.replaceAll("password=[^\\s+]*", "password=***");
        this.log(Level.FINEST, requestString);
        UpdateProtectedDatabaseResponse response = this.client.updateProtectedDatabase(request);
        this.log(Level.FINEST, String.valueOf(response));
        return response;
    }

    public FetchProtectedDatabaseConfigurationResponse getConfiguration(String protectedDatabaseId, FetchProtectedDatabaseConfigurationDetails.ConfigurationType type, String fileName) {
        FetchProtectedDatabaseConfigurationResponse response;
        FetchProtectedDatabaseConfigurationDetails fetchProtectedDatabaseConfigurationDetails = FetchProtectedDatabaseConfigurationDetails.builder().configurationType(type).build();
        FetchProtectedDatabaseConfigurationRequest fetchProtectedDatabaseConfigurationRequest = FetchProtectedDatabaseConfigurationRequest.builder().protectedDatabaseId(protectedDatabaseId).fetchProtectedDatabaseConfigurationDetails(fetchProtectedDatabaseConfigurationDetails).build();
        try {
            this.log(Level.FINEST, String.valueOf(fetchProtectedDatabaseConfigurationRequest));
            response = this.client.fetchProtectedDatabaseConfiguration(fetchProtectedDatabaseConfigurationRequest);
            this.log(Level.FINEST, String.valueOf(response));
        }
        catch (Exception e) {
            throw Result.rcvFetchProtectedDatabaseConfigurationException(protectedDatabaseId, type.toString(), e);
        }
        Path path = Paths.get(fileName, new String[0]);
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        catch (IOException ex) {
            this.log(Level.INFO, ex.getMessage());
            return null;
        }
        try {
            File targetFile = new File(fileName);
            if (!targetFile.exists()) {
                targetFile.createNewFile();
            } else {
                targetFile.delete();
                targetFile.createNewFile();
            }
            InputStream inputStream = response.getInputStream();
            try (FileOutputStream outputStream = new FileOutputStream(targetFile, false);){
                int read;
                byte[] bytes = new byte[8192];
                while ((read = inputStream.read(bytes)) != -1) {
                    outputStream.write(bytes, 0, read);
                }
            }
        }
        catch (IOException ex) {
            this.log(Level.INFO, ex.getMessage());
            return null;
        }
        return response;
    }

    public ProtectedDatabase waitForProtectedDatabaseUpdate(ProtectedDatabase protectedDatabase, int waitTime, int waitInterval) {
        String protectedDatabaseId = protectedDatabase.getId();
        return this.waitForProtectedDatabaseUpdate(protectedDatabaseId, waitTime, waitInterval);
    }

    public ProtectedDatabase waitForProtectedDatabaseUpdate(String protectedDatabaseId, int waitTime, int waitInterval) {
        GetProtectedDatabaseRequest request = GetProtectedDatabaseRequest.builder().protectedDatabaseId(protectedDatabaseId).build();
        return this.waitForProtectedDatabaseUpdate(request, waitTime, waitInterval);
    }

    public ProtectedDatabase waitForProtectedDatabaseUpdate(GetProtectedDatabaseRequest request, int waitTime, int waitInterval) {
        this.log(Level.FINEST, String.valueOf(request));
        ProtectedDatabase protectedDatabase = this.client.getProtectedDatabase(request).getProtectedDatabase();
        LifecycleState state = protectedDatabase.getLifecycleState();
        GetProtectedDatabaseResponse response = null;
        for (int time = 0; time < waitTime && (state.equals((Object)LifecycleState.Creating) || state.equals((Object)LifecycleState.Deleting) || state.equals((Object)LifecycleState.Updating)); time += waitInterval) {
            try {
                Thread.sleep(waitInterval * 1000);
            }
            catch (InterruptedException e) {
                throw Result.rcvInterruptedWaitException(RcvMessages.format("RCVS_INTERRUPTED_WAIT_EXCEPTION_PD_MSG", new Object[0]), e);
            }
            response = this.client.getProtectedDatabase(request);
            protectedDatabase = response.getProtectedDatabase();
            state = protectedDatabase.getLifecycleState();
        }
        if (response != null) {
            this.log(Level.FINEST, String.valueOf(response));
        }
        return protectedDatabase;
    }

    public List<ProtectedDatabase> waitForWorkRequestToFinish(String workRequestId, int waitTime, int waitInterval) {
        ArrayList<ProtectedDatabase> databases = new ArrayList<ProtectedDatabase>();
        GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(workRequestId).build();
        WorkRequest workRequest = this.client.getWorkRequest(getWorkRequestRequest).getWorkRequest();
        workRequest.getResources().stream().map(resource -> resource.getIdentifier()).forEach(id -> {
            ProtectedDatabase db = this.waitForProtectedDatabaseUpdate((String)id, waitTime, waitInterval);
            databases.add(db);
        });
        return databases;
    }

    public ChangeProtectedDatabaseCompartmentResponse changeProtectedDatabaseCompartment(ChangeProtectedDatabaseCompartmentRequest request) {
        return this.client.changeProtectedDatabaseCompartment(request);
    }

    public WorkRequest getWorkRequest(String workRequestId) {
        GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(workRequestId).build();
        return this.client.getWorkRequest(getWorkRequestRequest).getWorkRequest();
    }

    public List<ProtectedDatabaseSummary> filterProtectedDatabasesByDatabaseId(String compartmentId, String dbUniqueName, String databaseId) {
        ArrayList<ProtectedDatabaseSummary> matches = new ArrayList<ProtectedDatabaseSummary>();
        ListProtectedDatabasesRequest request = ListProtectedDatabasesRequest.builder().compartmentId(compartmentId).build();
        ListProtectedDatabasesResponse response = this.client.listProtectedDatabases(request);
        ProtectedDatabaseCollection collection = response.getProtectedDatabaseCollection();
        if (collection == null) {
            return new ArrayList<ProtectedDatabaseSummary>();
        }
        List summaryList = collection.getItems();
        for (ProtectedDatabaseSummary summary : summaryList) {
            LifecycleState state = summary.getLifecycleState();
            String dbId = summary.getDatabaseId();
            if (state.equals((Object)LifecycleState.Deleted) || state.equals((Object)LifecycleState.Deleting) || dbId == null || !dbId.equals(databaseId) || !summary.getDbUniqueName().equals(dbUniqueName)) continue;
            matches.add(summary);
        }
        return matches;
    }

    public ProtectedDatabase getProtectedDatabase(String protectedDatabaseId) {
        GetProtectedDatabaseRequest request = GetProtectedDatabaseRequest.builder().protectedDatabaseId(protectedDatabaseId).build();
        return this.client.getProtectedDatabase(request).getProtectedDatabase();
    }

    public DeleteProtectedDatabaseResponse removeProtectedDatabase(String protectedDatabaseId, DeletionSchedule deletionSchedule) {
        DeleteProtectedDatabaseRequest request = DeleteProtectedDatabaseRequest.builder().protectedDatabaseId(protectedDatabaseId).deletionSchedule(deletionSchedule).build();
        return this.client.deleteProtectedDatabase(request);
    }

    public ProtectedDatabase waitForRemoveProtectedDatabase(String protectedDatabaseId, DeletionSchedule deletionSchedule) {
        ProtectedDatabase db = this.getProtectedDatabase(protectedDatabaseId);
        LifecycleState state = db.getLifecycleState();
        if (state.equals((Object)LifecycleState.Active)) {
            DeleteProtectedDatabaseResponse response = this.removeProtectedDatabase(protectedDatabaseId, deletionSchedule);
            this.log(Level.FINE, response.getOpcRequestId());
            this.log(Level.FINE, response.getOpcWorkRequestId());
        }
        db = this.waitForProtectedDatabaseUpdate(protectedDatabaseId, 300, 5);
        return db;
    }

    public List<RecoveryServiceSubnetSummary> getRecoveryServiceSubnets(ListRecoveryServiceSubnetsRequest request) {
        ListRecoveryServiceSubnetsResponse response = this.client.listRecoveryServiceSubnets(request);
        return response.getRecoveryServiceSubnetCollection().getItems();
    }

    public RecoveryServiceSubnet getRecoveryServiceSubnet(String id) {
        GetRecoveryServiceSubnetRequest request = GetRecoveryServiceSubnetRequest.builder().recoveryServiceSubnetId(id).build();
        GetRecoveryServiceSubnetResponse response = this.client.getRecoveryServiceSubnet(request);
        return response.getRecoveryServiceSubnet();
    }

    public RecoveryServiceSubnet getRecoveryServiceSubnet(GetRecoveryServiceSubnetRequest request) {
        this.log(Level.FINEST, String.valueOf(request));
        try {
            GetRecoveryServiceSubnetResponse response = this.client.getRecoveryServiceSubnet(request);
            this.log(Level.FINEST, String.valueOf(response));
            return response.getRecoveryServiceSubnet();
        }
        catch (Exception e) {
            throw Result.rcvGetRecoveryServiceSubnetException(request.getRecoveryServiceSubnetId(), e);
        }
    }

    public RecoveryServiceSubnet createRecoveryServiceSubnet(String vcnId, String compartmentId, String displayName, String subnetId) {
        CreateRecoveryServiceSubnetResponse response;
        CreateRecoveryServiceSubnetDetails details = CreateRecoveryServiceSubnetDetails.builder().vcnId(vcnId).compartmentId(compartmentId).displayName(displayName).subnetId(subnetId).build();
        CreateRecoveryServiceSubnetRequest request = CreateRecoveryServiceSubnetRequest.builder().body$(details).build();
        try {
            this.log(Level.FINEST, String.valueOf(request));
            response = this.client.createRecoveryServiceSubnet(request);
        }
        catch (Exception e) {
            throw Result.rcvCreateRecoveryServiceSubnetException(compartmentId, vcnId, subnetId, e);
        }
        this.log(Level.FINEST, String.valueOf(response));
        return response.getRecoveryServiceSubnet();
    }

    public RecoveryServiceSubnet waitForRecoveryServiceSubnetUpdate(RecoveryServiceSubnet subnet, int waitTime, int waitInterval) {
        String id = subnet.getId();
        return this.waitForRecoveryServiceSubnetUpdate(id, waitTime, waitInterval);
    }

    public RecoveryServiceSubnet waitForRecoveryServiceSubnetUpdate(String recoveryServiceSubnetId, int waitTime, int waitInterval) {
        GetRecoveryServiceSubnetRequest request = GetRecoveryServiceSubnetRequest.builder().recoveryServiceSubnetId(recoveryServiceSubnetId).build();
        return this.waitForRecoveryServiceSubnetUpdate(request, waitTime, waitInterval);
    }

    public RecoveryServiceSubnet waitForRecoveryServiceSubnetUpdate(GetRecoveryServiceSubnetRequest request, int waitTime, int waitInterval) {
        RecoveryServiceSubnet subnet = this.getRecoveryServiceSubnet(request);
        LifecycleState state = subnet.getLifecycleState();
        for (int time = 0; time < waitTime && (state.equals((Object)LifecycleState.Creating) || state.equals((Object)LifecycleState.Deleting) || state.equals((Object)LifecycleState.Updating)); time += waitInterval) {
            try {
                Thread.sleep(waitInterval * 1000);
            }
            catch (InterruptedException e) {
                throw Result.rcvInterruptedWaitException(RcvMessages.format("RCVS_INTERRUPTED_WAIT_EXCEPTION_RSS_MSG", new Object[0]), e);
            }
            subnet = this.getRecoveryServiceSubnet(request);
            state = subnet.getLifecycleState();
        }
        return subnet;
    }

    public LifecycleState waitForResourceUpdate(int waitTime, int waitInterval, Supplier<LifecycleState> getResource) {
        LifecycleState state = getResource.get();
        for (int time = 0; time < waitTime && (state.equals((Object)LifecycleState.Creating) || state.equals((Object)LifecycleState.Deleting) || state.equals((Object)LifecycleState.Updating)); time += waitInterval) {
            try {
                Thread.sleep(waitInterval * 1000);
            }
            catch (InterruptedException e) {
                throw Result.rcvInterruptedWaitException(RcvMessages.format("RCVS_INTERRUPTED_WAIT_EXCEPTION_RSS_MSG", new Object[0]), e);
            }
            state = getResource.get();
        }
        return state;
    }

    public String getProtectedDatabaseOcid(Connection conn) {
        String finalDbOcid;
        List summaryList;
        GlobalMetadata globalMetadata = RCVCommandBase.getGlobalMetadata();
        String dbUniqueName = RCVCommandBase.getDbUniqueName(conn);
        String dbOcid = null;
        String compartmentId = null;
        if (globalMetadata.getSystemType().equals("OCI")) {
            OCIAuthentication authentication = globalMetadata.getAuthentication();
            DatabaseClientManager databaseClientManager = new DatabaseClientManager(authentication);
            DatabaseSummary databaseSummary = databaseClientManager.getDatabaseSummary(dbUniqueName);
            if (databaseSummary == null) {
                this.log(Level.FINE, "no database found");
                return null;
            }
            dbOcid = databaseSummary.getId();
            compartmentId = databaseSummary.getCompartmentId();
        } else {
            dbOcid = DatabaseUtils.generateDatabaseIdForOnPremiseClient(conn);
            Database database = RCVCommandBase.getDatabase(conn);
            compartmentId = database.getFleetAgentContext().getProtectedDatabaseCache().getCompartmentId();
            if (compartmentId == null && (compartmentId = GlobalMetadata.load().getAuthentication().getTenancyId()) == null) {
                throw new IllegalStateException("Compartment ID is missing from the metadata. Please provide it using 'rcv add protected_database'.");
            }
        }
        if (dbOcid != null && !(summaryList = this.getAllResourcesBySearchingAllCompartments(compartmentId, arg_0 -> this.lambda$getProtectedDatabaseOcid$2(dbUniqueName, finalDbOcid = dbOcid, arg_0))).isEmpty()) {
            return ((ProtectedDatabaseSummary)summaryList.get(0)).getId();
        }
        return null;
    }

    public String getProtectedDatabaseOcid(Connection conn, String compartmentId) {
        List<ProtectedDatabaseSummary> summaryList;
        GlobalMetadata globalMetadata = RCVCommandBase.getGlobalMetadata();
        String dbUniqueName = RCVCommandBase.getDbUniqueName(conn);
        String dbOcid = null;
        if (globalMetadata.getSystemType().equals("OCI")) {
            OCIAuthentication authentication = globalMetadata.getAuthentication();
            DatabaseClientManager databaseClientManager = new DatabaseClientManager(authentication);
            DatabaseSummary databaseSummary = databaseClientManager.getDatabaseSummary(dbUniqueName);
            if (databaseSummary == null) {
                this.log(Level.FINE, "no database found");
                return null;
            }
            dbOcid = databaseSummary.getId();
            compartmentId = databaseSummary.getCompartmentId();
        } else {
            dbOcid = DatabaseUtils.generateDatabaseIdForOnPremiseClient(conn);
        }
        if (dbOcid != null && (summaryList = this.filterProtectedDatabasesByDatabaseId(compartmentId, dbUniqueName, dbOcid)).size() > 0) {
            return summaryList.get(0).getId();
        }
        return null;
    }

    public CreateProtectionPolicyResponse createProtectionPolicy(CreateProtectionPolicyRequest request) {
        return this.client.createProtectionPolicy(request);
    }

    public List<ProtectionPolicySummary> getProtectionPolicies(ListProtectionPoliciesRequest request) {
        ListProtectionPoliciesResponse response;
        try {
            this.log(Level.FINEST, String.valueOf(request));
            response = this.client.listProtectionPolicies(request);
        }
        catch (Exception e) {
            throw Result.rcvGetProtectionPolicyException(request.getCompartmentId(), e);
        }
        this.log(Level.FINEST, String.valueOf(response.getProtectionPolicyCollection()));
        return response.getProtectionPolicyCollection().getItems();
    }

    public List<ProtectionPolicySummary> getDefaultProtectionPolicies(String compartmentId) {
        ListProtectionPoliciesRequest request = new ListProtectionPoliciesRequest.Builder().compartmentId(compartmentId).lifecycleState(LifecycleState.Active).build();
        List<ProtectionPolicySummary> items = this.getProtectionPolicies(request);
        return items.stream().filter(item -> item.getIsPredefinedPolicy()).collect(Collectors.toList());
    }

    public List<ProtectionPolicySummary> getProtectionPolicies(String compartmentId) {
        ListProtectionPoliciesRequest request = new ListProtectionPoliciesRequest.Builder().compartmentId(compartmentId).lifecycleState(LifecycleState.Active).build();
        return this.getProtectionPolicies(request);
    }

    public List<ProtectionPolicySummary> getProtectionPoliciesByName(String policyName, String compartmentId) {
        ListProtectionPoliciesRequest request = new ListProtectionPoliciesRequest.Builder().compartmentId(compartmentId).displayName(policyName).lifecycleState(LifecycleState.Active).build();
        return this.getProtectionPolicies(request);
    }

    public List<ProtectionPolicySummary> getProtectionPoliciesByName(String policyName) {
        String tenancyId = GlobalMetadata.load().getAuthentication().getTenancyId();
        return this.getAllResourcesBySearchingAllCompartments(tenancyId, compId -> this.getProtectionPoliciesByName(policyName, (String)compId));
    }

    public List<String> getProtectionPolicyOcids(String policyName, String compartmentId) {
        List<ProtectionPolicySummary> items = this.getProtectionPoliciesByName(policyName, compartmentId);
        return items.stream().map(ProtectionPolicySummary::getId).collect(Collectors.toList());
    }

    public ProtectionPolicy getProtectionPolicy(String policyId) {
        GetProtectionPolicyRequest request = GetProtectionPolicyRequest.builder().protectionPolicyId(policyId).build();
        this.log(Level.FINEST, String.valueOf(request));
        GetProtectionPolicyResponse response = this.client.getProtectionPolicy(request);
        this.log(Level.FINEST, String.valueOf(response));
        return response.getProtectionPolicy();
    }

    public UpdateProtectionPolicyResponse updateProtectionPolicy(UpdateProtectionPolicyRequest request) {
        return this.client.updateProtectionPolicy(request);
    }

    public ChangeProtectionPolicyCompartmentResponse changeProtectionPolicyCompartment(ChangeProtectionPolicyCompartmentRequest request) {
        return this.client.changeProtectionPolicyCompartment(request);
    }

    public DeleteProtectionPolicyResponse deleteProtectionPolicyRequest(DeleteProtectionPolicyRequest request) {
        return this.client.deleteProtectionPolicy(request);
    }

    public ChangeProtectedDatabaseCompartmentRequest changeProtectedDatabaseCompartmentRequest(String ocid, String compartmentId) {
        if (compartmentId == null) {
            return null;
        }
        ChangeProtectedDatabaseCompartmentDetails details = new ChangeProtectedDatabaseCompartmentDetails.Builder().compartmentId(compartmentId).build();
        return new ChangeProtectedDatabaseCompartmentRequest.Builder().body$(details).protectedDatabaseId(ocid).build();
    }

    public ChangeProtectedDatabaseCompartmentResponse changeProtectedDatabaseCompartment(String protectedDatabaseId, String compartmentId) {
        ChangeProtectedDatabaseCompartmentRequest request = this.changeProtectedDatabaseCompartmentRequest(protectedDatabaseId, compartmentId);
        this.log(Level.FINE, request.toString());
        return this.changeProtectedDatabaseCompartment(request);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <Resource extends ExplicitlySetBmcModel> List<Resource> getAllResourcesBySearchingAllCompartments(String compartmentId, Function<String, List<Resource>> getResources) {
        String nextPageToken = null;
        ArrayList<Resource> allResources = new ArrayList<Resource>();
        boolean recursive = OCIUtils.isTenancyOcid(compartmentId);
        List<Resource> resources = getResources.apply(compartmentId);
        if (resources != null && !resources.isEmpty()) {
            allResources.addAll(resources);
        }
        try (IdentityClient identityClient = IdentityClient.builder().build(provider);){
            ListCompartmentsResponse response;
            do {
                ListCompartmentsRequest.Builder requestBuilder = ListCompartmentsRequest.builder().compartmentId(compartmentId).compartmentIdInSubtree(Boolean.valueOf(recursive)).accessLevel(ListCompartmentsRequest.AccessLevel.Accessible).lifecycleState(Compartment.LifecycleState.Active);
                if (nextPageToken != null) {
                    requestBuilder.page(nextPageToken);
                }
                response = null;
                try {
                    response = identityClient.listCompartments(requestBuilder.build());
                }
                catch (BmcException e) {
                    String error = String.format("Failed to list compartments in %s: %s", compartmentId, e.getMessage());
                    this.log(Level.FINE, error);
                }
                if (response == null) return allResources;
                List compartments = response.getItems();
                for (Compartment compartment : compartments) {
                    resources = getResources.apply(compartment.getId());
                    if (resources == null || resources.isEmpty()) continue;
                    allResources.addAll(resources);
                }
            } while ((nextPageToken = response.getOpcNextPage()) != null);
            return allResources;
        }
    }

    public <Resource extends ExplicitlySetBmcModel> Resource getResourceBySearchingAllCompartments(String compartmentId, Function<String, Resource> getResource) {
        String nextPageToken = null;
        boolean recursive = OCIUtils.isTenancyOcid(compartmentId);
        ExplicitlySetBmcModel resource = (ExplicitlySetBmcModel)getResource.apply(compartmentId);
        if (resource != null) {
            return (Resource)resource;
        }
        try (IdentityClient identityClient = IdentityClient.builder().build(provider);){
            ListCompartmentsResponse response;
            do {
                ListCompartmentsRequest.Builder requestBuilder = ListCompartmentsRequest.builder().compartmentId(compartmentId).compartmentIdInSubtree(Boolean.valueOf(recursive)).accessLevel(ListCompartmentsRequest.AccessLevel.Accessible).lifecycleState(Compartment.LifecycleState.Active);
                if (nextPageToken != null) {
                    requestBuilder.page(nextPageToken);
                }
                response = null;
                try {
                    response = identityClient.listCompartments(requestBuilder.build());
                }
                catch (BmcException e) {
                    String error = String.format("Failed to list compartments in %s: %s", compartmentId, e.getMessage());
                    this.log(Level.FINE, error);
                }
                if (response == null) break;
                List compartments = response.getItems();
                for (Compartment compartment : compartments) {
                    resource = (ExplicitlySetBmcModel)getResource.apply(compartment.getId());
                    if (resource == null) continue;
                    ExplicitlySetBmcModel explicitlySetBmcModel = resource;
                    return (Resource)explicitlySetBmcModel;
                }
            } while ((nextPageToken = response.getOpcNextPage()) != null);
        }
        return null;
    }

    public CancelProtectedDatabaseDeletionResponse cancelProtectedDatabaseDeletion(String id) {
        CancelProtectedDatabaseDeletionRequest request = CancelProtectedDatabaseDeletionRequest.builder().protectedDatabaseId(id).build();
        return this.client.cancelProtectedDatabaseDeletion(request);
    }

    public ChangeRecoveryServiceSubnetCompartmentResponse changeRecoveryServiceSubnetCompartment(ChangeRecoveryServiceSubnetCompartmentRequest request) {
        return this.client.changeRecoveryServiceSubnetCompartment(request);
    }

    public UpdateRecoveryServiceSubnetResponse updateRecoveryServiceSubnet(UpdateRecoveryServiceSubnetRequest request) {
        return this.client.updateRecoveryServiceSubnet(request);
    }

    private /* synthetic */ List lambda$getProtectedDatabaseOcid$2(String dbUniqueName, String finalDbOcid, String compId) {
        return this.filterProtectedDatabasesByDatabaseId(compId, dbUniqueName, finalDbOcid);
    }
}

