/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.models.systemcommands;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.extension.rcv.workflows.Workflow;

public class SystemCommand {
    private HashMap<String, String> environment = null;
    private Logger logger;
    private boolean printOutput;

    public SystemCommand environment(HashMap<String, String> environment) {
        this.environment = environment;
        return this;
    }

    public SystemCommand logger(Logger logger) {
        this.logger = logger;
        return this;
    }

    public SystemCommand setEnvironmentVariable(String name, String value) {
        if (this.environment == null) {
            this.environment = new HashMap();
        }
        if (name != null && value != null) {
            this.environment.put(name, value);
        }
        return this;
    }

    private ProcessBuilder getProcessBuilder(List<String> args) {
        ProcessBuilder builder = new ProcessBuilder(args);
        if (this.environment != null) {
            Map<String, String> processEnvironment = builder.environment();
            for (String key : this.environment.keySet()) {
                processEnvironment.put(key, this.environment.get(key));
                if (this.logger == null) continue;
                this.logger.log(Level.FINE, key + ": " + this.environment.get(key));
            }
        }
        return builder;
    }

    public ExecutionResult run(String ... args) {
        return this.run(List.of(args));
    }

    public ExecutionResult run(List<String> args) {
        if (this.logger != null) {
            this.logger.log(Level.FINE, String.join((CharSequence)" ", args));
        }
        ProcessBuilder builder = this.getProcessBuilder(args);
        builder.redirectOutput(ProcessBuilder.Redirect.PIPE);
        builder.redirectError(ProcessBuilder.Redirect.PIPE);
        StringBuilder sb = new StringBuilder();
        try {
            Process process = builder.start();
            BufferedReader stdOutput = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String lineSeparator = System.getProperty("line.separator");
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if (this.logger != null) {
                        this.logger.log(Level.FINE, line + lineSeparator);
                    }
                    sb.append(line).append(lineSeparator);
                }
            }
            int rc = process.waitFor();
            return new ExecutionResult(sb.toString(), rc);
        }
        catch (Exception e) {
            Workflow.logException(e, this.logger);
            return new ExecutionResult(e.getMessage(), -1);
        }
    }

    public ExecutionResult run(List<String> args, String input) {
        if (this.logger != null) {
            this.logger.log(Level.FINE, String.join((CharSequence)" ", args));
        }
        ProcessBuilder builder = this.getProcessBuilder(args);
        builder.redirectErrorStream(true);
        StringBuilder sb = new StringBuilder();
        try {
            Process process = builder.start();
            BufferedReader stdOutput = new BufferedReader(new InputStreamReader(process.getInputStream()));
            BufferedWriter stdInput = new BufferedWriter(new OutputStreamWriter(process.getOutputStream()));
            stdInput.write(input + System.getProperty("line.separator"));
            stdInput.flush();
            stdInput.close();
            String s = null;
            while ((s = stdOutput.readLine()) != null) {
                if (this.printOutput) {
                    System.out.println("\t" + s);
                }
                sb.append(s);
                sb.append(System.getProperty("line.separator"));
            }
            int rc = process.waitFor();
            return new ExecutionResult(sb.toString(), rc);
        }
        catch (Exception e) {
            System.out.println("failed to execute command: " + e.getMessage());
            if (this.logger != null) {
                this.logger.log(Level.FINE, "Failed to execute command.", e);
            }
            return new ExecutionResult(e.getMessage(), -1);
        }
    }

    public Process runInBackground(List<String> args) throws IOException {
        if (this.logger != null) {
            this.logger.log(Level.FINE, String.join((CharSequence)" ", args));
        }
        ProcessBuilder builder = this.getProcessBuilder(args);
        return builder.start();
    }

    public static class ExecutionResult {
        private String output;
        private int returnCode;

        public ExecutionResult(String output, int returnCode) {
            this.output = output;
            this.returnCode = returnCode;
        }

        public String getOutput() {
            return this.output;
        }

        public int getReturnCode() {
            return this.returnCode;
        }
    }
}

