/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.models.ora;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.extension.rcv.models.ora.Node;
import oracle.dbtools.extension.rcv.utils.Utils;
import oracle.dbtools.extension.rcv.workflows.FileLocker;

public class OraConfig {
    private List<Node<String>> entries;

    public OraConfig() {
        this.entries = new ArrayList<Node<String>>();
    }

    public OraConfig(List<Node<String>> entries) {
        this.entries = entries;
    }

    public static OraConfig load(String filePath) {
        return new OraConfig(OraConfig.getEntries(filePath));
    }

    public static List<Node<String>> getEntries(String filePath) {
        ArrayList<String> data = new ArrayList<String>();
        Object currentEntry = "";
        int leftParentheses = 0;
        Pattern p = Pattern.compile("^([^\\s\\(\\)]+)\\s*=\\s*(\\S+)$");
        Pattern commentP = Pattern.compile("^#\\s*\\S+");
        File file = new File(filePath);
        try (Scanner sqlnetReader = new Scanner(file);){
            while (sqlnetReader.hasNextLine()) {
                Matcher m;
                String line = sqlnetReader.nextLine().strip();
                Matcher commentM = commentP.matcher(line);
                if (commentM.find()) continue;
                line = line.replaceAll("\\s", "");
                currentEntry = (String)currentEntry + line;
                for (char c : line.toCharArray()) {
                    if (c == '(') {
                        ++leftParentheses;
                    } else if (c == ')') {
                        --leftParentheses;
                    }
                    if (leftParentheses >= 0) continue;
                }
                if (leftParentheses != 0 || !(m = p.matcher((CharSequence)currentEntry)).find()) continue;
                data.add((String)currentEntry);
                currentEntry = "";
            }
        }
        catch (FileNotFoundException e) {
            return new ArrayList<Node<String>>();
        }
        return OraConfig.parseLines(data);
    }

    static List<Node<String>> parseLines(List<String> lines) {
        ArrayList<Node<String>> data = new ArrayList<Node<String>>();
        for (String line : lines) {
            data.add(OraConfig.parseLine(line));
        }
        return data;
    }

    static Node<String> parseLine(String line) {
        Pattern p1 = Pattern.compile("^([^\\s\\(\\)]+)\\s*=\\s*([^\\s\\(\\)=]+)$");
        Pattern p2 = Pattern.compile("^([^\\s\\(\\)]+)\\s*=\\s*(\\([^\\(\\)=]+\\))$");
        Pattern p3 = Pattern.compile("^([^\\s\\(\\)]+)\\s*=\\s*(\\(\\S+\\))$");
        Matcher m = p1.matcher(line);
        if (m.find()) {
            return new Node<String>(m.group(1)).addChild(new Node<String>(m.group(2)));
        }
        m = p2.matcher(line);
        if (m.find()) {
            return new Node<String>(m.group(1)).addChild(new Node<String>(m.group(2)));
        }
        m = p3.matcher(line);
        if (!m.find()) {
            return null;
        }
        int leftParentheses = 0;
        int leftParenthesisIndex = line.indexOf("(");
        Node<String> node = new Node<String>(m.group(1));
        for (int i = leftParenthesisIndex; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (c == '(') {
                ++leftParentheses;
                if (leftParenthesisIndex == -1) {
                    leftParenthesisIndex = i;
                }
            } else if (c == ')') {
                --leftParentheses;
            }
            if (leftParenthesisIndex == -1 || leftParentheses != 0) continue;
            Node<String> child = OraConfig.parseLine(line.substring(leftParenthesisIndex + 1, i));
            node.addChild(child);
            leftParenthesisIndex = -1;
        }
        return node;
    }

    public List<Node<String>> getEntries() {
        return this.entries;
    }

    public Node<String> getNode(String parameter) {
        for (int i = this.entries.size() - 1; i >= 0; --i) {
            Node<String> n = this.entries.get(i);
            Node<String> result = n.getNode(parameter);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public List<Node<String>> getAllMatchingNodes(String parameter) {
        ArrayList<Node<String>> results = new ArrayList<Node<String>>();
        for (Node<String> entry : this.entries) {
            results.addAll(entry.getAllNodes(parameter));
        }
        return results;
    }

    public String getParameterValue(Node<String> node) {
        if (node == null) {
            return "";
        }
        if (node.isLeaf()) {
            return OraConfig.toString(node, 0);
        }
        List<Node<String>> nodeChildren = node.getChildren();
        if (!nodeChildren.isEmpty()) {
            if (nodeChildren.size() == 1) {
                return OraConfig.toString(node.getChildren().get(0), 0);
            }
            StringBuilder sb = new StringBuilder();
            for (Node<String> child : node.getChildren()) {
                sb.append("(").append(OraConfig.toString(child, 0)).append(")");
            }
            return sb.toString();
        }
        return "";
    }

    public String getParameterValue(String parameter) {
        Node<String> node = this.getNode(parameter);
        return this.getParameterValue(node);
    }

    public List<String> getAllMatchingParameter(String parameter) {
        ArrayList<String> values = new ArrayList<String>();
        List<Node<String>> matchedNodes = this.getAllMatchingNodes(parameter);
        for (Node<String> n : matchedNodes) {
            values.add(OraConfig.toString(n, 0));
        }
        return values;
    }

    public synchronized Node<String> updateParameter(Node<String> node, String value) {
        if (!value.isEmpty()) {
            if ((value = value.replaceAll("[\\n\\s]", "")).charAt(0) != '(') {
                node.setChildren(List.of(new Node<String>(value)));
            } else {
                Node<String> newEntry = OraConfig.parseLine(node.getValue() + "=" + value);
                if (newEntry != null) {
                    node.setChildren(newEntry.getChildren());
                }
            }
        }
        return node;
    }

    public synchronized Node<String> updateParameter(String parameter, String value) {
        Node<String> node = this.getNode(parameter);
        if (node == null) {
            node = new Node<String>(parameter);
            this.entries.add(node);
        }
        return this.updateParameter(node, value);
    }

    public List<String> getIfiles() {
        ArrayList<String> ifiles = new ArrayList<String>();
        List<Node<String>> ifileEntries = this.getAllMatchingNodes("IFILE");
        for (Node<String> ifileEntry : ifileEntries) {
            if (ifileEntry.getChildren().isEmpty()) continue;
            ifiles.add(OraConfig.toString(ifileEntry.getChildren().get(0), 0));
        }
        return ifiles;
    }

    public boolean addIfile(String ifile) {
        List<String> currentIfiles = this.getIfiles();
        for (String currentIfile : currentIfiles) {
            if (!currentIfile.equals(ifile)) continue;
            return false;
        }
        this.entries.add(new Node<String>("IFILE").addChild(new Node<String>(ifile)));
        return true;
    }

    public boolean removeIfile(String ifile) {
        boolean removed = false;
        List<Node<String>> ifileEntries = this.getAllMatchingNodes("IFILE");
        for (Node<String> ifileEntry : ifileEntries) {
            if (ifileEntry.getChildren().isEmpty() || !ifileEntry.getChildren().get(0).getValue().equals(ifile)) continue;
            this.entries.remove(ifileEntry);
            removed = true;
        }
        return removed;
    }

    public static String toString(Node<String> node, int depth) {
        if (node == null) {
            return "";
        }
        StringBuilder s = new StringBuilder();
        List<Node<String>> children = node.getChildren();
        if (children.isEmpty()) {
            return node.getValue();
        }
        s.append(node.getValue()).append(" = ");
        for (Node<String> child : children) {
            if (child == null) continue;
            if (child.isLeaf()) {
                s.append(OraConfig.toString(child, depth + 1));
                continue;
            }
            s.append("\n").append("  ".repeat(depth)).append("(").append(OraConfig.toString(child, depth + 1)).append(")");
        }
        return s.toString();
    }

    public synchronized String toString() {
        StringBuilder s = new StringBuilder();
        for (Node<String> entry : this.entries) {
            s.append(OraConfig.toString(entry, 0)).append("\n\n");
        }
        return s.toString();
    }

    public synchronized void removeParameter(String parameter) {
        for (Node<String> entry : this.entries) {
            if (entry.getValue().equals(parameter)) {
                this.entries.remove(entry);
                return;
            }
            Node<String> removed = entry.remove(parameter);
            if (removed == null) continue;
            return;
        }
    }

    public synchronized void write(String filePath) throws IOException {
        FileLocker fl = new FileLocker(filePath + ".lock", 10);
        fl.execute(() -> {
            Utils.createParentDirectoryForFile(filePath);
            try (FileOutputStream fileStream = new FileOutputStream(filePath);
                 OutputStreamWriter fileWriter = new OutputStreamWriter(fileStream);){
                fileWriter.write(String.valueOf(this) + "\n");
            }
            return null;
        });
    }

    public boolean equals(OraConfig other) {
        return this.toString().equals(other.toString());
    }

    public static boolean entryEquals(Node<String> entry1, Node<String> entry2) {
        return OraConfig.toString(entry1, 0).equals(OraConfig.toString(entry2, 0));
    }

    public static boolean entryEquals(Node<String> entry1, String value) {
        String trimmedValue = OraConfig.toString(entry1, 0).replaceAll("[\\n\\s]", "");
        return trimmedValue.equals(value.replaceAll("[\\n\\s]", ""));
    }
}

