/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.models.database;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ConcurrentHashMap;
import oracle.dbtools.extension.rcv.commands.RCVCommandBase;
import oracle.dbtools.extension.rcv.models.database.ProtectedDatabaseCache;
import oracle.dbtools.extension.rcv.models.jobs.JobType;

public class FleetAgentContext {
    private static ConcurrentHashMap<String, FleetAgentContext> agentContextMap = new ConcurrentHashMap();
    private String dbUniqueName;
    private String metadataDirectory;
    private String scriptsDirectory;
    private String logsDirectory;
    private String taskLogsDirectory;
    private String locksDirectory;
    private String networkDirectory;
    private String tnsnamesPath;
    private String dbnamesPath;
    private String sqlnetPath;
    private String backupJobName;
    private String rotateVpcCredentialsJobName;
    private String connectionName;

    private FleetAgentContext(String dbUniqueName) {
        this.dbUniqueName = dbUniqueName;
        this.metadataDirectory = RCVCommandBase.getProtectedDatabaseMetadataDirectory(dbUniqueName);
        this.scriptsDirectory = RCVCommandBase.getScriptsDirectory(dbUniqueName);
        this.logsDirectory = RCVCommandBase.getLogDirectory(dbUniqueName);
        this.taskLogsDirectory = String.join((CharSequence)File.separator, this.logsDirectory, "tasks");
        this.locksDirectory = RCVCommandBase.getLocksDirectory(dbUniqueName);
        this.networkDirectory = RCVCommandBase.getNetworkDirectory(dbUniqueName);
        this.tnsnamesPath = String.join((CharSequence)File.separator, this.networkDirectory, "tnsnames.ora");
        this.sqlnetPath = String.join((CharSequence)File.separator, this.networkDirectory, "sqlnet.ora");
        this.dbnamesPath = String.join((CharSequence)File.separator, this.networkDirectory, "dbnames.ora");
        this.dbnamesPath = String.join((CharSequence)File.separator, this.networkDirectory, "dbnames.ora");
        this.connectionName = FleetAgentContext.getConnectionName(dbUniqueName);
    }

    public static FleetAgentContext get(String dbUniqueName) {
        return agentContextMap.computeIfAbsent(dbUniqueName, FleetAgentContext::new);
    }

    public String getDbUniqueName() {
        return this.dbUniqueName;
    }

    public String getWalletLocation() {
        return RCVCommandBase.getProtectedDatabaseCache(this.dbUniqueName).getWalletLocation();
    }

    public String getMetadataDirectory() {
        return this.metadataDirectory;
    }

    public String getScriptsDirectory() {
        return this.scriptsDirectory;
    }

    public String getLogsDirectory() {
        return this.logsDirectory;
    }

    public String getLocksDirectory() {
        return this.locksDirectory;
    }

    public String getTnsAdmin() {
        return this.networkDirectory;
    }

    public String getTnsnamesPath() {
        return this.tnsnamesPath;
    }

    public String getDbNamesPath() {
        return this.dbnamesPath;
    }

    public String getSqlnetPath() {
        return this.sqlnetPath;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public static String getConnectionName(String dbUniqueName) {
        return dbUniqueName + "_rcv_conn";
    }

    public String getJobName(JobType type) {
        return FleetAgentContext.getJobName(this.dbUniqueName, type);
    }

    public static String getJobName(String dbUniqueName, JobType type) {
        switch (type) {
            case BACKUP: {
                return dbUniqueName + "_rcv_backup";
            }
            case ROTATE_VPC_CREDS: {
                return dbUniqueName + "_rcv_rotate_vpc_creds";
            }
        }
        return null;
    }

    public ProtectedDatabaseCache getProtectedDatabaseCache() {
        return RCVCommandBase.getProtectedDatabaseCache(this.dbUniqueName);
    }

    public static boolean createDatabaseDirectory(String dbUniqueName) throws IOException {
        String[] directories;
        boolean updated = false;
        for (String d : directories = new String[]{RCVCommandBase.getProtectedDatabaseMetadataDirectory(dbUniqueName), RCVCommandBase.getNetworkDirectory(dbUniqueName), RCVCommandBase.getWalletDirectory(dbUniqueName), RCVCommandBase.getScriptsDirectory(dbUniqueName), RCVCommandBase.getLogDirectory(dbUniqueName), RCVCommandBase.getLocksDirectory(dbUniqueName)}) {
            Path path;
            if (d == null || Files.exists(path = Paths.get(d, new String[0]), new LinkOption[0])) continue;
            Files.createDirectories(path, new FileAttribute[0]);
            updated = true;
        }
        return updated;
    }

    public String getTaskLogsDirectory() {
        return this.taskLogsDirectory;
    }
}

