/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.models.database;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.extension.rcv.workflows.Result;

public class DatabaseInstanceInfo {
    private static final String GET_ALL_INSTANCE_INFO = "SELECT instance_name, instance_number, host_name, status FROM gv$instance ORDER BY instance_number";
    private int id;
    private String name;
    private String host;
    private String status;

    private DatabaseInstanceInfo(int id, String name, String host, String status) {
        this.id = id;
        this.name = name;
        this.host = host;
        this.status = status;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getHost() {
        return this.host;
    }

    public String getStatus() {
        return this.status;
    }

    public static List<DatabaseInstanceInfo> getAllInstanceInfo(Connection conn) {
        ArrayList<DatabaseInstanceInfo> info = new ArrayList<DatabaseInstanceInfo>();
        try (ResultSet rs = DBUtil.getInstance((Connection)conn).executeOracleQuery(GET_ALL_INSTANCE_INFO, null);){
            while (rs != null && rs.next()) {
                String hostName = rs.getString("HOST_NAME");
                String name = rs.getString("INSTANCE_NAME");
                int id = rs.getInt("INSTANCE_NUMBER");
                String status = rs.getString("STATUS");
                info.add(new DatabaseInstanceInfo(id, name, hostName, status));
            }
        }
        catch (SQLException e) {
            throw Result.databaseSqlException("Failed to get instance information", e);
        }
        return info;
    }
}

