/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.models.database;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import oracle.dbtools.extension.rcv.commands.RCVCommandBase;
import oracle.dbtools.extension.rcv.models.database.FullDatabaseConfig;
import oracle.dbtools.extension.rcv.models.database.Oratab;
import oracle.dbtools.extension.rcv.models.database.SimpleDatabaseConfig;
import oracle.dbtools.extension.rcv.models.systemcommands.SystemCommand;
import oracle.dbtools.extension.rcv.utils.DatabaseUtils;

public interface DatabaseConfig {
    public static final ConcurrentHashMap<String, DatabaseConfig> dbConfigs = new ConcurrentHashMap();

    public String getOracleHome();

    public String getOracleSid();

    public String getDbUniqueName();

    public static List<DatabaseConfig> getAll() {
        return DatabaseConfig.getAll(RCVCommandBase.getOracleHome());
    }

    public static List<DatabaseConfig> getAll(String oracleHome) {
        ArrayList<DatabaseConfig> configs = new ArrayList<DatabaseConfig>();
        String srvctl = String.join((CharSequence)File.separator, oracleHome, "bin", "srvctl");
        if (Files.exists(Paths.get(srvctl, new String[0]), new LinkOption[0])) {
            SystemCommand.ExecutionResult result = new SystemCommand().run(srvctl, "config", "database", "-verbose");
            if (result.getReturnCode() == 0) {
                String[] lines;
                String output = result.getOutput();
                for (String line : lines = output.split("\n")) {
                    String[] columns = line.trim().split("\\s+");
                    if (columns.length != 3) continue;
                    Optional<FullDatabaseConfig> dbConfigHolder = FullDatabaseConfig.getDatabaseConfig(columns[1], columns[0]);
                    dbConfigHolder.ifPresent(configs::add);
                }
                return configs;
            }
            Object error = "Failed to run srvctl config database -verbose";
            if (result.getOutput() != null) {
                error = (String)error + ": " + result.getOutput();
            }
            RCVCommandBase.getLogger().log(Level.FINE, (String)error);
        }
        List<Oratab.OratabEntry> entries = Oratab.get();
        for (Oratab.OratabEntry entry : entries) {
            String home;
            String dbUniqueName;
            String oracleSid = entry.getOracleSid();
            if (oracleSid.equalsIgnoreCase("+ASM") || (dbUniqueName = DatabaseUtils.getDbUniqueName(oracleSid, home = entry.getOracleHome())) == null) continue;
            configs.add(new SimpleDatabaseConfig(dbUniqueName, oracleSid, oracleHome));
        }
        return configs;
    }

    public static Optional<DatabaseConfig> get(String dbUniqueName, String oracleHome) {
        return Optional.ofNullable(dbConfigs.computeIfAbsent(dbUniqueName, name -> {
            List<DatabaseConfig> allConfigs = DatabaseConfig.getAll(oracleHome);
            for (DatabaseConfig config : allConfigs) {
                if (!config.getDbUniqueName().equalsIgnoreCase(dbUniqueName)) continue;
                return config;
            }
            return null;
        }));
    }

    public static Optional<DatabaseConfig> get(String dbUniqueName) {
        return DatabaseConfig.get(dbUniqueName, RCVCommandBase.getOracleHome());
    }

    public static String getOracleHome(String dbUniqueName) {
        Optional<DatabaseConfig> dbConfig = DatabaseConfig.get(dbUniqueName);
        if (dbConfig.isPresent()) {
            return dbConfig.get().getOracleHome();
        }
        return RCVCommandBase.getOracleHome();
    }
}

