/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.models.commandengine;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.extension.rcv.commands.RcvMessages;
import oracle.dbtools.extension.rcv.models.commandengine.FleetEngineRequest;
import oracle.dbtools.extension.rcv.models.commandengine.FleetEngineResponse;
import oracle.dbtools.extension.rcv.workflows.Result;

public class ConfigureRequest
extends FleetEngineRequest {
    private int sessionId;
    private String name;
    private String value;
    private static final String CONFIGURE = "call dbms_ra_cmd_engine.configure(?, ?, ?, ?, ?)";
    public static final String ARCHIVAL_BACKUP_INTERVAL = "archive_log_backup_interval";
    public static final String CLIENT_MAX_CHANNEL = "client_max_channels";
    public static final String COMPRESSION_ALGORITHM = "compression_algorithm";
    public static final String CREDENTIAL_ALIAS = "credential_alias";
    public static final String DB_VERSION = "db_version";
    public static final String ENCRYPTION_ALGORITHM = "encryption_algorithm";
    public static final String FLEET_AGENT_VERSION = "fleet_agent_version";
    public static final String LEVEL_ONE_BACKUP = "backup_level_one_database";
    public static final String LEVEL_ZERO_BACKUP = "backup_level_zero_database";
    public static final String LIB_RA_LOCATION = "lib_ra_location";
    public static final String NODE_COUNT = "node_count";
    public static final String OCPU_PER_NODE = "ocpu_per_node";
    public static final String PREFERRED_BACKUP_DB_UNIQUE_NAME = "preferred_backup_db_unique_name";
    public static final String PREFERRED_BACKUP_START_TIME = "preferred_backup_start_time";
    public static final String RMAN_VERSION = "rman_version";
    public static final String WALLET_LOCATION = "wallet_location";

    private ConfigureRequest(Builder builder) {
        super(builder);
        String dbUniqueName = super.getDbUniqueName();
        this.getLogger().log(Level.FINE, "DbUniqueName: " + dbUniqueName.toUpperCase());
        this.getLogger().log(Level.FINE, "SessionId     : " + builder.sessionId);
        this.getLogger().log(Level.FINE, "Name        : " + builder.name);
        this.getLogger().log(Level.FINE, "Value       : " + builder.value);
        try {
            CallableStatement cs = super.getCallableStatement();
            this.sessionId = builder.sessionId;
            this.name = builder.name;
            this.value = builder.value;
            cs.setInt("SESSION_ID", builder.sessionId);
            cs.setString("CONFIG_NAME", builder.name);
            cs.setString("CONFIG_VALUE", builder.value);
            cs.registerOutParameter("STATUS_CODE_OUT", 4);
            cs.registerOutParameter("STATUS_MESG_OUT", 12);
        }
        catch (SQLException e) {
            throw Result.fengDatabaseSqlException(RcvMessages.format("FENG_CONFIGURE_ERROR_MSG", new Object[0]), e);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public FleetEngineResponse<Void> execute() throws SQLException {
        CallableStatement cs = super.getCallableStatement();
        cs.execute();
        int statusCode = cs.getInt("STATUS_CODE_OUT");
        String statusMessage = cs.getString("STATUS_MESG_OUT");
        this.getLogger().log(Level.FINE, "StatusCode: " + statusCode);
        this.getLogger().log(Level.FINE, "StatusMesg: " + statusMessage);
        return new FleetEngineResponse<Object>(statusCode, statusMessage, null);
    }

    public static class Builder
    extends FleetEngineRequest.Builder<Builder> {
        private int sessionId;
        private String name;
        private String value;

        public Builder(Connection conn, String dbUniqueName, int sessionId, String name, String value, Logger logger) {
            super(conn, dbUniqueName, ConfigureRequest.CONFIGURE, logger);
            this.sessionId = sessionId;
            this.name = name;
            this.value = value;
        }

        @Override
        public ConfigureRequest build() {
            return new ConfigureRequest(this);
        }

        public Builder logger(Logger logger) {
            super.setLogger(logger);
            return this.self();
        }

        @Override
        public Builder self() {
            return this;
        }
    }
}

