/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.models;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.extension.rcv.models.systemcommands.SystemCommand;
import oracle.dbtools.raptor.utils.TNSHelper;

public class SCANListener {
    private static final Pattern networkNumPattern = Pattern.compile("SCAN Listeners for network\\s*(\\d+):");
    private static final Pattern endpointsPattern = Pattern.compile("Endpoints:\\s*(.+):(\\d+)");
    private int networkNum;
    private String protocol;
    private int port;
    private static List<SCANListener> listeners;

    private SCANListener(int networkNum, String protocol, int port) {
        this.networkNum = networkNum;
        this.protocol = protocol;
        this.port = port;
    }

    public int getNetworkNum() {
        return this.networkNum;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public int getPort() {
        return this.port;
    }

    public static List<SCANListener> getListeners() {
        return SCANListener.getListeners(TNSHelper.getOracleHome());
    }

    public static List<SCANListener> getListeners(String oracleHome) {
        if (listeners != null && !listeners.isEmpty()) {
            return listeners;
        }
        listeners = new ArrayList<SCANListener>();
        String srvctl = String.join((CharSequence)File.separator, oracleHome, "bin", "srvctl");
        SystemCommand.ExecutionResult result = new SystemCommand().run(srvctl, "config", "scan_listener");
        if (result.getReturnCode() == 0) {
            String[] output = result.getOutput().trim().split("\n");
            Integer networkNum = null;
            String protocol = null;
            Integer port = null;
            for (String line : output) {
                Matcher matcher = networkNumPattern.matcher(line = line.trim());
                if (matcher.matches()) {
                    networkNum = Integer.parseInt(matcher.group(1));
                    protocol = null;
                    port = null;
                    continue;
                }
                matcher = endpointsPattern.matcher(line);
                if (!matcher.matches()) continue;
                protocol = matcher.group(1);
                port = Integer.parseInt(matcher.group(2));
                if (networkNum == null) continue;
                listeners.add(new SCANListener(networkNum, protocol, port));
            }
        }
        return listeners;
    }

    public static Optional<SCANListener> getListenerWithNetworkNum(String oracleHome, int networkNum) {
        listeners = SCANListener.getListeners(oracleHome);
        for (SCANListener listener : listeners) {
            if (listener.networkNum != networkNum) continue;
            return Optional.of(listener);
        }
        return Optional.empty();
    }
}

