/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.models;

import java.io.File;
import java.util.Optional;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.extension.rcv.commands.RCVCommandBase;
import oracle.dbtools.extension.rcv.models.systemcommands.SystemCommand;
import oracle.dbtools.raptor.utils.TNSHelper;

public class SCAN {
    private static final Pattern scanNamePattern = Pattern.compile("SCAN name:\\s*(.*),\\s*Network:\\s*(\\d+)");
    private String name;
    private int networkNum;

    private SCAN(String name, int networkNum) {
        this.name = name;
        this.networkNum = networkNum;
    }

    public String getName() {
        return this.name;
    }

    public int getNetworkNum() {
        return this.networkNum;
    }

    public static Optional<SCAN> getInstance() {
        return SCAN.getInstance(TNSHelper.getOracleHome());
    }

    public static Optional<SCAN> getInstance(String oracleHome) {
        String srvctl = String.join((CharSequence)File.separator, oracleHome, "bin", "srvctl");
        SystemCommand.ExecutionResult result = new SystemCommand().run(srvctl, "config", "scan");
        if (result.getReturnCode() == 0) {
            String[] output;
            for (String line : output = result.getOutput().trim().split("\n")) {
                Matcher matcher = scanNamePattern.matcher(line);
                if (!matcher.matches()) continue;
                return Optional.of(new SCAN(matcher.group(1), Integer.parseInt(matcher.group(2))));
            }
        } else {
            String output = result.getOutput();
            String error = output == null ? "Failed to run srvctl config scan." : output;
            RCVCommandBase.getLogger().log(Level.FINE, error);
        }
        return Optional.empty();
    }
}

