/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.models;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.extension.rcv.utils.SshHelper;
import oracle.dbtools.extension.rcv.utils.Utils;

public class RCVContext {
    private static String localHostName;
    private static String localHostFqdn;
    private static ConcurrentHashMap<String, SshHelper> hostToSshConnection;

    public static String getLocalHost() {
        return RCVContext.getLocalHost(false);
    }

    public static String getLocalHost(boolean fullName) {
        if (fullName) {
            if (localHostFqdn == null) {
                localHostFqdn = Utils.getFullHostName();
            }
            return localHostFqdn;
        }
        if (localHostName == null) {
            localHostName = Utils.getShortHostName();
        }
        return localHostName;
    }

    public static SshHelper getSshConnection(String hostName, Logger logger) {
        int maxAttempts;
        if (hostToSshConnection.containsKey(hostName)) {
            return hostToSshConnection.get(hostName);
        }
        String username = System.getProperty("user.name");
        SshHelper sshHelper = new SshHelper(username, hostName, 22);
        for (maxAttempts = 3; maxAttempts > 0; --maxAttempts) {
            try {
                sshHelper.connect();
                break;
            }
            catch (IOException e) {
                sshHelper.disconnect();
                String error = String.format("\nFailed to establish ssh connection to remote host %s as %s: %s", hostName, username, e.getMessage());
                if (logger == null) {
                    System.out.println(error);
                } else {
                    logger.log(Level.INFO, error);
                }
                String prompt = String.format("Please enter the password for %s to authenticate to remote host %s: ", username, hostName);
                char[] sshPasswordArray = Utils.promptForPassword(prompt);
                String sshPassword = new String(sshPasswordArray);
                sshHelper = new SshHelper(username, hostName, 22);
                sshHelper.setPassword(sshPassword);
                continue;
            }
        }
        if (maxAttempts == 0) {
            throw new RuntimeException("Failed to establish ssh connection to remote host " + hostName);
        }
        hostToSshConnection.putIfAbsent(hostName, sshHelper);
        return sshHelper;
    }

    static {
        hostToSshConnection = new ConcurrentHashMap();
    }
}

