/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.models;

public class ProtectedDatabaseEngineView {
    private String dbUniqueName;
    private String libraLocation;
    private String walletLocation;
    private String credentialAlias;
    private int maxChannels;
    private String preferredBackupSite;
    private String databaseVersion;
    private String rmanVersion;
    private String fleetAgentVersion;
    private int archivalBackupInterval;
    private String encryptionAlgorithm;
    private boolean uploadPermission;
    private boolean levelOneBackup;

    private ProtectedDatabaseEngineView(Builder builder) {
        this.dbUniqueName = builder.dbUniqueName;
        this.libraLocation = builder.libraLocation;
        this.walletLocation = builder.walletLocation;
        this.credentialAlias = builder.credentialAlias;
        this.maxChannels = builder.maxChannels;
        this.preferredBackupSite = builder.preferredBackupSite;
        this.archivalBackupInterval = builder.archivalBackupInterval;
        this.encryptionAlgorithm = builder.encryptionAlgorithm;
        this.uploadPermission = builder.uploadPermission;
        this.databaseVersion = builder.databaseVersion;
        this.rmanVersion = builder.rmanVersion;
        this.fleetAgentVersion = builder.fleetAgentVersion;
        this.levelOneBackup = builder.levelOneBackup;
    }

    public String getDbUniqueName() {
        return this.dbUniqueName;
    }

    public String getLibraLocation() {
        return this.libraLocation;
    }

    public String getWalletLocation() {
        return this.walletLocation;
    }

    public String getCredentialAlias() {
        return this.credentialAlias;
    }

    public int getMaxChannels() {
        return this.maxChannels;
    }

    public String getPreferredBackupSite() {
        return this.preferredBackupSite;
    }

    public int getArchivalBackupInterval() {
        return this.archivalBackupInterval;
    }

    public String getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public boolean getUploadPermission() {
        return this.uploadPermission;
    }

    public String getDatabaseVersion() {
        return this.databaseVersion;
    }

    public String getRmanVersion() {
        return this.rmanVersion;
    }

    public String getFleetAgentVersion() {
        return this.fleetAgentVersion;
    }

    public boolean getLevelOneBackup() {
        return this.levelOneBackup;
    }

    public static class Builder {
        private String dbUniqueName;
        private String libraLocation;
        private String walletLocation;
        private String credentialAlias;
        private int maxChannels;
        private String preferredBackupSite;
        private String databaseVersion;
        private String rmanVersion;
        private String fleetAgentVersion;
        private int archivalBackupInterval;
        private String encryptionAlgorithm;
        private boolean uploadPermission;
        private boolean levelOneBackup;

        public Builder(String dbUniqueName) {
            this.dbUniqueName = dbUniqueName;
        }

        public Builder libraLocation(String libraLocation) {
            this.libraLocation = libraLocation;
            return this;
        }

        public Builder walletLocation(String walletLocation) {
            this.walletLocation = walletLocation;
            return this;
        }

        public Builder credentialAlias(String credentialAlias) {
            this.credentialAlias = credentialAlias;
            return this;
        }

        public Builder maxChannels(int maxChannels) {
            this.maxChannels = maxChannels;
            return this;
        }

        public Builder preferredBackupSite(String preferredLocation) {
            this.preferredBackupSite = preferredLocation;
            return this;
        }

        public Builder databaseVersion(String databaseVersion) {
            this.databaseVersion = databaseVersion;
            return this;
        }

        public Builder rmanVersion(String rmanVersion) {
            this.rmanVersion = rmanVersion;
            return this;
        }

        public Builder fleetAgentVersion(String fleetAgentVersion) {
            this.fleetAgentVersion = fleetAgentVersion;
            return this;
        }

        public Builder archivalBackupInterval(int minutes) {
            this.archivalBackupInterval = minutes;
            return this;
        }

        public Builder encryptionAlgorithm(String algorithm) {
            this.encryptionAlgorithm = algorithm;
            return this;
        }

        public Builder uploadPermission(boolean allowed) {
            this.uploadPermission = allowed;
            return this;
        }

        public Builder levelOneBackup(boolean levelOneBackup) {
            this.levelOneBackup = levelOneBackup;
            return this;
        }

        public ProtectedDatabaseEngineView build() {
            return new ProtectedDatabaseEngineView(this);
        }
    }
}

