/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.models;

import com.oracle.bmc.auth.ConfigFileAuthenticationDetailsProvider;
import java.io.IOException;
import java.nio.file.Paths;
import oracle.dbtools.extension.rcv.oci.InstanceMetadata;
import oracle.dbtools.extension.rcv.oci.InstanceMetadataClient;

public class OCIAuthentication {
    private Method method;
    private String configFile;
    private String profileName;
    private static final String DEFAULT_PROFILE = "DEFAULT";
    private String tenancyId;

    public OCIAuthentication() {
        this(Method.API_KEY);
    }

    public OCIAuthentication(Method method) {
        this.method = method;
        if (method.equals((Object)Method.API_KEY)) {
            this.profileName = DEFAULT_PROFILE;
            this.configFile = "~/.oci/config";
        }
    }

    public OCIAuthentication(Method method, String configFile) {
        if (method.equals((Object)Method.RESOURCE_PRINCIPAL) && configFile != null) {
            throw new IllegalArgumentException("configFile cannot be used with RESOURCE_PRINCIPAL");
        }
        this.setMethod(method);
        this.setConfigFile(configFile);
    }

    public OCIAuthentication(Method method, String configFile, String profileName) {
        if (method.equals((Object)Method.RESOURCE_PRINCIPAL) && (configFile != null || profileName != null)) {
            throw new IllegalArgumentException("configFile and profileName cannot be used with RESOURCE_PRINCIPAL");
        }
        this.setMethod(method);
        this.setConfigFile(configFile);
        this.setProfileName(profileName);
    }

    public Method getMethod() {
        return this.method;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public void setMethod(Method method) {
        this.method = method;
        if (method.equals((Object)Method.RESOURCE_PRINCIPAL)) {
            this.configFile = null;
            this.profileName = null;
        } else {
            if (this.configFile == null) {
                this.configFile = "~/.oci/config";
            }
            if (this.profileName == null) {
                this.profileName = DEFAULT_PROFILE;
            }
        }
    }

    public void setProfileName(String profileName) {
        if (this.method.equals((Object)Method.RESOURCE_PRINCIPAL) && profileName != null) {
            throw new IllegalArgumentException("profileName cannot be used with RESOURCE_PRINCIPAL");
        }
        this.profileName = this.method.equals((Object)Method.API_KEY) && profileName == null ? DEFAULT_PROFILE : profileName;
    }

    public void setConfigFile(String configFile) {
        if (this.method.equals((Object)Method.RESOURCE_PRINCIPAL) && configFile != null) {
            throw new IllegalArgumentException("configFile cannot be used with RESOURCE_PRINCIPAL");
        }
        if (this.method.equals((Object)Method.API_KEY)) {
            this.configFile = configFile == null ? "~/.oci/config" : String.valueOf(Paths.get(configFile, new String[0]).toAbsolutePath());
        }
    }

    public String getTenancyId() {
        if (this.tenancyId == null) {
            if (this.method.equals((Object)Method.API_KEY)) {
                try {
                    ConfigFileAuthenticationDetailsProvider provider = new ConfigFileAuthenticationDetailsProvider(this.getConfigFile(), this.getProfileName());
                    this.tenancyId = provider.getTenantId();
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to get tenancy ID", e);
                }
            } else {
                try {
                    InstanceMetadata instanceMetadata = new InstanceMetadata(InstanceMetadataClient.getInstanceMetadataResponse());
                    return instanceMetadata.getTenantId();
                }
                catch (IOException | InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return this.tenancyId;
    }

    public static enum Method {
        RESOURCE_PRINCIPAL,
        API_KEY;

    }
}

