/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.models;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LogArchiveDestination {
    private static final int DEFAULT_PRIORITY = 1;
    private static final int DEFAULT_NET_TIMEOUT = 30;
    private static final int DEFAULT_MAX_FAILURE = 0;
    private static final int DEFAULT_GROUP = -1;
    private String service;
    private String encryption;
    private boolean async;
    private boolean noAffirm;
    private String dbUniqueName;
    private String validFor;
    private RedoLogType redoLogType;
    private DatabaseRole databaseRole;
    private int priority = 1;
    private int netTimeout = 30;
    private int maxFailure = 0;
    private int group = -1;

    public String getService() {
        return this.service;
    }

    public String getEncryption() {
        return this.encryption;
    }

    public boolean getAsync() {
        return this.async;
    }

    public boolean getNoAffirm() {
        return this.noAffirm;
    }

    public String getDbUniqueName() {
        return this.dbUniqueName;
    }

    public String getValidFor() {
        return this.validFor;
    }

    public RedoLogType getRedoLogType() {
        return this.redoLogType;
    }

    public DatabaseRole getDatabaseRole() {
        return this.databaseRole;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getNetTimeout() {
        return this.netTimeout;
    }

    public int getMaxFailure() {
        return this.maxFailure;
    }

    public int getGroup() {
        return this.group;
    }

    public void setService(String service) {
        this.service = service;
    }

    public void setEncryption(String encryption) {
        this.encryption = encryption;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public void setNoAffirm(boolean noAffirm) {
        this.noAffirm = noAffirm;
    }

    public void setDbUniqueName(String dbUniqueName) {
        this.dbUniqueName = dbUniqueName;
    }

    public void setValidFor(String validFor) {
        this.validFor = validFor;
    }

    public void setRedoLogType(RedoLogType redoLogType) {
        this.redoLogType = redoLogType;
    }

    public void setDatabaseRole(DatabaseRole databaseRole) {
        this.databaseRole = databaseRole;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setNetTimeout(int netTimeout) {
        this.netTimeout = netTimeout;
    }

    public void setMaxFailure(int maxFailure) {
        this.maxFailure = maxFailure;
    }

    public void setGroup(int group) {
        this.group = group;
    }

    private static String getServiceFromString(String value) {
        Pattern pattern = Pattern.compile("(^service|\\s+service)=([^\\s]+)(\\s+|$)");
        Matcher matcher = pattern.matcher(value.trim().toLowerCase());
        if (matcher.find()) {
            return matcher.group(2);
        }
        return "";
    }

    public static String getEncryptionFromString(String value) {
        Pattern pattern = Pattern.compile("(^encryption|\\s+encryption)=([^\\s]+)(\\s+|$)");
        Matcher matcher = pattern.matcher(value.trim().toLowerCase());
        if (matcher.find()) {
            return matcher.group(2);
        }
        return "";
    }

    public static boolean getAsyncFromString(String value) {
        Pattern pattern = Pattern.compile("(^async|\\s+async)(\\s+|$)");
        Matcher matcher = pattern.matcher(value.trim().toLowerCase());
        return matcher.find();
    }

    public static boolean getNoAffirmFromString(String value) {
        Pattern pattern = Pattern.compile("(^noaffirm|\\s+noaffirm)(\\s+|$)");
        Matcher matcher = pattern.matcher(value.trim().toLowerCase());
        return matcher.find();
    }

    public static String getDbUniqueNameFromString(String value) {
        Pattern pattern = Pattern.compile("(^db_unique_name|\\s+db_unique_name)=([^\\s]+)(\\s+|$)");
        Matcher matcher = pattern.matcher(value.trim().toLowerCase());
        if (matcher.find()) {
            return matcher.group(2);
        }
        return "";
    }

    public static String getValidForFromString(String value) {
        Pattern pattern = Pattern.compile("(^valid_for|\\s+valid_for)=([^\\s]+)(\\s+|$)");
        Matcher matcher = pattern.matcher(value.trim().toLowerCase());
        if (matcher.find()) {
            return matcher.group(2);
        }
        return "";
    }

    public static int getPriorityFromstring(String value) {
        Pattern pattern = Pattern.compile("(^priority|\\s+priority)=(\\d+)(\\s+|$)");
        Matcher matcher = pattern.matcher(value.trim().toLowerCase());
        if (matcher.find()) {
            return Integer.parseInt(matcher.group(2));
        }
        return 1;
    }

    public static int getNetTimeOutFromString(String value) {
        Pattern pattern = Pattern.compile("(^net_timeout|\\s+net_timeout)=(\\d+)(\\s+|$)");
        Matcher matcher = pattern.matcher(value.trim().toLowerCase());
        if (matcher.find()) {
            return Integer.parseInt(matcher.group(2));
        }
        return 30;
    }

    public static int getMaxFailureFromString(String value) {
        Pattern pattern = Pattern.compile("(^max_failure|\\s+max_failure)=(\\d+)(\\s+|$)");
        Matcher matcher = pattern.matcher(value.trim().toLowerCase());
        if (matcher.find()) {
            return Integer.parseInt(matcher.group(2));
        }
        return 0;
    }

    public static int getGroupFromString(String value) {
        Pattern pattern = Pattern.compile("(^group|\\s+group)=(\\d+)(\\s+|$)");
        Matcher matcher = pattern.matcher(value.trim().toLowerCase());
        if (matcher.find()) {
            return Integer.parseInt(matcher.group(2));
        }
        return -1;
    }

    public static LogArchiveDestination createInstance(String value) {
        LogArchiveDestination destination = new LogArchiveDestination();
        destination.setService(LogArchiveDestination.getServiceFromString(value));
        destination.setEncryption(LogArchiveDestination.getEncryptionFromString(value));
        destination.setAsync(LogArchiveDestination.getAsyncFromString(value));
        destination.setNoAffirm(LogArchiveDestination.getNoAffirmFromString(value));
        destination.setDbUniqueName(LogArchiveDestination.getDbUniqueNameFromString(value));
        destination.setValidFor(LogArchiveDestination.getValidForFromString(value));
        destination.setPriority(LogArchiveDestination.getPriorityFromstring(value));
        destination.setNetTimeout(LogArchiveDestination.getNetTimeOutFromString(value));
        destination.setMaxFailure(LogArchiveDestination.getMaxFailureFromString(value));
        destination.setGroup(LogArchiveDestination.getGroupFromString(value));
        return destination;
    }

    public String toString() {
        ArrayList<Object> values = new ArrayList<Object>();
        if (this.service != null && this.service.length() > 0) {
            values.add("service=" + this.service);
        }
        if (this.encryption != null && this.encryption.length() > 0) {
            values.add("encryption=" + this.encryption);
        }
        if (this.dbUniqueName != null && this.dbUniqueName.length() > 0) {
            values.add("db_unique_name=" + this.dbUniqueName);
        }
        if (this.validFor != null && this.validFor.length() > 0) {
            values.add("valid_for=" + this.validFor);
        }
        if (this.group > 0) {
            values.add("group=" + this.group);
        }
        if (this.async) {
            values.add("ASYNC");
        }
        if (this.noAffirm) {
            values.add("NOAFFIRM");
        }
        values.add("priority=" + this.priority);
        values.add("net_timeout=" + this.netTimeout);
        values.add("max_failure=" + this.maxFailure);
        return String.join((CharSequence)" ", values);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LogArchiveDestination)) {
            return false;
        }
        return this.toString().equalsIgnoreCase(other.toString());
    }

    public static enum RedoLogType {
        ONLINE_LOGFILES,
        STANDBY_LOGFILE,
        ALL_LOGFILES;

    }

    public static enum DatabaseRole {
        PRIMARY_ROLE,
        STANDBY_ROLE,
        ALL_ROLES;

    }
}

