/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.models;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LogArchiveConfig {
    private static final String SEND = "SEND";
    private static final String NOSEND = "NOSEND";
    private static final String RECEIVE = "RECEIVE";
    private static final String NORECEIVE = "NORECEIVE";
    private static final String DG_CONFIG = "DG_CONFIG";
    private static final String NO_DGCONFIG = "NO_DGCONFIG";
    private boolean send = true;
    private boolean receive = true;
    private List<String> dgConfig;

    public LogArchiveConfig() {
        this.dgConfig = new ArrayList<String>();
    }

    public LogArchiveConfig(List<String> dgConfig) {
        this.dgConfig = dgConfig;
    }

    public LogArchiveConfig(String config) {
        this.dgConfig = new ArrayList<String>();
        String[] properties = config.trim().split("\\s+");
        if (properties.length > 0) {
            for (String p : properties) {
                if (p.equalsIgnoreCase(SEND)) {
                    this.send = true;
                    continue;
                }
                if (p.equalsIgnoreCase(NOSEND)) {
                    this.send = false;
                    continue;
                }
                if (p.equalsIgnoreCase(RECEIVE)) {
                    this.receive = true;
                    continue;
                }
                if (p.equalsIgnoreCase(NORECEIVE)) {
                    this.receive = false;
                    continue;
                }
                if (p.equalsIgnoreCase(NO_DGCONFIG)) {
                    this.dgConfig = new ArrayList<String>();
                    continue;
                }
                if (!p.toUpperCase().startsWith(DG_CONFIG)) continue;
                this.setDgConfig(p);
            }
        }
    }

    public boolean getSend() {
        return this.send;
    }

    public String getSendAsString() {
        return this.send ? SEND : NOSEND;
    }

    public boolean getReceive() {
        return this.receive;
    }

    public String getReceiveAsString() {
        return this.receive ? RECEIVE : NORECEIVE;
    }

    public List<String> getDgConfig() {
        return this.dgConfig;
    }

    public String getDgConfigAsString() {
        if (this.dgConfig == null || this.dgConfig.size() == 0) {
            return NO_DGCONFIG;
        }
        return String.format("%s=(%s)", DG_CONFIG, String.join((CharSequence)",", this.dgConfig));
    }

    public void setSend(boolean send) {
        this.send = send;
    }

    public void sendReceive(boolean receive) {
        this.receive = receive;
    }

    public void setDgConfig(List<String> dgConfig) {
        this.dgConfig = dgConfig;
    }

    public void setDgConfig(String value) {
        Pattern pattern;
        Matcher matcher;
        if (value.equalsIgnoreCase(NO_DGCONFIG)) {
            this.dgConfig = new ArrayList<String>();
            return;
        }
        if (value.toUpperCase().startsWith(DG_CONFIG) && (matcher = (pattern = Pattern.compile("DG_CONFIG=\\(([^)]+)\\)")).matcher(value.toUpperCase())).find()) {
            String config = matcher.group(1);
            this.dgConfig = Arrays.asList(config.split(",\\s*"));
            return;
        }
        this.dgConfig = new ArrayList<String>();
    }

    public String toString() {
        ArrayList<String> values = new ArrayList<String>();
        if (!this.send) {
            values.add(this.getSendAsString());
        }
        if (!this.receive) {
            values.add(this.getReceiveAsString());
        }
        if (this.dgConfig.size() > 0) {
            values.add(this.getDgConfigAsString());
        }
        return String.join((CharSequence)" ", values);
    }
}

