/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.models;

import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonReader;
import jakarta.json.JsonWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import oracle.dbtools.extension.rcv.commands.RCVCommandBase;
import oracle.dbtools.extension.rcv.models.OCIAuthentication;
import oracle.dbtools.extension.rcv.oci.DatabaseClientManager;
import oracle.dbtools.extension.rcv.oci.OCIUtils;
import oracle.dbtools.extension.rcv.workflows.Result;

public class GlobalMetadata {
    private static final String METADATA_FILE_NAME = "global_metadata.json";
    private static final String DB_SYSTEM_OCID = "dbSystemOcid";
    private static final String SYSTEM_TYPE = "systemType";
    private static final String AUTHENTICATION_TYPE = "authType";
    private static final String PROFILE_NAME = "profileName";
    private static final String OCI_CONFIG = "ociConfig";
    private static GlobalMetadata metadataInstance;
    private static String metadataDirectory;
    private static String metadataFile;
    private String systemType;
    private boolean isOCISystem;
    private String dbSystemOcid;
    private OCIAuthentication authentication;

    private GlobalMetadata() {
        if (Files.exists(Paths.get(metadataFile, new String[0]), new LinkOption[0])) {
            FileInputStream fileStream;
            File f = new File(metadataFile);
            try {
                fileStream = new FileInputStream(f);
            }
            catch (FileNotFoundException e) {
                return;
            }
            try (JsonReader jsonReader = Json.createReader((InputStream)fileStream);){
                JsonObject jsonObject = jsonReader.readObject();
                if (jsonObject.containsKey((Object)DB_SYSTEM_OCID)) {
                    this.dbSystemOcid = jsonObject.getString(DB_SYSTEM_OCID);
                }
                if (jsonObject.containsKey((Object)SYSTEM_TYPE)) {
                    this.systemType = jsonObject.getString(SYSTEM_TYPE);
                }
                if (jsonObject.containsKey((Object)AUTHENTICATION_TYPE)) {
                    String authType = jsonObject.getString(AUTHENTICATION_TYPE);
                    this.authentication = new OCIAuthentication(OCIAuthentication.Method.valueOf(authType.toUpperCase()));
                    if (jsonObject.containsKey((Object)OCI_CONFIG)) {
                        this.authentication.setConfigFile(jsonObject.getString(OCI_CONFIG));
                    }
                    if (jsonObject.containsKey((Object)PROFILE_NAME)) {
                        this.authentication.setProfileName(jsonObject.getString(PROFILE_NAME));
                    }
                }
            }
            catch (Exception e) {
                throw Result.metadataJsonProcessingException(metadataFile, e);
            }
        }
        if (this.authentication == null) {
            this.authentication = new OCIAuthentication();
        }
    }

    public static synchronized GlobalMetadata load() {
        if (metadataInstance == null) {
            metadataInstance = new GlobalMetadata();
        }
        return metadataInstance;
    }

    public void save() {
        if (!Files.exists(Paths.get(metadataDirectory, new String[0]), new LinkOption[0])) {
            GlobalMetadata.createMetadataDirectory();
        }
        JsonObjectBuilder builder = Json.createObjectBuilder();
        if (this.dbSystemOcid != null) {
            builder.add(DB_SYSTEM_OCID, this.dbSystemOcid);
        }
        if (this.systemType != null) {
            builder.add(SYSTEM_TYPE, this.systemType);
        }
        if (this.authentication != null) {
            OCIAuthentication.Method method = this.authentication.getMethod();
            String ociConfig = this.authentication.getConfigFile();
            String profileName = this.authentication.getProfileName();
            builder.add(AUTHENTICATION_TYPE, method.toString());
            if (method.equals((Object)OCIAuthentication.Method.API_KEY)) {
                if (ociConfig != null) {
                    builder.add(OCI_CONFIG, ociConfig);
                } else {
                    builder.add(OCI_CONFIG, "~/.oci/config");
                }
                if (profileName != null) {
                    builder.add(PROFILE_NAME, profileName);
                } else {
                    builder.add(PROFILE_NAME, "DEFAULT");
                }
            }
        }
        File f = new File(metadataFile);
        try (JsonWriter writer = Json.createWriter((OutputStream)new FileOutputStream(f));){
            writer.writeObject(builder.build());
        }
        catch (Exception e) {
            throw Result.metadataFileSaveException(metadataFile, e);
        }
    }

    public String getSystemType() {
        if (this.systemType == null) {
            boolean isOCI;
            this.systemType = System.getenv("ADE_VIEW_ROOT") != null ? "ON_PREMISES" : ((isOCI = OCIUtils.amIInOCI()) ? "OCI" : "ON_PREMISES");
        }
        return this.systemType;
    }

    public String getDbSystemOcid() {
        if (this.dbSystemOcid == null && this.getSystemType().equals("OCI")) {
            try {
                this.dbSystemOcid = DatabaseClientManager.getDbSystemOcid();
            }
            catch (IOException | InterruptedException e) {
                return null;
            }
        }
        return this.dbSystemOcid;
    }

    public OCIAuthentication getAuthentication() {
        return this.authentication;
    }

    public static String getMetadataFile() {
        return metadataFile;
    }

    public void setDbSystemOcid(String ocid) {
        this.dbSystemOcid = ocid;
    }

    public void setSystemType(String systemType) {
        this.systemType = systemType;
    }

    public void setAuthentication(OCIAuthentication auth) {
        this.authentication = auth;
    }

    public static void createMetadataDirectory() {
        String metadataDirectory = RCVCommandBase.getGlobalMetadataDirectory();
        if (!Files.exists(Paths.get(metadataDirectory, new String[0]), new LinkOption[0])) {
            try {
                Files.createDirectories(Paths.get(metadataDirectory, new String[0]), new FileAttribute[0]);
            }
            catch (Exception e) {
                throw Result.metadataGlobalDirectoryException(metadataDirectory, e);
            }
        }
    }

    static {
        metadataDirectory = RCVCommandBase.getGlobalMetadataDirectory();
        metadataFile = String.join((CharSequence)File.separator, metadataDirectory, METADATA_FILE_NAME);
    }
}

